/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.OperandStackEntry;
import java.util.Stack;

public class OperandStack
implements Cloneable {
    private int max_stack_size = 0;
    private int current_stack_size = 0;
    private Stack<OperandStackEntry> operand_stack = new Stack();

    public int getMaxStackSize() {
        return this.max_stack_size;
    }

    public int getCurrentStackSize() {
        return this.current_stack_size;
    }

    public OperandStackEntry[] getStackEntries() {
        Object[] objectArray = new OperandStackEntry[this.operand_stack.size()];
        this.operand_stack.copyInto(objectArray);
        return objectArray;
    }

    public void promote(int n) {
        if (n <= 0 || n > this.operand_stack.size()) {
            throw new ConverterInternalError();
        }
        int n2 = this.operand_stack.size() - n;
        OperandStackEntry operandStackEntry = (OperandStackEntry)this.operand_stack.elementAt(n2);
        operandStackEntry.setType(3);
        ++this.current_stack_size;
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public OperandStackEntry peek(int n) {
        if (n <= 0 || n > this.operand_stack.size()) {
            throw new ConverterInternalError();
        }
        int n2 = this.operand_stack.size() - n;
        return (OperandStackEntry)this.operand_stack.elementAt(n2);
    }

    public void push(OperandStackEntry operandStackEntry) {
        this.current_stack_size += operandStackEntry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
        this.operand_stack.push(operandStackEntry);
    }

    public void push(int n, InstrContainer instrContainer) {
        OperandStackEntry operandStackEntry = new OperandStackEntry(n, instrContainer);
        this.operand_stack.push(operandStackEntry);
        this.current_stack_size += operandStackEntry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public void push(int n, InstrContainer instrContainer, boolean bl) {
        OperandStackEntry operandStackEntry = new OperandStackEntry(n, instrContainer);
        operandStackEntry.setTypeKnown(bl);
        this.operand_stack.push(operandStackEntry);
        this.current_stack_size += operandStackEntry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public OperandStackEntry pop() {
        if (this.operand_stack.isEmpty()) {
            return null;
        }
        OperandStackEntry operandStackEntry = this.operand_stack.pop();
        this.current_stack_size -= operandStackEntry.getSizeInWords();
        return operandStackEntry;
    }

    public void dup(InstrContainer instrContainer) {
        OperandStackEntry operandStackEntry = this.operand_stack.peek();
        OperandStackEntry operandStackEntry2 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry2.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            InstrContainer instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry2.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry2);
    }

    public void dup2(InstrContainer instrContainer) {
        InstrContainer instrContainer2;
        OperandStackEntry operandStackEntry = this.peek(1);
        OperandStackEntry operandStackEntry2 = this.peek(2);
        OperandStackEntry operandStackEntry3 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry3.setInstrContainer(instrContainer);
        OperandStackEntry operandStackEntry4 = (OperandStackEntry)operandStackEntry2.clone();
        operandStackEntry4.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry3.setRollBackPoint(instrContainer2);
        }
        if (operandStackEntry2.getType() == 1 || operandStackEntry2.getType() == 2) {
            instrContainer2 = operandStackEntry2.getRollBackPoint() != null ? operandStackEntry2.getRollBackPoint() : operandStackEntry2.getInstrContainer();
            operandStackEntry4.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry4);
        this.push(operandStackEntry3);
    }

    public void dup_x1(InstrContainer instrContainer) {
        OperandStackEntry operandStackEntry = this.pop();
        OperandStackEntry operandStackEntry2 = this.pop();
        OperandStackEntry operandStackEntry3 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry3.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            InstrContainer instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry3.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry3);
        this.push(operandStackEntry2);
        this.push(operandStackEntry);
    }

    public void dup_x2(InstrContainer instrContainer) {
        OperandStackEntry operandStackEntry = this.pop();
        OperandStackEntry operandStackEntry2 = this.pop();
        OperandStackEntry operandStackEntry3 = this.pop();
        OperandStackEntry operandStackEntry4 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry4.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            InstrContainer instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry4.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry4);
        this.push(operandStackEntry3);
        this.push(operandStackEntry2);
        this.push(operandStackEntry);
    }

    public void dup2_x1(InstrContainer instrContainer) {
        InstrContainer instrContainer2;
        OperandStackEntry operandStackEntry = this.pop();
        OperandStackEntry operandStackEntry2 = this.pop();
        OperandStackEntry operandStackEntry3 = this.pop();
        OperandStackEntry operandStackEntry4 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry4.setInstrContainer(instrContainer);
        OperandStackEntry operandStackEntry5 = (OperandStackEntry)operandStackEntry2.clone();
        operandStackEntry5.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry4.setRollBackPoint(instrContainer2);
        }
        if (operandStackEntry2.getType() == 1 || operandStackEntry2.getType() == 2) {
            instrContainer2 = operandStackEntry2.getRollBackPoint() != null ? operandStackEntry2.getRollBackPoint() : operandStackEntry2.getInstrContainer();
            operandStackEntry5.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry5);
        this.push(operandStackEntry4);
        this.push(operandStackEntry3);
        this.push(operandStackEntry2);
        this.push(operandStackEntry);
    }

    public void dup2_x2(InstrContainer instrContainer) {
        InstrContainer instrContainer2;
        OperandStackEntry operandStackEntry = this.pop();
        OperandStackEntry operandStackEntry2 = this.pop();
        OperandStackEntry operandStackEntry3 = this.pop();
        OperandStackEntry operandStackEntry4 = this.pop();
        OperandStackEntry operandStackEntry5 = (OperandStackEntry)operandStackEntry.clone();
        operandStackEntry5.setInstrContainer(instrContainer);
        OperandStackEntry operandStackEntry6 = (OperandStackEntry)operandStackEntry2.clone();
        operandStackEntry6.setInstrContainer(instrContainer);
        if (operandStackEntry.getType() == 1 || operandStackEntry.getType() == 2) {
            instrContainer2 = operandStackEntry.getRollBackPoint() != null ? operandStackEntry.getRollBackPoint() : operandStackEntry.getInstrContainer();
            operandStackEntry5.setRollBackPoint(instrContainer2);
        }
        if (operandStackEntry2.getType() == 1 || operandStackEntry2.getType() == 2) {
            instrContainer2 = operandStackEntry2.getRollBackPoint() != null ? operandStackEntry2.getRollBackPoint() : operandStackEntry2.getInstrContainer();
            operandStackEntry6.setRollBackPoint(instrContainer2);
        }
        this.push(operandStackEntry6);
        this.push(operandStackEntry5);
        this.push(operandStackEntry4);
        this.push(operandStackEntry3);
        this.push(operandStackEntry2);
        this.push(operandStackEntry);
    }

    public void swap(InstrContainer instrContainer) {
        OperandStackEntry operandStackEntry = this.pop();
        OperandStackEntry operandStackEntry2 = this.pop();
        this.push(operandStackEntry);
        this.push(operandStackEntry2);
    }

    public synchronized Object clone() {
        try {
            OperandStack operandStack = (OperandStack)super.clone();
            operandStack.operand_stack = (Stack)this.operand_stack.clone();
            return operandStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConverterInternalError();
        }
    }
}

