/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils.instructions;

import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Instr;
import java.util.Vector;

public class JCPushInstr
extends Instruction {
    private Vector<Integer> argVector = new Vector();

    public JCPushInstr(Instr instr, ClassConstantPool classConstantPool) {
        super(instr);
        Object var3_3 = null;
        switch (instr.opcode) {
            case 16: 
            case 18: {
                this.pushByte(new Integer(instr.arg & 0xFF));
                break;
            }
            case 17: 
            case 19: {
                this.pushShort(instr.arg);
                break;
            }
            case 20: {
                this.pushInteger(instr.arg, classConstantPool);
            }
        }
    }

    public JCPushInstr(int n, ClassConstantPool classConstantPool) {
        super(null);
        Object var3_3 = null;
        if (n >= -128 && n < 128) {
            this.pushByte(n);
        } else if (n >= Short.MIN_VALUE && n < 32768) {
            this.pushShort(n);
        } else {
            this.pushInteger(n, classConstantPool);
        }
    }

    private void pushByte(int n) {
        this.argVector.add(new Integer(n));
        this.javaInstructions.add(new JavaInstruction(16, this.argVector));
    }

    private void pushShort(int n) {
        byte[] byArray = Util.getShortBytes((short)n);
        this.argVector.add(new Integer(byArray[0] & 0xFF));
        this.argVector.add(new Integer(byArray[1] & 0xFF));
        this.javaInstructions.add(new JavaInstruction(17, this.argVector));
    }

    private void pushInteger(int n, ClassConstantPool classConstantPool) {
        int n2 = classConstantPool.addInteger(n);
        if (n2 < 255) {
            this.argVector.add(new Integer(n2 & 0xFF));
            this.javaInstructions.add(new JavaInstruction(18, this.argVector));
        } else {
            byte[] byArray = Util.getShortBytes((short)n2);
            this.argVector.add(new Integer(byArray[0] & 0xFF));
            this.argVector.add(new Integer(byArray[1] & 0xFF));
            this.javaInstructions.add(new JavaInstruction(19, this.argVector));
        }
    }
}

