/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.ClientT0Protocol;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT0Client
extends CadT0
implements CadClientInterface {
    protected TLP224Message responseMsg;
    protected TLP224Message commandMsg = new TLP224Message(new byte[258]);
    protected ClientProtocol protocol;

    public CadT0Client(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
        this.responseMsg = new TLP224Message(new byte[258]);
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, CadTransportException {
        if (this.protocol == null) {
            throw new TLP224Exception(21);
        }
        this.protocol.exchangeApdu(apdu);
    }

    @Override
    public void powerDown() throws IOException, CadTransportException {
        this.powerDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void powerDown(boolean bl) throws IOException, CadTransportException {
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] byArray = this.commandMsg.getData();
            byArray[0] = 96;
            byArray[1] = 1;
            byArray[2] = 77;
            byArray[3] = (byte)this.commandMsg.computeLRC(3);
            this.commandMsg.setLength(4);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            byArray = this.responseMsg.getData();
            if (byArray[2] != 0) {
                throw new TLP224Exception(byArray[2] & 0xFF);
            }
        }
        this.protocol = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] powerUp() throws IOException, CadTransportException {
        byte[] byArray = null;
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] byArray2 = this.commandMsg.getData();
            byArray2[0] = 96;
            byArray2[1] = 4;
            byArray2[2] = 110;
            byArray2[3] = 0;
            byArray2[4] = 0;
            byArray2[5] = 0;
            byArray2[6] = (byte)this.commandMsg.computeLRC(6);
            this.commandMsg.setLength(7);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            byArray2 = this.responseMsg.getData();
            if (byArray2[2] == 0) {
                byArray = new byte[byArray2[5]];
                System.arraycopy(byArray2, 6, byArray, 0, byArray2[5]);
            } else {
                if (byArray2[2] != -9) throw new TLP224Exception(byArray2[2] & 0xFF);
                this.sendTLP224Message(this.commandMsg);
                this.receiveTLP224Message(this.responseMsg);
                if (byArray2[2] != 0) throw new TLP224Exception(byArray2[2] & 0xFF);
                byArray = new byte[byArray2[5]];
                System.arraycopy(byArray2, 6, byArray, 0, byArray2[5]);
            }
        }
        this.protocol = new ClientT0Protocol(this);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int isoIn(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws IOException, TLP224Exception {
        if (n > 249) {
            throw new TLP224Exception(18);
        }
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] byArray4 = this.commandMsg.getData();
            byArray4[0] = 96;
            byArray4[1] = (byte)(n + 6);
            byArray4[2] = -38;
            System.arraycopy(byArray, 0, byArray4, 3, 4);
            byArray4[7] = (byte)n;
            if (n > 0) {
                System.arraycopy(byArray2, 0, byArray4, 8, n);
            }
            byArray4[n + 8] = (byte)this.commandMsg.computeLRC(n + 8);
            this.commandMsg.setLength(n + 9);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            byArray4 = this.responseMsg.getData();
            byArray3[0] = byArray4[3];
            byArray3[1] = byArray4[4];
            return byArray4[2] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int isoOut(byte[] byArray, byte[] byArray2, int[] nArray, byte[] byArray3) throws IOException, TLP224Exception {
        int n = nArray[0];
        if (n > 249) {
            throw new TLP224Exception(18);
        }
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] byArray4 = this.commandMsg.getData();
            byArray4[0] = 96;
            byArray4[1] = 6;
            byArray4[2] = -37;
            System.arraycopy(byArray, 0, byArray4, 3, 4);
            byArray4[7] = (byte)n;
            byArray4[8] = (byte)this.commandMsg.computeLRC(8);
            this.commandMsg.setLength(9);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            byArray4 = this.responseMsg.getData();
            if (byArray4[1] == 3) {
                byArray3[0] = byArray4[3];
                byArray3[1] = byArray4[4];
                nArray[1] = 0;
            } else {
                int n2 = this.responseMsg.getLength() - 6;
                System.arraycopy(byArray4, 3, byArray2, 0, n2);
                byArray3[0] = byArray4[3 + n2];
                byArray3[1] = byArray4[4 + n2];
                nArray[1] = n2;
            }
            return byArray4[2] & 0xFF;
        }
    }
}

