/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.properties;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;
import org.netbeans.modules.spellchecker.bindings.properties.AbstractTokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PropertiesTokenList
extends AbstractTokenList {
    private boolean hidden = false;

    public PropertiesTokenList(BaseDocument doc) {
        super(doc);
    }

    public void setStartOffset(int offset) {
        super.setStartOffset(offset);
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/Properties");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    protected int[] findNextSpellSpan(SyntaxSupport ts, int offset) throws BadLocationException {
        if (ts == null || this.hidden) {
            return new int[]{-1, -1};
        }
        TokenItem item = null;
        int documentLength = ts.getDocument().getLength();
        if (offset < documentLength) {
            item = ((ExtSyntaxSupport)ts).getTokenChain(offset, documentLength);
        }
        while (item != null && item.getTokenID() != PropertiesTokenContext.VALUE) {
            item = item.getNext();
        }
        if (item == null) {
            return new int[]{-1, -1};
        }
        return new int[]{item.getOffset(), item.getOffset() + item.getImage().length()};
    }
}

