/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public final class Utils {
    private static final RequestProcessor vcsRequestProcessor = new RequestProcessor("Versioning", 1);
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);
    private static final RequestProcessor vcsParallelRequestProcessor = new RequestProcessor("Versioning parallel tasks", 5, true);
    private static File[] unversionedFolders;
    private static Logger METRICS_LOG;
    private static Set<String> metrics;
    private static File tempDir;
    private static Map<File, Charset> fileToCharset;
    private static VCSKenaiAccessor kenaiAccessor;
    private static final LinkedList<File> loggedRoots;
    private static final List<File> foldersToCheck;
    private static Runnable loggingTask;

    private Utils() {
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static void post(Runnable runnable) {
        Utils.post(runnable, 0);
    }

    public static void post(Runnable runnable, int timeToWait) {
        vcsRequestProcessor.post(runnable, timeToWait);
    }

    public static void postParallel(Runnable runnable, int timeToWait) {
        vcsParallelRequestProcessor.post(runnable, timeToWait);
    }

    public static boolean isAncestorOrEqual(File ancestor, File file) {
        if (VersioningSupport.isFlat((File)ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        String filePath = file.getAbsolutePath();
        String ancestorPath = ancestor.getAbsolutePath();
        if (Utilities.isWindows() ? filePath.indexOf("~") < 0 && ancestorPath.indexOf("~") < 0 && filePath.length() < ancestorPath.length() : (Utilities.isMac() ? filePath.length() < ancestorPath.length() : !filePath.startsWith(ancestorPath))) {
            return false;
        }
        while (file != null) {
            if (file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static boolean shareCommonDataObject(File[] files) {
        if (files == null || files.length < 2) {
            return true;
        }
        DataObject common = Utils.findDataObject(files[0]);
        for (int i = 1; i < files.length; ++i) {
            DataObject dao = Utils.findDataObject(files[i]);
            if (dao == common || dao != null && dao.equals(common)) continue;
            return false;
        }
        return true;
    }

    public static Set<File> getAllDataObjectFiles(File file) {
        HashSet<File> filesToCheckout = new HashSet<File>(2);
        filesToCheckout.add(file);
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                Set fileObjects = dao.files();
                for (FileObject fileObject : fileObjects) {
                    filesToCheckout.add(FileUtil.toFile((FileObject)fileObject));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return filesToCheckout;
    }

    private static DataObject findDataObject(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                return DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isFileContentText(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        if (fo.getMIMEType().startsWith("text")) {
            return true;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getLookup().lookupItem(new Lookup.Template(EditorCookie.class)) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static List<String> getStringList(Preferences prefs, String key) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key)) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                retval.add(idx + "." + prefs.get(k, null));
            }
            ArrayList<String> rv = new ArrayList<String>(retval.size());
            rv.addAll(retval);
            for (String s : retval) {
                int pos = s.indexOf(46);
                int index = Integer.parseInt(s.substring(0, pos));
                rv.set(index, s.substring(pos + 1));
            }
            return rv;
        }
        catch (Exception ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
            return new ArrayList<String>(0);
        }
    }

    public static void put(Preferences prefs, String key, List<String> value) {
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key + ".")) continue;
                prefs.remove(k);
            }
            int idx = 0;
            for (String s : value) {
                prefs.put(key + "." + idx++, s);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
        }
    }

    public static void insert(Preferences prefs, String key, String value, int maxLength) {
        List<String> newValues = Utils.getStringList(prefs, key);
        if (newValues.contains(value)) {
            newValues.remove(value);
        }
        newValues.add(0, value);
        if (maxLength > -1 && newValues.size() > maxLength) {
            newValues.subList(maxLength, newValues.size()).clear();
        }
        Utils.put(prefs, key, newValues);
    }

    public static void removeFromArray(Preferences prefs, String key, List<String> values) {
        List<String> newValues = Utils.getStringList(prefs, key);
        newValues.removeAll(values);
        Utils.put(prefs, key, newValues);
    }

    public static void removeFromArray(Preferences prefs, String key, String value) {
        List<String> newValues = Utils.getStringList(prefs, key);
        newValues.remove(value);
        Utils.put(prefs, key, newValues);
    }

    public static File[][] splitFlatOthers(File[] files) {
        HashSet<File> flat = new HashSet<File>(1);
        for (int i = 0; i < files.length; ++i) {
            if (!VersioningSupport.isFlat((File)files[i])) continue;
            flat.add(files[i]);
        }
        if (flat.size() == 0) {
            return new File[][]{new File[0], files};
        }
        HashSet<File> allFiles = new HashSet<File>(Arrays.asList(files));
        allFiles.removeAll(flat);
        return new File[][]{flat.toArray(new File[flat.size()]), allFiles.toArray(new File[allFiles.size()])};
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static File getCommonParent(File a, File b) {
        do {
            if (!a.equals(b)) continue;
            return a;
        } while (!(a.getAbsolutePath().length() > b.getAbsolutePath().length() ? (a = a.getParentFile()) == null : (b = b.getParentFile()) == null));
        return null;
    }

    public static String getStackTrace() {
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    public static Point getPositionForPopup(JTable table) {
        int idx = table.getSelectedRow();
        if (idx == -1) {
            idx = 0;
        }
        Rectangle rect = table.getCellRect(idx, 1, true);
        return rect.getLocation();
    }

    public static Point getPositionForPopup(JList list) {
        int idx = list.getSelectedIndex();
        if (idx == -1) {
            idx = 0;
        }
        Rectangle rect = list.getCellBounds(idx, idx);
        rect.x += 10;
        rect.y += rect.height;
        return rect.getLocation();
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static File getTempFolder() {
        return Utils.getTempFolder(true);
    }

    public static File getTempFolder(boolean deleteOnExit) {
        File dir;
        File tmpDir = Utils.getTempDir(deleteOnExit);
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        if (deleteOnExit) {
            dir.deleteOnExit();
        }
        return FileUtil.normalizeFile((File)dir);
    }

    public static String wordWrap(String s, int maxLineLength) {
        int n = s.length() - 1;
        if (maxLineLength < 1 || n < maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int currentWrap = 0;
        while (true) {
            int nextWrap;
            if ((nextWrap = currentWrap + maxLineLength - 1) >= n) break;
            int idx = s.lastIndexOf(32, nextWrap + 1);
            if (idx > currentWrap) {
                sb.append(s.substring(currentWrap, idx).trim());
                currentWrap = idx + 1;
            } else {
                sb.append(s.substring(currentWrap, nextWrap + 1));
                currentWrap = nextWrap + 1;
            }
            sb.append('\n');
        }
        sb.append(s.substring(currentWrap));
        return sb.toString();
    }

    public static String getActionName(Class clazz, String baseName, VCSContext ctx) {
        Set nodes = ctx.getRootFiles();
        int objectCount = nodes.size();
        Node[] activatedNodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return NbBundle.getBundle((Class)clazz).getString(baseName);
        }
        if (objectCount == 1) {
            String name;
            if (projectsOnly) {
                String dispName = ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage((Class)clazz, (String)(baseName + "_Context"), (Object)dispName);
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                name = fo.getNameExt();
            } else {
                DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
                if (dao instanceof DataShadow) {
                    dao = ((DataShadow)dao).getOriginal();
                }
                name = dao != null ? dao.getPrimaryFile().getNameExt() : activatedNodes[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Context"), name);
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Projects"), objectCount);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(baseName + "_Context_Multiple"), objectCount);
    }

    public static String getContextDisplayName(VCSContext ctx) {
        Set nodes = ctx.getFiles();
        int objectCount = nodes.size();
        Node[] activatedNodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return null;
        }
        if (objectCount == 1) {
            if (projectsOnly) {
                return ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                return fo.getNameExt();
            }
            DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            if (dao != null) {
                return dao.getPrimaryFile().getNameExt();
            }
            return activatedNodes[0].getDisplayName();
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleProjects"), objectCount);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleFiles"), objectCount);
    }

    public static CloneableEditorSupport openFile(FileObject fo, String revision) {
        ViewEnv env = new ViewEnv(fo);
        ViewCES ces = new ViewCES(env, fo.getNameExt() + " @ " + revision, FileEncodingQuery.getEncoding((FileObject)fo));
        ces.view();
        return ces;
    }

    public static boolean isScanForbidden(File folder) {
        if (folder.getPath().startsWith("\\\\")) {
            return folder.getParent() == null || folder.getParent().equals("\\\\");
        }
        for (File unversionedFolder : unversionedFolders) {
            if (!Utils.isAncestorOrEqual(unversionedFolder, folder)) continue;
            return true;
        }
        return false;
    }

    public static void openFile(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                OpenCookie oc = (OpenCookie)dao.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associateEncoding(File referenceFile, File file) {
        FileObject fo = FileUtil.toFileObject((File)referenceFile);
        if (fo == null || fo.isFolder()) {
            return;
        }
        Charset c = FileEncodingQuery.getEncoding((FileObject)fo);
        if (c == null) {
            return;
        }
        if (fileToCharset == null) {
            fileToCharset = new WeakHashMap<File, Charset>();
        }
        Map<File, Charset> map = fileToCharset;
        synchronized (map) {
            fileToCharset.put(file, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getAssociatedEncoding(FileObject fo) {
        try {
            if (fileToCharset == null || fileToCharset.isEmpty() || fo == null || fo.isFolder()) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                return null;
            }
            Map<File, Charset> map = fileToCharset;
            synchronized (map) {
                return fileToCharset.get(file);
            }
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(1, t);
            return null;
        }
    }

    public static Reader createReader(File file) throws FileNotFoundException {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return new FileReader(file);
        }
        return Utils.createReader(fo);
    }

    public static Reader createReader(FileObject file) throws FileNotFoundException {
        return new InputStreamReader(file.getInputStream(), FileEncodingQuery.getEncoding((FileObject)file));
    }

    public static void logInfo(Class caller, Throwable e) {
        Logger.getLogger(caller.getName()).log(Level.INFO, e.getMessage(), e);
    }

    public static void logWarn(Class caller, Throwable e) {
        Logger.getLogger(caller.getName()).log(Level.WARNING, e.getMessage(), e);
    }

    public static void logError(Object caller, Throwable e) {
        Logger.getLogger(caller.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
    }

    public static void logFine(Object caller, Exception e) {
        Logger.getLogger(caller.getClass().getName()).log(Level.FINE, e.getMessage(), e);
    }

    public static void logWarn(Object caller, Throwable e) {
        Utils.logWarn(caller.getClass(), e);
    }

    public static void logVCSClientEvent(String vcs, String client) {
        String key = "USG_VCS_CLIENT" + vcs;
        if (Utils.checkMetricsKey(key)) {
            return;
        }
        LogRecord rec = new LogRecord(Level.INFO, "USG_VCS_CLIENT");
        rec.setParameters(new Object[]{vcs, client});
        rec.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(rec);
    }

    public static void logVCSActionEvent(String vcs) {
        String key = "USG_VCS_ACTION" + vcs;
        if (Utils.checkMetricsKey(key)) {
            return;
        }
        LogRecord rec = new LogRecord(Level.INFO, "USG_VCS_ACTION");
        rec.setParameters(new Object[]{vcs});
        rec.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMetricsKey(String key) {
        Set<String> set = metrics;
        synchronized (set) {
            if (metrics.contains(key)) {
                return true;
            }
            metrics.add(key);
        }
        return false;
    }

    public static void setReadOnly(File file, boolean readOnly) {
        String[] args = Utilities.isWindows() ? new String[]{"attrib", readOnly ? "+r" : "-r", file.getName()} : new String[]{"chmod", readOnly ? "u-w" : "u+w", file.getName()};
        try {
            Process process = Runtime.getRuntime().exec(args, null, file.getParentFile());
            process.waitFor();
        }
        catch (Exception e) {
            Utils.logWarn(Utils.class, (Throwable)e);
        }
    }

    public static String skipUnsupportedVariables(String string, String[] supportedVariables) {
        String ret = string;
        Pattern p = Pattern.compile("\\{\\w*\\}");
        Matcher m = p.matcher(string);
        while (m.find()) {
            String g = m.group();
            boolean isVar = false;
            for (String var : supportedVariables) {
                if (!var.equals(g)) continue;
                isVar = true;
                break;
            }
            if (isVar) continue;
            ret = ret.replace(g, "");
        }
        return ret;
    }

    public static boolean isFromMultiFileDataObject(VCSContext ctx) {
        Collection allSets;
        if (ctx != null && (allSets = ctx.getElements().lookupAll(Set.class)) != null) {
            for (Set contextElements : allSets) {
                if (!"org.openide.loaders.DataNode$LazyFilesSet".equals(contextElements.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getPriority(String versioningSystem) {
        Integer value = null;
        String propName = "versioning." + versioningSystem + ".priority";
        String sValue = System.getProperty(propName, null);
        if (sValue != null && !sValue.isEmpty()) {
            try {
                value = Integer.parseInt(sValue);
                if (value <= 0) {
                    value = null;
                }
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(Utils.class.getName()).log(Level.INFO, "Wrong priority ({0}) value {1}, using default value", new Object[]{propName, sValue});
            }
        }
        if (value == null) {
            value = Integer.MAX_VALUE;
        }
        return value;
    }

    private static File getTempDir(boolean deleteOnExit) {
        block2: {
            File dir;
            if (tempDir != null) break block2;
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
            }
            tempDir = FileUtil.normalizeFile((File)dir);
            if (deleteOnExit) {
                tempDir.deleteOnExit();
            }
        }
        return tempDir;
    }

    public static void logVCSKenaiUsage(String vcs, String repositoryUrl) {
        VCSKenaiAccessor kenaiSup = Utils.getKenaiAccessor();
        if (kenaiSup != null) {
            kenaiSup.logVcsUsage(vcs, repositoryUrl);
        }
    }

    private static VCSKenaiAccessor getKenaiAccessor() {
        if (kenaiAccessor == null) {
            kenaiAccessor = (VCSKenaiAccessor)Lookup.getDefault().lookup(VCSKenaiAccessor.class);
        }
        return kenaiAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFolderToLog(File folder) {
        if (!Utils.checkFolderLogged(folder, false)) {
            List<File> list = foldersToCheck;
            synchronized (list) {
                foldersToCheck.add(folder);
                if (loggingTask == null) {
                    loggingTask = new LogTask();
                    Utils.postParallel(loggingTask, 2000);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkFolderLogged(File folder, boolean add) {
        LinkedList<File> linkedList = loggedRoots;
        synchronized (linkedList) {
            for (File f : loggedRoots) {
                String ancestorPath = f.getPath();
                String folderPath = folder.getPath();
                if (!folderPath.startsWith(ancestorPath) || folderPath.length() != ancestorPath.length() && folderPath.charAt(ancestorPath.length()) != File.separatorChar) continue;
                return true;
            }
            if (add) {
                loggedRoots.add(folder);
            }
        }
        return false;
    }

    public static String getHash(String alg, byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance(alg);
        md5.update(bytes);
        byte[] md5digest = md5.digest();
        String ret = "";
        for (int i = 0; i < md5digest.length; ++i) {
            String hex = Integer.toHexString(md5digest[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret = ret + hex + (i < md5digest.length - 1 ? ":" : "");
        }
        return ret;
    }

    public static Set<File> getOpenFiles() {
        TopComponent[] comps = TopComponent.getRegistry().getOpened().toArray(new TopComponent[0]);
        HashSet<File> openFiles = new HashSet<File>(comps.length);
        for (TopComponent tc : comps) {
            Node[] nodes = tc.getActivatedNodes();
            if (nodes == null) continue;
            for (Node node : nodes) {
                FileObject fo;
                File file = (File)node.getLookup().lookup(File.class);
                if (file == null && (fo = (FileObject)node.getLookup().lookup(FileObject.class)) != null) {
                    file = FileUtil.toFile((FileObject)fo);
                }
                if (file == null) continue;
                openFiles.add(file);
            }
        }
        return openFiles;
    }

    static {
        METRICS_LOG = Logger.getLogger("org.netbeans.ui.metrics.vcs");
        metrics = new HashSet<String>(3);
        try {
            String uf = VersioningSupport.getPreferences().get("unversionedFolders", null);
            String ufProp = System.getProperty("versioning.unversionedFolders", null);
            if (ufProp != null && ufProp.length() > 0) {
                String string = uf = uf == null || uf.length() == 0 ? ufProp : uf + ";" + ufProp;
            }
            if (uf == null || uf.length() == 0) {
                unversionedFolders = new File[0];
            } else {
                String[] paths = uf.split("\\;");
                unversionedFolders = new File[paths.length];
                int idx = 0;
                for (String path : paths) {
                    Utils.unversionedFolders[idx++] = new File(path);
                }
            }
        }
        catch (Exception e) {
            unversionedFolders = new File[0];
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, e.getMessage(), e);
        }
        loggedRoots = new LinkedList();
        foldersToCheck = new LinkedList<File>();
        loggingTask = null;
    }

    private static class LogTask
    implements Runnable {
        private LogTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File[] folders;
            List list = foldersToCheck;
            synchronized (list) {
                folders = foldersToCheck.toArray(new File[foldersToCheck.size()]);
                foldersToCheck.clear();
                loggingTask = null;
            }
            for (File f : folders) {
                String url;
                File root;
                VersioningSystem vs;
                if (Utils.checkFolderLogged(f, false) || (vs = VersioningSupport.getOwner((File)f)) == null || (root = vs.getTopmostManagedAncestor(f)) == null) continue;
                Utils.checkFolderLogged(root, true);
                FileObject rootFO = FileUtil.toFileObject((File)root);
                if (rootFO == null || (url = (String)rootFO.getAttribute("ProvidedExtensions.RemoteLocation")) == null) continue;
                Object name = vs.getProperty("String VCS.DisplayName");
                if (!(name instanceof String)) {
                    name = vs.getClass().getSimpleName();
                }
                Utils.logVCSKenaiUsage(name.toString(), url);
            }
        }
    }

    private static class ViewCES
    extends CloneableEditorSupport {
        private final String name;
        private final Charset charset;

        public ViewCES(CloneableEditorSupport.Env env, String name, Charset charset) {
            super(env);
            this.name = name;
            this.charset = charset;
        }

        protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
            kit.read(new InputStreamReader(stream, this.charset), (Document)doc, 0);
        }

        protected String messageSave() {
            return this.name;
        }

        protected String messageName() {
            return this.name;
        }

        protected String messageToolTip() {
            return this.name;
        }

        protected String messageOpening() {
            return this.name;
        }

        protected String messageOpened() {
            return this.name;
        }

        protected boolean asynchronousOpen() {
            return false;
        }
    }

    private static class ViewEnv
    implements CloneableEditorSupport.Env {
        private final FileObject file;
        private static final long serialVersionUID = -5788777967029507963L;

        public ViewEnv(FileObject file) {
            this.file = file;
        }

        public InputStream inputStream() throws IOException {
            return this.file.getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            throw new IOException();
        }

        public Date getTime() {
            return this.file.lastModified();
        }

        public String getMimeType() {
            return this.file.getMIMEType();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
        }

        public boolean isValid() {
            return this.file.isValid();
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return null;
        }
    }
}

