/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SystemActionBridge
extends AbstractAction {
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.SystemActionBridge");
    private Action action;
    private Action delegateAction;

    public static SystemActionBridge createAction(Action action, String name, Lookup context) {
        Action delegateAction = action;
        if (context != null && action instanceof ContextAwareAction) {
            action = ((ContextAwareAction)action).createContextAwareInstance(context);
        }
        return new SystemActionBridge(action, delegateAction, name);
    }

    private SystemActionBridge(Action action, Action delegateAction, String name) {
        super(name, null);
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.action = action;
        this.delegateAction = delegateAction;
    }

    public SystemActionBridge(Action action, String name) {
        this(action, action, name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log();
        this.action.actionPerformed(e);
    }

    @Override
    public boolean isEnabled() {
        return this.action.isEnabled();
    }

    private void log() throws MissingResourceException {
        LogRecord rec = new LogRecord(Level.FINER, "UI_ACTION_BUTTON_PRESS");
        rec.setParameters(new Object[]{"", "", this.delegateAction, this.delegateAction.getClass().getName(), this.action.getValue("Name")});
        rec.setResourceBundle(NbBundle.getBundle(Actions.class));
        rec.setResourceBundleName(Actions.class.getPackage().getName() + ".Bundle");
        rec.setLoggerName(UILOG.getName());
        UILOG.log(rec);
    }
}

