/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public class FolderNodeFactory
implements NodeFactory {
    private static final RequestProcessor RP = new RequestProcessor(FolderNodeFactory.class.getName(), 1);
    static boolean synchronous = false;

    public NodeList createNodes(Project p) {
        FreeformProject project = (FreeformProject)p.getLookup().lookup(FreeformProject.class);
        assert (project != null);
        return new RootChildren(project);
    }

    private static final class SubprojectNode
    extends AbstractNode {
        private final Project p;
        private final String label;
        private final ProjectInformation info;
        private static final Action OPEN = new OpenProjectAction();

        public SubprojectNode(Project p, String label) {
            super(Children.LEAF, Lookups.singleton((Object)p));
            this.p = p;
            this.label = label;
            this.info = ProjectUtils.getInformation((Project)p);
        }

        public String getName() {
            return this.info.getName();
        }

        public String getDisplayName() {
            return this.label != null ? this.label : this.info.getDisplayName();
        }

        public Image getIcon(int type) {
            return ImageUtilities.icon2Image((Icon)this.info.getIcon());
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{OPEN};
        }

        private static final class OpenProjectAction
        extends AbstractAction
        implements ContextAwareAction {
            private OpenProjectAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                assert (false);
            }

            public Action createContextAwareInstance(Lookup selection) {
                final Project[] projects = selection.lookupAll(Project.class).toArray(new Project[0]);
                return new AbstractAction(((OpenAction)SystemAction.get(OpenAction.class)).getName()){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        OpenProjects.getDefault().open(projects, false);
                    }

                    @Override
                    public boolean isEnabled() {
                        return !Arrays.asList(OpenProjects.getDefault().getOpenProjects()).containsAll(Arrays.asList(projects));
                    }
                };
            }
        }
    }

    private static final class ViewItemNode
    extends FilterNode {
        private final String name;
        private final String displayName;

        public ViewItemNode(Node orig, String name, String displayName) {
            super(orig);
            this.name = name;
            this.displayName = displayName;
        }

        public ViewItemNode(DataFolder folder, String includes, String excludes, String name, String displayName) {
            super(folder.getNodeDelegate(), folder.createNodeChildren((DataFilter)new GroupDataFilter(folder.getPrimaryFile(), includes, excludes)));
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (this.displayName != null) {
                return null;
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }

    private static final class GroupDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final FileObject root;
        private final PathMatcher matcher;

        public GroupDataFilter(FileObject root, String includes, String excludes) {
            this.root = root;
            this.matcher = new PathMatcher(includes, excludes, FileUtil.toFile((FileObject)root));
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptFileObject(FileObject fo) {
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
            if (path == null) {
                return false;
            }
            if (fo.isFolder()) {
                path = path + "/";
            }
            if (!this.matcher.matches(path, true)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        public boolean acceptDataObject(DataObject d) {
            return this.acceptFileObject(d.getPrimaryFile());
        }
    }

    private static final class RootChildren
    implements NodeList<Element>,
    AntProjectListener,
    PropertyChangeListener {
        private final FreeformProject p;
        private List<Element> keys = new ArrayList<Element>();
        private ChangeSupport cs = new ChangeSupport((Object)this);

        public RootChildren(FreeformProject p) {
            this.p = p;
        }

        public void addNotify() {
            this.updateKeys(false);
            this.p.helper().addAntProjectListener((AntProjectListener)this);
            this.p.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.keys = null;
            this.p.helper().removeAntProjectListener((AntProjectListener)this);
            this.p.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
        }

        private void updateKeys(boolean fromListener) {
            Element genldata = this.p.getPrimaryConfigurationData();
            Element viewEl = XMLUtil.findElement((Element)genldata, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (viewEl != null) {
                Element itemsEl = XMLUtil.findElement((Element)viewEl, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2");
                this.keys = XMLUtil.findSubElements((Element)itemsEl);
            } else {
                this.keys = Collections.emptyList();
            }
            if (fromListener && !synchronous) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        RootChildren.this.cs.fireChange();
                    }
                });
            } else {
                this.cs.fireChange();
            }
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.updateKeys(true);
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.updateKeys(true);
        }

        public List<Element> keys() {
            return this.keys;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public Node node(Element itemEl) {
            DataObject fileDO;
            Element locationEl = XMLUtil.findElement((Element)itemEl, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
            String location = XMLUtil.findText((org.w3c.dom.Node)locationEl);
            String locationEval = this.p.evaluator().evaluate(location);
            if (locationEval == null) {
                return null;
            }
            FileObject file = this.p.helper().resolveFileObject(locationEval);
            if (file == null) {
                return null;
            }
            Element labelEl = XMLUtil.findElement((Element)itemEl, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
            String label = labelEl != null ? XMLUtil.findText((org.w3c.dom.Node)labelEl) : null;
            if (itemEl.getLocalName().equals("source-folder")) {
                DataObject fileDO2;
                if (!file.isFolder()) {
                    return null;
                }
                String includes = null;
                Element includesEl = XMLUtil.findElement((Element)itemEl, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (includesEl != null && (includes = this.p.evaluator().evaluate(XMLUtil.findText((org.w3c.dom.Node)includesEl))).matches("\\$\\{[^}]+\\}")) {
                    includes = null;
                }
                String excludes = null;
                Element excludesEl = XMLUtil.findElement((Element)itemEl, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (excludesEl != null) {
                    excludes = this.p.evaluator().evaluate(XMLUtil.findText((org.w3c.dom.Node)excludesEl));
                }
                String style = itemEl.getAttribute("style");
                for (ProjectNature nature : Lookup.getDefault().lookupAll(ProjectNature.class)) {
                    if (!nature.getSourceFolderViewStyles().contains(style)) continue;
                    return nature.createSourceFolderView(this.p, file, includes, excludes, style, location, label);
                }
                if (style.equals("subproject")) {
                    try {
                        Project subproject = ProjectManager.getDefault().findProject(file);
                        if (subproject != null) {
                            return new SubprojectNode(subproject, label);
                        }
                    }
                    catch (IOException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                    return null;
                }
                if (!style.equals("tree")) {
                    Logger.getLogger(FolderNodeFactory.class.getName()).log(Level.WARNING, "Unrecognized <source-folder> style {0} on {1}", new Object[]{style, file});
                }
                try {
                    fileDO2 = DataObject.find((FileObject)file);
                }
                catch (DataObjectNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
                return new ViewItemNode((DataFolder)fileDO2, includes, excludes, location, label);
            }
            assert (itemEl.getLocalName().equals("source-file")) : itemEl;
            try {
                fileDO = DataObject.find((FileObject)file);
            }
            catch (DataObjectNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            return new ViewItemNode(fileDO.getNodeDelegate(), location, label);
        }
    }
}

