/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

public abstract class AbstractComponent<C extends Component<C>>
implements Component<C> {
    private C parent;
    private List<C> children = null;
    private AbstractModel model;

    public AbstractComponent(AbstractModel model) {
        this.model = model;
    }

    protected abstract void appendChildQuietly(C var1, List<C> var2);

    protected abstract void insertAtIndexQuietly(C var1, List<C> var2, int var3);

    protected abstract void removeChildQuietly(C var1, List<C> var2);

    protected abstract void populateChildren(List<C> var1);

    public final void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.model == null) {
            return;
        }
        this.model.removePropertyChangeListener(pcl);
    }

    public final void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.model == null) {
            return;
        }
        this.model.addPropertyChangeListener(new DelegateListener(pcl));
    }

    public void removeComponentListener(ComponentListener cl) {
        if (this.getModel() != null) {
            this.getModel().removeComponentListener(cl);
        }
    }

    @Override
    public synchronized C getParent() {
        return this.parent;
    }

    protected synchronized void setParent(C component) {
        this.parent = component;
    }

    protected synchronized void setModel(AbstractModel aModel) {
        this.model = aModel;
        if (this.isChildrenInitialized()) {
            for (Component component : this.getChildren()) {
                ((AbstractComponent)component).setModel(aModel);
            }
        }
    }

    private void _appendChildQuietly(C component, List<C> children) {
        if (component.getModel() == null) {
            throw new IllegalStateException("Cannot add a removed component, should use a fresh or a copy component.");
        }
        this.appendChildQuietly(component, children);
        ((AbstractComponent)component).setModel(this.getModel());
        ((AbstractComponent)component).setParent(this);
    }

    private void _insertAtIndexQuietly(C component, List<C> children, int index) {
        if (component.getModel() == null) {
            throw new IllegalStateException("Cannot add a removed component, should use a fresh or a copy component.");
        }
        this.insertAtIndexQuietly(component, children, index);
        ((AbstractComponent)component).setModel(this.getModel());
        ((AbstractComponent)component).setParent(this);
    }

    private void _removeChildQuietly(C component, List<C> children) {
        this.removeChildQuietly(component, children);
        ((AbstractComponent)component).setModel(null);
        ((AbstractComponent)component).setParent(null);
    }

    @Override
    public List<C> getChildren() {
        ArrayList<C> result = new ArrayList<C>(this._getChildren());
        return Collections.unmodifiableList(result);
    }

    public void checkChildrenPopulated() {
        this._getChildren();
    }

    public int getChildrenCount() {
        return this._getChildren().size();
    }

    protected final boolean isChildrenInitialized() {
        return this.children != null;
    }

    private synchronized List<C> _getChildren() {
        if (!this.isChildrenInitialized()) {
            this.children = new ArrayList<C>();
            this.populateChildren(this.children);
            for (Component child : this.children) {
                ((AbstractComponent)child).setParent(this);
            }
        }
        return this.children;
    }

    @Override
    public synchronized <T extends C> List<T> getChildren(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>(this._getChildren().size());
        for (Component child : this._getChildren()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            result.add(type.cast(child));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<C> getChildren(Collection<Class<? extends C>> typeList) {
        ArrayList<C> comps = new ArrayList<C>();
        for (Class<C> clazz : typeList) {
            comps.addAll(this.getChildren(clazz));
        }
        return Collections.unmodifiableList(comps);
    }

    @Override
    public synchronized AbstractModel getModel() {
        return this.model;
    }

    protected void verifyWrite() {
        this.getModel().validateWrite();
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
        this.getModel().firePropertyChangeEvent(event);
    }

    protected void fireValueChanged() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.VALUE_CHANGED));
    }

    protected void fireChildRemoved() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.CHILD_REMOVED));
    }

    protected void fireChildAdded() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.CHILD_ADDED));
    }

    protected <T extends C> T getChild(Class<T> type) {
        List<T> result = this.getChildren(type);
        Component value = null;
        if (!result.isEmpty()) {
            value = (Component)result.get(0);
        }
        return (T)value;
    }

    protected synchronized void addBefore(String propertyName, C component, Collection<Class<? extends C>> typeList) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(component);
        this.addChild(propertyName, component, typeList, true);
        this.firePropertyChange(propertyName, null, component);
        this.fireChildAdded();
    }

    protected synchronized void addAfter(String propertyName, C component, Collection<Class<? extends C>> typeList) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(component);
        this.addChild(propertyName, component, typeList, false);
        this.firePropertyChange(propertyName, null, component);
        this.fireChildAdded();
    }

    private void addChild(String propertyName, C component, Collection<Class<? extends C>> typeList, boolean before) {
        assert (component != null);
        if (typeList == null) {
            throw new IllegalArgumentException("typeList == null");
        }
        List<C> childnodes = this.getChildren();
        if (typeList.isEmpty() || childnodes.isEmpty()) {
            this._appendChildQuietly(component, this._getChildren());
        } else {
            int lastIndex = before ? childnodes.size() : -1;
            for (Class<C> type : typeList) {
                for (Component child : childnodes) {
                    if (!type.isAssignableFrom(child.getClass())) continue;
                    int i = childnodes.indexOf(child);
                    if (!before) {
                        if (i <= lastIndex) continue;
                        lastIndex = i;
                        continue;
                    }
                    if (i >= lastIndex) continue;
                    lastIndex = i;
                }
            }
            if (!before) {
                for (int i = ++lastIndex; i < childnodes.size() && ((Component)childnodes.get(i)).getClass().equals(component.getClass()); ++i) {
                    ++lastIndex;
                }
            }
            this._insertAtIndexQuietly(component, this._getChildren(), lastIndex);
        }
    }

    protected void checkNullOrDuplicateChild(C child) {
        if (child == null) {
            throw new IllegalArgumentException("child == null");
        }
        if (this._getChildren().contains(child)) {
            throw new IllegalArgumentException("child already in children list");
        }
    }

    protected synchronized void appendChild(String propertyName, C child) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(child);
        this._appendChildQuietly(child, this._getChildren());
        this.firePropertyChange(propertyName, null, child);
        this.fireChildAdded();
    }

    protected synchronized void insertAtIndex(String propertyName, C component, int index, Class<? extends C> type) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(component);
        if (type != null) {
            Component child;
            int trueIndex = 0;
            Iterator<C> i$ = this.getChildren().iterator();
            while (i$.hasNext() && !type.isAssignableFrom((child = (Component)i$.next()).getClass())) {
                ++trueIndex;
            }
            index += trueIndex;
        }
        this._insertAtIndexQuietly(component, this._getChildren(), index);
        this.firePropertyChange(propertyName, null, component);
        this.fireChildAdded();
    }

    public synchronized void insertAtIndex(String propertyName, C component, int index) {
        this.insertAtIndex(propertyName, component, index, null);
    }

    public synchronized void removeChild(String propertyName, C component) {
        this.verifyWrite();
        if (component == null) {
            throw new IllegalArgumentException("component == null");
        }
        if (!this._getChildren().contains(component)) {
            throw new IllegalArgumentException("component to be deleted is not a child");
        }
        this._removeChildQuietly(component, this._getChildren());
        this.firePropertyChange(propertyName, component, null);
        this.fireChildRemoved();
    }

    protected void setChild(Class<? extends C> classType, String propertyName, C newComponent, Collection<Class<? extends C>> typeList) {
        this.setChildAfter(classType, propertyName, newComponent, typeList);
    }

    protected void setChildAfter(Class<? extends C> classType, String propertyName, C newComponent, Collection<Class<? extends C>> typeList) {
        this.setChild(classType, propertyName, newComponent, typeList, false);
    }

    protected void setChildBefore(Class<? extends C> classType, String propertyName, C newComponent, Collection<Class<? extends C>> typeList) {
        this.setChild(classType, propertyName, newComponent, typeList, true);
    }

    protected synchronized void setChild(Class<? extends C> classType, String propertyName, C newComponent, Collection<Class<? extends C>> typeList, boolean before) {
        this.verifyWrite();
        List<C> childComponents = this.getChildren(classType);
        if (childComponents.contains(newComponent)) {
            return;
        }
        Component old = childComponents.isEmpty() ? null : (Component)childComponents.get(childComponents.size() - 1);
        for (Component child : childComponents) {
            this._removeChildQuietly(child, this._getChildren());
            this.fireChildRemoved();
        }
        if (newComponent != null) {
            this.addChild(propertyName, newComponent, typeList, before);
            this.fireChildAdded();
        }
        this.firePropertyChange(propertyName, old, newComponent);
    }

    @Override
    public boolean canPaste(Component child) {
        return true;
    }

    private class DelegateListener
    implements PropertyChangeListener {
        private final PropertyChangeListener delegate;

        public DelegateListener(PropertyChangeListener pcl) {
            this.delegate = pcl;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == AbstractComponent.this) {
                this.delegate.propertyChange(evt);
            }
        }

        public boolean equals(Object obj) {
            return this.delegate == obj;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

