/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;

public class AstNodeUtils {
    private static final String INDENT = "   ";

    public static String dumpTree(AstNode node) {
        StringBuffer buf = new StringBuffer();
        AstNodeUtils.dumpTree(node, buf);
        System.out.println(buf.toString());
        return buf.toString();
    }

    public static void dumpTree(AstNode node, StringBuffer buf) {
        AstNodeUtils.dump(node, "", buf);
    }

    private static void dump(AstNode node, String prefix, StringBuffer buf) {
        buf.append(prefix + node.toString());
        buf.append('\n');
        for (AstNode child : node.children()) {
            AstNodeUtils.dump(child, prefix + INDENT, buf);
        }
    }

    public static AstNode getRoot(AstNode node) {
        while (node.parent() != null) {
            node = node.parent();
        }
        return node;
    }

    public static List<AstNode> getAncestors(AstNode node, AstNode.NodeFilter filter) {
        ArrayList<AstNode> matching = new ArrayList<AstNode>();
        AstNode n = node;
        do {
            if (!filter.accepts(n)) continue;
            matching.add(n);
        } while ((n = n.parent()) != null);
        return matching;
    }

    public static List<AstNode> getChildrenRecursivelly(AstNode node, AstNode.NodeFilter filter, boolean recurseOnlyMatching) {
        ArrayList<AstNode> matching = new ArrayList<AstNode>();
        AstNodeUtils.getChildrenRecursivelly(matching, node, filter, recurseOnlyMatching);
        return matching;
    }

    private static void getChildrenRecursivelly(List<AstNode> found, AstNode node, AstNode.NodeFilter filter, boolean recurseOnlyMatching) {
        for (AstNode child : node.children()) {
            if (filter.accepts(child)) {
                found.add(child);
                AstNodeUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
                continue;
            }
            if (recurseOnlyMatching) continue;
            AstNodeUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
        }
    }

    public static AstNode findDescendant(AstNode node, int astOffset) {
        return AstNodeUtils.findDescendant(node, astOffset, false);
    }

    public static AstNode findDescendant(AstNode node, int astOffset, boolean exclusiveStartOffset) {
        int[] nodeRange = node.getLogicalRange();
        int so = nodeRange[0];
        int eo = nodeRange[1];
        if (astOffset < so || astOffset > eo) {
            return node;
        }
        if (exclusiveStartOffset) {
            ++so;
        }
        if (astOffset >= so && astOffset < eo && node.children().isEmpty()) {
            return node;
        }
        for (AstNode child : node.children()) {
            int[] childNodeRange = child.getLogicalRange();
            int ch_so = childNodeRange[0];
            if (exclusiveStartOffset) {
                ++ch_so;
            }
            int ch_eo = childNodeRange[1];
            if (astOffset < ch_so || astOffset >= ch_eo) continue;
            return AstNodeUtils.findDescendant(child, astOffset, exclusiveStartOffset);
        }
        return node;
    }

    public static AstNode findDescendantTag(AstNode node, int astOffset, boolean useLogicalRanges, boolean forward) {
        int eo;
        int so = useLogicalRanges ? node.logicalStartOffset() : node.startOffset();
        int n = eo = useLogicalRanges ? node.logicalEndOffset() : node.endOffset();
        if (forward ? astOffset >= so && astOffset < eo && node.children().isEmpty() : astOffset > so && astOffset <= eo && node.children().isEmpty()) {
            return node;
        }
        for (AstNode child : node.children()) {
            AstNode n2;
            int ch_so = child.logicalStartOffset();
            int ch_eo = child.logicalEndOffset();
            if (forward) {
                if (astOffset < ch_so || astOffset >= ch_eo) continue;
                if (astOffset < child.endOffset()) {
                    return child;
                }
                n2 = AstNodeUtils.findDescendantTag(child, astOffset, useLogicalRanges, forward);
                if (n2 == null) continue;
                return n2;
            }
            if (astOffset <= ch_so || astOffset > ch_eo) continue;
            if (astOffset <= child.endOffset()) {
                return child;
            }
            n2 = AstNodeUtils.findDescendantTag(child, astOffset, useLogicalRanges, forward);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    public static AstNode getTagNode(AstNode node, int astOffset) {
        if (node.type() == AstNode.NodeType.OPEN_TAG) {
            if (astOffset >= node.startOffset() && astOffset < node.endOffset()) {
                return node;
            }
            AstNode match = node.getMatchingTag();
            if (match != null && match.type() == AstNode.NodeType.ENDTAG && astOffset >= match.startOffset() && astOffset < match.endOffset()) {
                return match;
            }
            return null;
        }
        return node;
    }

    public static AstNode query(AstNode base, String path) {
        return AstNodeUtils.query(base, path, false);
    }

    public static AstNode query(AstNode base, String path, boolean caseInsensitive) {
        StringTokenizer st = new StringTokenizer(path, "/");
        AstNode found = base;
        while (st.hasMoreTokens()) {
            String nodeName;
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String string = nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            if (caseInsensitive) {
                nodeName = nodeName.toLowerCase(Locale.ENGLISH);
            }
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1, token.length()) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            AstNode foundLocal = null;
            for (AstNode child : found.children()) {
                String childName = child.name();
                if (child.type() != AstNode.NodeType.OPEN_TAG || !(caseInsensitive ? (childName = childName.toLowerCase(Locale.ENGLISH)) : childName).equals(nodeName) || count++ != index) continue;
                foundLocal = child;
                break;
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                assert (found.name().equals(nodeName));
                return found;
            }
            return null;
        }
        return null;
    }

    public static Collection<DTD.Element> getPossibleOpenTagElements(AstNode root, int astPosition) {
        HashSet<DTD.Element> elements = new HashSet<DTD.Element>();
        assert (root.type() == AstNode.NodeType.ROOT);
        AstNode leafNodeForPosition = AstNodeUtils.findDescendant(root, astPosition, true);
        while (leafNodeForPosition.getDTDElement() == null && leafNodeForPosition.type() != AstNode.NodeType.ROOT) {
            leafNodeForPosition = leafNodeForPosition.parent();
        }
        assert (leafNodeForPosition != null);
        if (leafNodeForPosition == root) {
            return root.getAllPossibleElements();
        }
        if (leafNodeForPosition.startOffset() <= astPosition && leafNodeForPosition.endOffset() > astPosition) {
            return Collections.EMPTY_LIST;
        }
        assert (leafNodeForPosition.type() == AstNode.NodeType.OPEN_TAG);
        DTD.ContentModel contentModel = leafNodeForPosition.getDTDElement().getContentModel();
        DTD.Content content = contentModel.getContent();
        ArrayList<DTD.Element> childrenBefore = new ArrayList<DTD.Element>();
        for (AstNode sibling : leafNodeForPosition.children()) {
            DTD.Content subcontent;
            if (sibling.startOffset() >= astPosition) break;
            if (sibling.type() != AstNode.NodeType.OPEN_TAG || (subcontent = content.reduce(sibling.getDTDElement().getName())) == null || content == subcontent) continue;
            content = subcontent;
            childrenBefore.add(sibling.getDTDElement());
        }
        if (!leafNodeForPosition.needsToHaveMatchingTag() && leafNodeForPosition.parent().type() != AstNode.NodeType.ROOT) {
            Collection<DTD.Element> elementsBeforeLeaf = AstNodeUtils.getPossibleOpenTagElements(root, leafNodeForPosition.startOffset());
            elementsBeforeLeaf.removeAll(childrenBefore);
            elements.addAll(elementsBeforeLeaf);
        }
        AstNodeUtils.addAllPossibleElements(elements, content.getPossibleElements());
        ArrayList<AstNode> path = new ArrayList<AstNode>();
        AstNode node = leafNodeForPosition;
        while (node.type() != AstNode.NodeType.ROOT) {
            path.add(0, node);
            node = node.parent();
        }
        for (AstNode node2 : path) {
            DTD.ContentModel cModel = node2.getDTDElement().getContentModel();
            elements.addAll(cModel.getIncludes());
            elements.removeAll(cModel.getExcludes());
        }
        return elements;
    }

    private static void addAllPossibleElements(Set<DTD.Element> result, Collection<DTD.Element> elements) {
        for (DTD.Element element : elements) {
            result.add(element);
            if (!element.hasOptionalStart()) continue;
            AstNodeUtils.addAllPossibleElements(result, element.getContentModel().getContent().getPossibleElements());
        }
    }

    public static boolean hasForbiddenEndTag(AstNode node) {
        return node.getDTDElement() != null ? node.getDTDElement().isEmpty() : false;
    }

    public static void visitChildren(AstNode node, AstNodeVisitor visitor, AstNode.NodeType nodeType) {
        for (AstNode n : node.children()) {
            if (nodeType == null || n.type() == nodeType) {
                visitor.visit(n);
            }
            AstNodeUtils.visitChildren(n, visitor, nodeType);
        }
    }

    public static void visitChildren(AstNode node, AstNodeVisitor visitor) {
        AstNodeUtils.visitChildren(node, visitor, null);
    }

    public static void visitAncestors(AstNode node, AstNodeVisitor visitor) {
        AstNode parent = node.parent();
        if (parent != null) {
            visitor.visit(parent);
            AstNodeUtils.visitAncestors(parent, visitor);
        }
    }
}

