/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.nodes.RubyServerNode;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

class Mongrel
implements RubyServer,
ServerInstanceImplementation {
    static final String GEM_NAME = "mongrel";
    private static final Pattern[] STARTUP_PATTERNS = new Pattern[]{Pattern.compile(".*Mongrel.+available at.+", 32), Pattern.compile(".*Ctrl-C to shutdown server.*", 32)};
    private final List<RailsApplication> applications = new ArrayList<RailsApplication>();
    private final RubyPlatform platform;
    private final String version;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Node node;

    Mongrel(RubyPlatform platform, String version) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        this.platform = platform;
        this.version = version;
    }

    private Node getNode() {
        if (this.node == null) {
            this.node = new RubyServerNode(this);
        }
        return this.node;
    }

    @Override
    public String getNodeName() {
        return NbBundle.getMessage(Mongrel.class, (String)"LBL_ServerNodeName", (Object)this.getDisplayName(), (Object)this.platform.getLabel());
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public List<String> getStartupParams(RailsProjectUtil.RailsVersion version) {
        if (version.isRails3OrHigher()) {
            return Arrays.asList("server", GEM_NAME);
        }
        return Collections.emptyList();
    }

    @Override
    public String getScriptPrefix() {
        return null;
    }

    @Override
    public String getServerPath(RailsProjectUtil.RailsVersion version) {
        if (version.isRails3OrHigher()) {
            return "script" + File.separator + "rails";
        }
        return "script" + File.separator + "server";
    }

    @Override
    public boolean isStartupMsg(String outputLine) {
        for (Pattern pattern : STARTUP_PATTERNS) {
            if (!pattern.matcher(outputLine).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RailsApplication> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public boolean addApplication(RailsApplication application) {
        boolean result = this.applications.add(application);
        this.changeSupport.fireChange();
        return result;
    }

    @Override
    public boolean removeApplication(int port) {
        boolean result = false;
        for (RailsApplication app : this.applications) {
            if (app.getPort() != port) continue;
            result = this.applications.remove(app);
            this.changeSupport.fireChange();
            break;
        }
        return result;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getServerDisplayName() {
        return this.getNodeName();
    }

    public Node getFullNode() {
        return this.getNode();
    }

    public Node getBasicNode() {
        return this.getNode();
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemovable() {
        return false;
    }

    @Override
    public String getServerUri() {
        return "MONGREL";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Mongrel.class, (String)"LBL_Mongrel", (Object)this.version);
    }

    @Override
    public RubyInstance.ServerState getServerState() {
        return null;
    }

    @Override
    public Future<RubyInstance.OperationState> startServer(RubyPlatform platform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stopServer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> deploy(String applicationName, File applicationDir) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stop(String applicationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> runApplication(RubyPlatform platform, String applicationName, File applicationDir) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPlatformSupported(RubyPlatform platform) {
        return this.platform.equals((Object)platform);
    }

    @Override
    public String getContextRoot(String applicationName) {
        return "";
    }

    @Override
    public int getRailsPort() {
        return 3000;
    }

    @Override
    public String getServerCommand(RubyPlatform platform, String classpath, File applicationDir, int httpPort, boolean debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mongrel other = (Mongrel)obj;
        if (!(this.platform == other.platform || this.platform != null && this.platform.equals((Object)other.platform))) {
            return false;
        }
        return this.version == other.version || this.version != null && this.version.equals(other.version);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.platform != null ? this.platform.hashCode() : 0);
        hash = 47 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }
}

