/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

final class RailsAdapters {
    static final String DEVELOPMENT_DB_SUFFIX = "_development";
    private static final String PRODUCTION_DB_SUFFIX = "_production";
    private static final String TEST_DB_SUFFIX = "_test";

    private RailsAdapters() {
    }

    static void commentOutSocket(FileObject dir, String host) {
        Parameters.notNull((CharSequence)"dir", (Object)dir);
        Parameters.notNull((CharSequence)"host", (Object)host);
        FileObject fo = dir.getFileObject("config/database.yml");
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    RailsAdapters.commentOutSocket(doc, host, 0);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static void commentOutSocket(Document doc, String host, int fromIndex) throws BadLocationException {
        int i;
        boolean addLocalHost;
        String text = doc.getText(0, doc.getLength());
        int offset = text.indexOf("socket:", fromIndex);
        if (offset == -1) {
            return;
        }
        int indent = 0;
        for (int i2 = offset - 1; i2 >= 0 && text.charAt(i2) != '\n'; --i2) {
            ++indent;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("# JRuby doesn't support socket:\n");
        boolean bl = addLocalHost = text.indexOf("host:", fromIndex) == -1;
        if (addLocalHost) {
            for (i = 0; i < indent; ++i) {
                sb.append(" ");
            }
            sb.append("host: " + host + "\n");
        }
        for (i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append("#");
        doc.insertString(offset, sb.toString(), null);
        RailsAdapters.commentOutSocket(doc, host, offset + sb.length() + "socket:".length());
    }

    static void addProperty(Document databaseYml, String propertyName, String propertyValue, String addAfter) throws BadLocationException {
        int indexForAdding;
        String text = databaseYml.getText(0, databaseYml.getLength());
        int offset = text.indexOf(addAfter);
        if (offset == -1) {
            return;
        }
        int indent = RailsAdapters.determineIndent(text, offset);
        for (indexForAdding = offset + addAfter.length(); text.charAt(indexForAdding) != '\n' && indexForAdding <= text.length(); ++indexForAdding) {
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append(propertyName + " " + propertyValue + '\n');
        databaseYml.insertString(indexForAdding + 1, sb.toString(), null);
    }

    static void removeProperty(Document databaseYml, String propertyName) throws BadLocationException {
        String text = databaseYml.getText(0, databaseYml.getLength());
        int offset = text.indexOf(propertyName);
        if (offset == -1) {
            return;
        }
        int indent = RailsAdapters.determineIndent(text, offset);
        int valueLength = propertyName.length();
        for (int i = offset + propertyName.length(); i <= text.length(); ++i) {
            ++valueLength;
            if (text.charAt(i) == '\n') break;
        }
        databaseYml.remove(offset - indent, valueLength + indent);
    }

    static String getPropertyValue(Document databaseYml, String propertyName) throws BadLocationException {
        String text = databaseYml.getText(0, databaseYml.getLength());
        int propertyNameIndex = text.indexOf(propertyName);
        if (propertyNameIndex == -1) {
            return null;
        }
        int propertyNameEndIndex = propertyNameIndex + propertyName.length();
        int propertyValueLength = 0;
        for (int i = propertyNameEndIndex; i < text.length() && text.charAt(i) != '\n'; ++i) {
            ++propertyValueLength;
        }
        return databaseYml.getText(propertyNameEndIndex, propertyValueLength).trim();
    }

    static void changeAttribute(Document doc, String attributeName, String attributeValue, String addAfter) throws BadLocationException {
        Parameters.notWhitespace((CharSequence)"attributeName", (CharSequence)attributeName);
        if (attributeValue == null || "".equals(attributeValue.trim())) {
            return;
        }
        String text = doc.getText(0, doc.getLength());
        int attributeNameIndex = text.indexOf(attributeName);
        if (attributeNameIndex == -1) {
            if (addAfter != null) {
                RailsAdapters.addProperty(doc, attributeName, attributeValue, addAfter);
            } else {
                return;
            }
        }
        int attributeNameEndIndex = attributeNameIndex + attributeName.length();
        int attributeValuelength = 0;
        for (int i = attributeNameEndIndex; i < text.length() && text.charAt(i) != '\n'; ++i) {
            ++attributeValuelength;
        }
        doc.remove(attributeNameEndIndex, attributeValuelength);
        doc.insertString(attributeNameEndIndex, attributeValue != null ? " " + attributeValue : "", null);
    }

    static Document getDatabaseYml(FileObject projectDir) {
        FileObject fo = projectDir.getFileObject("config/database.yml");
        if (fo == null) {
            return null;
        }
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec != null) {
                try {
                    return ec.openDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        return null;
    }

    private static int determineIndent(String text, int offset) {
        int indent = 0;
        for (int i = offset - 1; i >= 0 && text.charAt(i) != '\n'; --i) {
            ++indent;
        }
        return indent;
    }

    static String getTestDatabaseName(String develDb) {
        return RailsAdapters.buildDatabaseName(develDb, TEST_DB_SUFFIX);
    }

    static String getProductionDatabaseName(String develDb) {
        return RailsAdapters.buildDatabaseName(develDb, PRODUCTION_DB_SUFFIX);
    }

    private static String buildDatabaseName(String develDb, String suffix) {
        if (develDb == null) {
            return "";
        }
        int i = develDb.indexOf(DEVELOPMENT_DB_SUFFIX);
        if (i == -1) {
            return develDb + suffix;
        }
        if (i == 0) {
            return suffix;
        }
        return develDb.substring(0, i) + suffix;
    }
}

