/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.database.ConfigurableRailsAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JavaDBAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JdbcMySQlAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JdbcPostgreSQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.MySQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.PostgreSQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.SQLiteAdapter;
import org.netbeans.modules.ruby.railsprojects.database.StandardRailsAdapter;

public class RailsAdapterFactory {
    public static List<RailsDatabaseConfiguration> getAdapters(RubyPlatform plaform) {
        ArrayList<RailsDatabaseConfiguration> result = new ArrayList<RailsDatabaseConfiguration>();
        result.addAll(RailsAdapterFactory.getMySQLAdapters(plaform));
        result.addAll(RailsAdapterFactory.getPostgreSQLAdapters(plaform));
        result.add(new StandardRailsAdapter("oracle"));
        result.add(new SQLiteAdapter("sqlite2"));
        result.add(new SQLiteAdapter("sqlite3"));
        result.add(new JavaDBAdapter());
        return result;
    }

    private static List<RailsDatabaseConfiguration> getMySQLAdapters(RubyPlatform platform) {
        if (!platform.isJRuby()) {
            return Collections.singletonList(new MySQLAdapter());
        }
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null || !gemManager.isGemInstalled("activerecord-jdbcmysql-adapter")) {
            return Collections.singletonList(new MySQLAdapter());
        }
        return Collections.singletonList(new JdbcMySQlAdapter());
    }

    private static List<RailsDatabaseConfiguration> getPostgreSQLAdapters(RubyPlatform platform) {
        if (!platform.isJRuby()) {
            return Collections.singletonList(new PostgreSQLAdapter());
        }
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null || !gemManager.isGemInstalled("activerecord-jdbcpostgresql-adapter")) {
            return Collections.singletonList(new PostgreSQLAdapter());
        }
        return Collections.singletonList(new JdbcPostgreSQLAdapter());
    }

    public static RailsDatabaseConfiguration getDefaultAdapter(RubyPlatform platform) {
        RailsDatabaseConfiguration defaultAdapter = RailsAdapterFactory.getAdapters(platform).get(0);
        return defaultAdapter.requiresJdbc() ? new ConfigurableRailsAdapter(defaultAdapter, null, null, null, true) : defaultAdapter;
    }

    public static RailsDatabaseConfiguration getDefaultAdapter() {
        return new MySQLAdapter();
    }
}

