/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.GemRequirement;
import org.netbeans.modules.ruby.rubyproject.RequiredGems;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class RailsGemsHelper
implements RakeTaskCustomizer {
    private GemsLineConvertor convertor;
    private static final String REINDEX_GEMS_TOKEN = "--- reindex gems ---";
    private static final String RESET_GEMS_TOKEN = "--- reset gems ---";

    public void customize(Project project, RakeTask task, RubyExecutionDescriptor taskDescriptor, boolean debug) {
        if (!"gems".equals(task.getTask())) {
            return;
        }
        RequiredGems requiredGems = null;
        for (RequiredGems each : project.getLookup().lookupAll(RequiredGems.class)) {
            if (each.isForTests()) continue;
            requiredGems = each;
            break;
        }
        this.convertor = new GemsLineConvertor(requiredGems, (RubyBaseProject)project);
        taskDescriptor.addOutConvertor((LineConvertor)this.convertor);
        taskDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new RakeGemsInputProcessorFactory(this.convertor.getGems(), requiredGems));
    }

    static final class GemsLineConvertor
    implements LineConvertor {
        private final List<GemRequirement> gems = new ArrayList<GemRequirement>();
        private final RequiredGems requiredGems;
        private final RubyBaseProject project;

        public GemsLineConvertor(RequiredGems requiredGems, RubyBaseProject project) {
            this.requiredGems = requiredGems;
            this.project = project;
        }

        List<GemRequirement> getGems() {
            return this.gems;
        }

        public List<ConvertedLine> convert(String line) {
            GemRequirement rg = GemRequirement.parse((String)line);
            if (rg != null) {
                this.gems.add(rg);
            }
            if (line.contains(RailsGemsHelper.REINDEX_GEMS_TOKEN)) {
                return Collections.singletonList(ConvertedLine.forText((String)NbBundle.getMessage(GemsLineConvertor.class, (String)"ReindexGems"), (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        GemsLineConvertor.this.requiredGems.setRequiredGems(GemsLineConvertor.this.gems);
                        GemsLineConvertor.this.save();
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            if (line.contains(RailsGemsHelper.RESET_GEMS_TOKEN)) {
                return Collections.singletonList(ConvertedLine.forText((String)NbBundle.getMessage(GemsLineConvertor.class, (String)"ResetGems"), (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        GemsLineConvertor.this.requiredGems.setRequiredGems((String)null);
                        GemsLineConvertor.this.save();
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            return Collections.singletonList(ConvertedLine.forText((String)line, null));
        }

        private void save() {
            RailsProjectProperties properties = new RailsProjectProperties(this.project, this.project.getUpdateHelper(), this.project.evaluator(), this.project.getReferenceHelper(), this.project.getGenFilesHelper());
            properties.setGemRequirements(this.requiredGems.getGemRequirements());
            properties.save();
        }
    }

    private static final class RakeGemsInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final List<GemRequirement> gems;
        private final RequiredGems requiredGems;

        public RakeGemsInputProcessorFactory(List<GemRequirement> gems, RequiredGems requiredGems) {
            this.gems = gems;
            this.requiredGems = requiredGems;
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return new RakeGemsInputProcessor(defaultProcessor);
        }

        private final class RakeGemsInputProcessor
        implements InputProcessor {
            private final InputProcessor delegate;

            public RakeGemsInputProcessor(InputProcessor delegate) {
                this.delegate = delegate;
            }

            public void processInput(char[] chars) throws IOException {
                this.delegate.processInput(chars);
            }

            public void reset() throws IOException {
                this.delegate.reset();
            }

            public void close() throws IOException {
                this.finish();
                this.delegate.close();
            }

            private void finish() throws IOException {
                if (!RakeGemsInputProcessorFactory.this.gems.isEmpty()) {
                    this.delegate.processInput("\n".toCharArray());
                    List old = RakeGemsInputProcessorFactory.this.requiredGems.getGemRequirements();
                    boolean addOr = false;
                    if (old == null || !new HashSet(old).equals(new HashSet(RakeGemsInputProcessorFactory.this.gems))) {
                        this.delegate.processInput("--- reindex gems ---\n".toCharArray());
                        addOr = true;
                    }
                    if (old != null) {
                        if (addOr) {
                            this.delegate.processInput((NbBundle.getMessage(GemsLineConvertor.class, (String)"Or") + "\n").toCharArray());
                        } else {
                            this.delegate.processInput((NbBundle.getMessage(GemsLineConvertor.class, (String)"GemsIndexed") + "\n").toCharArray());
                        }
                        this.delegate.processInput("--- reset gems ---\n".toCharArray());
                    }
                }
            }
        }
    }
}

