/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rhtml.spi.DtdResolver;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class RailsDtdResolver
implements DtdResolver {
    private static final String DEFAULT_FALLBACK_DTD = "-//W3C//DTD XHTML 1.0 Strict//EN";
    private static final String RHTML_DTD_PROPERTY = "rhtml.doctype";

    public String getIdentifier(Document doc) {
        FileObject fo = RailsDtdResolver.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return null;
        }
        RubyBaseProject project = (RubyBaseProject)owner.getLookup().lookup(RubyBaseProject.class);
        if (project == null) {
            return null;
        }
        String result = project.evaluator().getProperty(RHTML_DTD_PROPERTY);
        return result != null ? result : DEFAULT_FALLBACK_DTD;
    }

    private static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }
}

