/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import javax.swing.JPanel;

public class PlaceholderPanel
extends JPanel {
    private static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    private static final Dimension MAX_DIMENSION = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    public PlaceholderPanel() {
        this(true);
    }

    public PlaceholderPanel(boolean isDoubleBuffered) {
        super(null, isDoubleBuffered);
    }

    public void setComponent(Component comp) {
        if (this.isEmpty()) {
            this.add(comp);
        } else {
            this.removeAll();
            this.add(comp);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr != null) {
            throw new UnsupportedOperationException("PlaceholderPanel's layout manager cannot be changed.");
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isEmpty()) {
            return new Dimension(ZERO_DIMENSION);
        }
        return this.getOccupant().getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isEmpty()) {
            return new Dimension(ZERO_DIMENSION);
        }
        return this.getOccupant().getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isEmpty()) {
            return new Dimension(MAX_DIMENSION);
        }
        return this.getOccupant().getMaximumSize();
    }

    @Override
    public void doLayout() {
        Component comp = this.getOccupant();
        if (comp != null) {
            comp.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("This placeholder is already occupied.");
        }
        super.addImpl(comp, constraints, index);
        this.updateOpacity();
        this.invalidate();
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.updateOpacity();
        this.invalidate();
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        this.updateOpacity();
        this.invalidate();
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        super.remove(popup);
        this.updateOpacity();
        this.invalidate();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateOpacity();
        this.invalidate();
    }

    private void updateOpacity() {
        this.setOpaque(this.isEmpty());
    }

    private Component getOccupant() {
        return this.isEmpty() ? null : this.getComponent(0);
    }

    public boolean isEmpty() {
        return this.getComponentCount() == 0;
    }
}

