/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.openide.util.NbBundle;

public class IssueCacheUtils {
    public static boolean wasSeen(Issue issue) {
        return IssueCacheUtils.getCache(issue).wasSeen(issue.getID());
    }

    public static void switchSeen(Issue issue) {
        try {
            IssueCache cache = IssueCacheUtils.getCache(issue);
            String id = issue.getID();
            cache.setSeen(id, !cache.wasSeen(id));
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static void setSeen(Issue issue, boolean seen) {
        try {
            IssueCacheUtils.getCache(issue).setSeen(issue.getID(), seen);
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static String getRecentChanges(Issue issue) {
        String changes = IssueCacheUtils.getCache(issue).getIssueAccessor().getRecentChanges(issue);
        changes = changes == null ? "" : changes.trim();
        if (changes.equals("") && IssueCacheUtils.getCache(issue).getStatus(issue.getID()) == 8) {
            changes = NbBundle.getMessage(IssueCacheUtils.class, (String)"LBL_IssueModified");
        }
        return changes;
    }

    public static void addCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.getCache(issue).addPropertyChangeListener(issue, l);
    }

    public static void removeCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.getCache(issue).removePropertyChangeListener(issue, l);
    }

    private static IssueCache getCache(Issue issue) {
        Repository repo = issue.getRepository();
        IssueCache cache = (IssueCache)repo.getLookup().lookup(IssueCache.class);
        assert (cache != null);
        return cache;
    }
}

