/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai.spi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

abstract class KenaiRepositories {
    private static KenaiRepositories instance;
    private final Map<String, Object> kenaiLocks = new HashMap<String, Object>(1);
    private Map<String, Repository> repositoriesMap = Collections.synchronizedMap(new HashMap());

    protected KenaiRepositories() {
    }

    public static synchronized KenaiRepositories getInstance() {
        if (instance == null && (instance = (KenaiRepositories)Lookup.getDefault().lookup(KenaiRepositories.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public Repository getRepository(KenaiProject kp) {
        return this.getRepository(kp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(KenaiProject kp, boolean forceCreate) {
        Object lock;
        String repositoryKey = kp.getWebLocation().toString();
        BugtrackingManager.LOG.log(Level.FINER, "requesting repository for {0}", repositoryKey);
        KenaiSupport support = this.getSupport(kp);
        if (support == null) {
            BugtrackingManager.LOG.log(Level.FINER, "no repository available for {0}", repositoryKey);
            return null;
        }
        Object object = lock = this.getKenaiLock(kp, support);
        synchronized (object) {
            Repository repository = this.repositoriesMap.get(repositoryKey);
            if (repository == null && forceCreate && (repository = support.createRepository(kp)) != null) {
                this.repositoriesMap.put(repositoryKey, repository);
            }
            BugtrackingManager.LOG.log(Level.FINER, "returning repository {0}:{1} for {2}", new Object[]{repository != null ? repository.getDisplayName() : "null", repository != null ? repository.getUrl() : "", repositoryKey});
            return repository;
        }
    }

    private KenaiSupport getSupport(KenaiProject kp) {
        BugtrackingConnector[] connectors;
        KenaiSupport support = null;
        for (BugtrackingConnector c : connectors = BugtrackingUtil.getBugtrackingConnectors()) {
            support = (KenaiSupport)c.getLookup().lookup(KenaiSupport.class);
            if (support != null && support.getType() == kp.getType()) {
                BugtrackingManager.LOG.log(Level.FINER, "found suport for {0}", kp.getWebLocation().toString());
                break;
            }
            support = null;
        }
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKenaiLock(KenaiProject kp, KenaiSupport support) {
        Map<String, Object> map = this.kenaiLocks;
        synchronized (map) {
            KenaiSupport.BugtrackingType type = support.getType();
            String key = kp.getWebLocation().getHost() + ":" + (Object)((Object)type);
            BugtrackingManager.LOG.log(Level.FINER, "requesting lock for {0}", key);
            Object lock = this.kenaiLocks.get(key);
            if (lock == null) {
                lock = new Object();
                this.kenaiLocks.put(key, lock);
            }
            BugtrackingManager.LOG.log(Level.FINER, "returning lock {0} for {1}", new Object[]{lock, key});
            return lock;
        }
    }

    public abstract Repository[] getRepositories(boolean var1);

    private static class DefaultImpl
    extends KenaiRepositories {
        private DefaultImpl() {
        }

        @Override
        public Repository[] getRepositories(boolean allOpenProjects) {
            if ("true".equals(System.getProperty("netbeans.bugtracking.noOpenProjects", "false"))) {
                allOpenProjects = false;
            }
            KenaiProject[] kenaiProjects = allOpenProjects ? DefaultImpl.union(this.getDashboardProjects(), this.getProjectsViewProjects()) : this.getDashboardProjects();
            Repository[] result = new Repository[kenaiProjects.length];
            EnumSet<KenaiSupport.BugtrackingType> reluctantSupports = EnumSet.noneOf(KenaiSupport.BugtrackingType.class);
            int count = 0;
            for (KenaiProject p : kenaiProjects) {
                if (!reluctantSupports.contains((Object)p.getType())) {
                    Repository repo = this.getRepository(p);
                    if (repo != null) {
                        result[count++] = repo;
                        continue;
                    }
                    KenaiSupport support = ((KenaiRepositories)this).getSupport(p);
                    if (support == null) continue;
                    BugtrackingManager.LOG.log(Level.WARNING, "could not get repository for project {0} with {1} bugtracking type ", new Object[]{p.getWebLocation(), p.getType()});
                    reluctantSupports.add(support.getType());
                    continue;
                }
                BugtrackingManager.LOG.log(Level.WARNING, "skipping getRepository for project {0} with {1} bugtracking type ", new Object[]{p.getWebLocation(), p.getType()});
            }
            return DefaultImpl.stripTrailingNulls(result);
        }

        private KenaiProject[] getDashboardProjects() {
            return KenaiUtil.getDashboardProjects();
        }

        private KenaiProject[] getProjectsViewProjects() {
            Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
            if (openProjects.length == 0) {
                return new KenaiProject[0];
            }
            int count = 0;
            KenaiProject[] kenaiProjects = new KenaiProject[openProjects.length];
            for (Project p : openProjects) {
                KenaiProject kenaiProject = DefaultImpl.getKenaiProject(p);
                if (kenaiProject == null) continue;
                kenaiProjects[count++] = kenaiProject;
            }
            return DefaultImpl.stripTrailingNulls(kenaiProjects);
        }

        private static KenaiProject getKenaiProject(Project p) {
            FileObject rootDir = p.getProjectDirectory();
            Object attValue = rootDir.getAttribute("ProvidedExtensions.RemoteLocation");
            if (!(attValue instanceof String)) {
                return null;
            }
            String url = (String)attValue;
            KenaiProject kenaiProject = null;
            try {
                if (BugtrackingUtil.isNbRepository(url)) {
                    OwnerInfo owner = KenaiUtil.getKenaiAccessor().getOwnerInfo(FileUtil.toFile((FileObject)p.getProjectDirectory()));
                    if (owner != null) {
                        kenaiProject = KenaiUtil.getKenaiProject(url, owner.getOwner());
                    }
                } else {
                    kenaiProject = KenaiUtil.getKenaiProjectForRepository(url);
                }
            }
            catch (IOException ex) {
                kenaiProject = null;
                BugtrackingManager.LOG.log(Level.WARNING, "No Kenai project is available for bugtracking repository  [" + url + "]");
                BugtrackingManager.LOG.log(Level.FINE, null, ex);
            }
            return kenaiProject;
        }

        private static KenaiProject[] union(KenaiProject[] ... projectArrays) {
            HashMap<String, KenaiProject> union = new HashMap<String, KenaiProject>();
            KenaiProject[][] arr$ = projectArrays;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                KenaiProject[] projectArray;
                for (KenaiProject p : projectArray = arr$[i$]) {
                    String name = p.getName();
                    if (union.keySet().contains(name)) continue;
                    union.put(name, p);
                }
            }
            return union.values().toArray(new KenaiProject[union.values().size()]);
        }

        private static <T> T[] stripTrailingNulls(T[] array) {
            int resultSize;
            for (resultSize = array.length; resultSize > 0 && array[resultSize - 1] == null; --resultSize) {
            }
            if (resultSize == array.length) {
                return array;
            }
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), resultSize);
            if (resultSize != 0) {
                System.arraycopy(array, 0, result, 0, resultSize);
            }
            return result;
        }
    }
}

