/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.jira.DownloadPanel;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class DownloadPlugin
implements ActionListener {
    private DownloadPanel panel = new DownloadPanel();
    private JButton install = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Install"));
    private JButton cancel = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));
    private UpdateElement jiraElement;
    private UpdateElement jiraLibraryElement;
    private boolean jiraElementInstalled = false;
    private boolean jiraLibraryElementInstalled = false;

    public DownloadPlugin() {
        this.install.setEnabled(false);
        this.panel.licensePanel.setVisible(false);
        this.panel.acceptCheckBox.addActionListener(this);
    }

    void startDownload() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_LookingForJira"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean ret;
                ph.start();
                try {
                    List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    for (UpdateUnit u : units) {
                        List elements;
                        if (u.getCodeName().equals("org.netbeans.modules.jira")) {
                            elements = u.getAvailableUpdates();
                            if (elements.size() == 0) {
                                DownloadPlugin.this.jiraElementInstalled = true;
                            } else {
                                DownloadPlugin.this.jiraElement = (UpdateElement)u.getAvailableUpdates().get(0);
                            }
                        } else if (u.getCodeName().equals("org.netbeans.libs.jira")) {
                            elements = u.getAvailableUpdates();
                            if (elements.size() == 0) {
                                DownloadPlugin.this.jiraLibraryElementInstalled = true;
                            } else {
                                DownloadPlugin.this.jiraLibraryElement = (UpdateElement)u.getAvailableUpdates().get(0);
                            }
                        }
                        if (DownloadPlugin.this.jiraElement == null || DownloadPlugin.this.jiraLibraryElement == null) continue;
                    }
                    if (DownloadPlugin.this.jiraLibraryElementInstalled && DownloadPlugin.this.jiraElementInstalled) {
                        DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_AlreadyInstalled"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        return;
                    }
                }
                finally {
                    ph.finish();
                }
                if (DownloadPlugin.this.jiraElement == null || DownloadPlugin.this.jiraLibraryElement == null) {
                    DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_JiraNotFound"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                    return;
                }
                ((DownloadPlugin)DownloadPlugin.this).panel.licensePanel.setVisible(true);
                ((DownloadPlugin)DownloadPlugin.this).panel.licenseTextPane.setText(DownloadPlugin.this.jiraElement.getLicence());
                ((DownloadPlugin)DownloadPlugin.this).panel.progressPanel.setVisible(false);
                DownloadPlugin.this.panel.repaint();
                NotifyDescriptor descriptor = new NotifyDescriptor((Object)DownloadPlugin.this.panel, NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_DownloadJira"), 2, -1, new Object[]{DownloadPlugin.this.install, DownloadPlugin.this.cancel}, (Object)DownloadPlugin.this.install);
                boolean bl = ret = DialogDisplayer.getDefault().notify(descriptor) == DownloadPlugin.this.install;
                if (!ret) {
                    DownloadPlugin.this.jiraElement = null;
                    DownloadPlugin.this.jiraLibraryElement = null;
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        if (DownloadPlugin.this.jiraLibraryElement != null) {
                            DownloadPlugin.this.install(DownloadPlugin.this.jiraLibraryElement, DownloadPlugin.this.jiraElement == null);
                        }
                        if (DownloadPlugin.this.jiraElement != null) {
                            DownloadPlugin.this.install(DownloadPlugin.this.jiraElement, true);
                        }
                    }
                });
            }
        });
    }

    private void install(UpdateElement updateElement, boolean done) {
        try {
            InstallCancellable ic = new InstallCancellable();
            OperationContainer oc = OperationContainer.createForInstall();
            if (oc.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                oc.add(updateElement);
            } else {
                if (updateElement.getUpdateUnit().isPending()) {
                    DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_RestartNeeded"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_RestartNeeded"), 1, false);
                    return;
                }
                oc = OperationContainer.createForUpdate();
                if (oc.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                    oc.add(updateElement);
                } else {
                    BugtrackingManager.LOG.warning("MissingClient: cannot install " + updateElement.toString());
                    if (updateElement.getUpdateUnit().getInstalled() != null) {
                        BugtrackingManager.LOG.warning("MissingClient: already installed " + updateElement.getUpdateUnit().getInstalled().toString());
                    }
                    DownloadPlugin.notifyInDialog(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_InvalidOperation"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_InvalidOperation"), 0, false);
                    return;
                }
            }
            InstallSupport.Validator v = ((InstallSupport)oc.getSupport()).doDownload(ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Downloading", (Object)updateElement.getDisplayName()), (Cancellable)ic), false);
            if (ic.cancelled) {
                return;
            }
            InstallSupport.Installer i = ((InstallSupport)oc.getSupport()).doValidate(v, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Validating", (Object)updateElement.getDisplayName()), (Cancellable)ic));
            if (ic.cancelled) {
                return;
            }
            OperationSupport.Restarter rest = ((InstallSupport)oc.getSupport()).doInstall(i, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Installing", (Object)updateElement.getDisplayName()), (Cancellable)ic));
            if (done && rest != null) {
                JButton restart = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Restart"));
                JButton cancel = new JButton(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"CTL_Action_Cancel"));
                NotifyDescriptor descriptor = new NotifyDescriptor((Object)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_NeedsRestart"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_DownloadJira"), 2, 3, new Object[]{restart, cancel}, (Object)restart);
                if (DialogDisplayer.getDefault().notify(descriptor) == restart) {
                    ((InstallSupport)oc.getSupport()).doRestart(rest, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_Restarting")));
                }
            }
        }
        catch (OperationException e) {
            BugtrackingManager.LOG.log(Level.INFO, null, e);
            DownloadPlugin.notifyError(NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MSG_MissingClient_UC_Unavailable"), NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"LBL_MissingClient_UC_Unavailable"));
        }
    }

    private static void notifyError(String message, String title) {
        DownloadPlugin.notifyInDialog(message, title, 0, true);
    }

    private static void notifyInDialog(String message, String title, int messageType, boolean cancelVisible) {
        Object[] objectArray;
        if (cancelVisible) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, messageType, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.acceptCheckBox) {
            this.install.setEnabled(this.panel.acceptCheckBox.isSelected());
        }
    }

    public UpdateElement getJiraElement() {
        return this.jiraElement;
    }

    public UpdateElement getJiraLibraryElement() {
        return this.jiraLibraryElement;
    }

    private class InstallCancellable
    implements Cancellable {
        private boolean cancelled;

        private InstallCancellable() {
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

