/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedField;
import org.netbeans.modules.groovy.editor.api.elements.IndexedMethod;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;

public final class GroovyElementHandler {
    private static final Logger LOGGER = Logger.getLogger(GroovyElementHandler.class.getName());
    private final ParserResult info;

    private GroovyElementHandler(ParserResult parserResult) {
        this.info = parserResult;
    }

    public static GroovyElementHandler forCompilationInfo(ParserResult parserResult) {
        return new GroovyElementHandler(parserResult);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(GroovyIndex groovyIndex, String string, String string2, int n, boolean bl, Set<AccessLevel> set, boolean bl2) {
        Set<IndexedMethod> set2;
        if (groovyIndex == null) {
            return Collections.emptyMap();
        }
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        if ((set2 = string3.equals("") ? groovyIndex.getMethods(".*", string, QuerySupport.Kind.REGEXP) : groovyIndex.getMethods(string3, string, QuerySupport.Kind.PREFIX)).size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyMap();
        }
        LOGGER.log(Level.FINEST, "Found this number of methods : {0} ", set2.size());
        HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
        for (IndexedMethod indexedMethod : set2) {
            LOGGER.log(Level.FINEST, "method from index : {0} ", indexedMethod.getName());
            if (!this.accept(set, indexedMethod)) continue;
            List<String> list = indexedMethod.getParameters();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string4 : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NbUtilities.stripPackage(string4));
            }
            hashMap.put(this.getSignature(indexedMethod), CompletionItem.forJavaMethod(string, indexedMethod.getName(), stringBuffer.toString(), indexedMethod.getReturnType(), Utilities.gsfModifiersToModel(indexedMethod.getModifiers(), Modifier.PUBLIC), n, bl, bl2));
        }
        return hashMap;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(GroovyIndex groovyIndex, String string, String string2, int n, boolean bl) {
        Set<IndexedField> set;
        if (groovyIndex == null) {
            return Collections.emptyMap();
        }
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        if ((set = string3.equals("") ? groovyIndex.getFields(".*", string, QuerySupport.Kind.REGEXP) : groovyIndex.getFields(string3, string, QuerySupport.Kind.PREFIX)).size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyMap();
        }
        LOGGER.log(Level.FINEST, "Found this number of fields : {0} ", set.size());
        HashMap<FieldSignature, CompletionItem.JavaFieldItem> hashMap = new HashMap<FieldSignature, CompletionItem.JavaFieldItem>();
        for (IndexedField indexedField : set) {
            LOGGER.log(Level.FINEST, "field from index : {0} ", indexedField.getName());
            hashMap.put(this.getSignature(indexedField), new CompletionItem.JavaFieldItem(string, indexedField.getName(), null, Utilities.gsfModifiersToModel(indexedField.getModifiers(), Modifier.PRIVATE), n, bl));
        }
        return hashMap;
    }

    private MethodSignature getSignature(IndexedMethod indexedMethod) {
        String[] stringArray = indexedMethod.getParameters().toArray(new String[indexedMethod.getParameters().size()]);
        return new MethodSignature(indexedMethod.getName(), stringArray);
    }

    private FieldSignature getSignature(IndexedField indexedField) {
        return new FieldSignature(indexedField.getName());
    }

    private boolean accept(Set<AccessLevel> set, IndexedElement indexedElement) {
        for (AccessLevel accessLevel : set) {
            if (!accessLevel.accept(indexedElement.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

