/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl.wsdl2java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.wsdl.Binding;
import org.netbeans.modules.e2e.api.wsdl.BindingInput;
import org.netbeans.modules.e2e.api.wsdl.BindingOperation;
import org.netbeans.modules.e2e.api.wsdl.BindingOutput;
import org.netbeans.modules.e2e.api.wsdl.Definition;
import org.netbeans.modules.e2e.api.wsdl.Input;
import org.netbeans.modules.e2e.api.wsdl.Message;
import org.netbeans.modules.e2e.api.wsdl.Operation;
import org.netbeans.modules.e2e.api.wsdl.Output;
import org.netbeans.modules.e2e.api.wsdl.Part;
import org.netbeans.modules.e2e.api.wsdl.Port;
import org.netbeans.modules.e2e.api.wsdl.PortType;
import org.netbeans.modules.e2e.api.wsdl.Service;
import org.netbeans.modules.e2e.api.wsdl.extensions.ExtensibilityElement;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPAddress;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBinding;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBody;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPOperation;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaConstants;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPConstants;
import org.openide.util.NbBundle;

class WSDLValidator {
    private Definition definition;
    private List<WSDL2Java.ValidationResult> result;
    private Service service;
    private boolean flagNoSoapBinding;

    public WSDLValidator(List<WSDL2Java.ValidationResult> result, Definition definition) {
        this.definition = definition;
        this.result = new ArrayList<WSDL2Java.ValidationResult>();
        this.result.addAll(result);
    }

    public List<WSDL2Java.ValidationResult> validate() {
        this.checkDefinition(this.definition);
        this.printMessages();
        return this.result;
    }

    private void checkDefinition(Definition definition) {
        for (Service service : definition.getServices().values()) {
            this.checkService(service);
        }
    }

    private void checkService(Service service) {
        this.service = service;
        for (Port port : service.getPorts()) {
            this.checkPort(port);
        }
    }

    private void checkPort(Port port) {
        for (ExtensibilityElement portEE : port.getExtensibilityElements()) {
            if (!SOAPConstants.ADDRESS.equals(portEE.getElementType())) continue;
            SOAPAddress soapAddress = (SOAPAddress)portEE;
            Binding binding = port.getBinding();
            this.checkBinding(binding);
        }
    }

    private void checkBinding(Binding binding) {
        for (ExtensibilityElement bindingEE : binding.getExtensibilityElements()) {
            PortType.PortTypeReference reference;
            if (!SOAPConstants.BINDING.equals(bindingEE.getElementType())) continue;
            SOAPBinding soapBinding = (SOAPBinding)bindingEE;
            for (BindingOperation bindingOperation : binding.getBindingOperations()) {
                this.checkBindingOperation(bindingOperation);
            }
            PortType portType = binding.getPortType();
            if (portType instanceof PortType.PortTypeReference && !(reference = (PortType.PortTypeReference)portType).isValid()) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0016", binding.getName(), reference.getQName().toString());
            }
            for (Operation operation : portType.getOperations()) {
                this.checkOperation(operation);
            }
        }
    }

    private void checkBindingOperation(BindingOperation bindingOperation) {
        BindingInput bindingInput;
        SOAPOperation soapOperation = null;
        for (ExtensibilityElement bindingOperationEE : bindingOperation.getExtensibilityElements()) {
            if (!SOAPConstants.OPERATION.equals(bindingOperationEE.getElementType())) continue;
            if (soapOperation == null) {
                soapOperation = (SOAPOperation)bindingOperationEE;
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0011", bindingOperation.getName());
        }
        if (soapOperation != null && !"document".equals(soapOperation.getStyle())) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0001", bindingOperation.getName());
        }
        if ((bindingInput = bindingOperation.getBindingInput()) != null) {
            for (ExtensibilityElement bindingInputEE : bindingInput.getExtensibilityElements()) {
                SOAPBody soapBody;
                if (!SOAPConstants.BODY.equals(bindingInputEE.getElementType()) || "literal".equals((soapBody = (SOAPBody)bindingInputEE).getUse())) continue;
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0002", bindingOperation.getName(), "input");
            }
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0012", bindingOperation.getName());
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput != null) {
            for (ExtensibilityElement bindingOutputEE : bindingOutput.getExtensibilityElements()) {
                SOAPBody soapBody;
                if (!SOAPConstants.BODY.equals(bindingOutputEE.getElementType()) || "literal".equals((soapBody = (SOAPBody)bindingOutputEE).getUse())) continue;
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0002", bindingOperation.getName(), "output");
            }
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0013", bindingOperation.getName());
        }
    }

    private void checkOperation(Operation operation) {
        Message.MessageReference reference;
        Message.MessageReference reference2;
        Output output = operation.getOutput();
        if (output == null) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0007", operation.getName());
            return;
        }
        Message message = output.getMessage();
        boolean isValid = true;
        if (message instanceof Message.MessageReference && !(isValid = (reference2 = (Message.MessageReference)message).isValid())) {
            QName name = reference2.getQName();
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0017", operation.getName(), name.toString());
        }
        if (isValid) {
            if (message.getParts().size() == 0) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0014", message.getName());
            } else if (message.getParts().size() > 1) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0006", operation.getName());
            }
        }
        for (Part part : message.getParts()) {
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            if (elementName != null && typeName != null) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0023", message.getName(), operation.getName(), part.getName());
                continue;
            }
            Element element = null;
            Object type = null;
            if (elementName != null) {
                element = this.definition.getSchemaHolder().getSchemaElement(elementName);
                if (element == null) {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0019", message.getName(), operation.getName(), part.getName(), elementName.toString());
                    continue;
                }
                this.checkType(element, null, new HashSet<Element>());
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0008", message.getName(), operation.getName(), part.getName());
        }
        Input input = operation.getInput();
        if (input == null) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0009", operation.getName());
            return;
        }
        isValid = true;
        message = input.getMessage();
        if (message instanceof Message.MessageReference && !(isValid = (reference = (Message.MessageReference)message).isValid())) {
            QName name = reference.getQName();
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0018", operation.getName(), name.toString());
        }
        if (isValid) {
            if (message.getParts().size() == 0) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0014", message.getName());
            } else if (message.getParts().size() > 1) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0006", operation.getName());
            }
        }
        for (Part part : message.getParts()) {
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            if (elementName != null && typeName != null) {
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0024", message.getName(), operation.getName(), part.getName());
                continue;
            }
            Element element = null;
            Object type = null;
            if (elementName != null) {
                element = this.definition.getSchemaHolder().getSchemaElement(elementName);
                if (element == null) {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0022", message.getName(), operation.getName(), part.getName(), elementName.toString());
                    continue;
                }
                this.checkType(element, null, new HashSet<Element>());
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0008", message.getName(), operation.getName(), part.getName());
        }
    }

    private void checkType(Element element, Type type, Set<Element> usedComplexTypes) {
        if (type == null) {
            type = element.getType();
        }
        if (3 == type.getFlavor()) {
            QName typeName = type.getName();
            if (!(SchemaConstants.TYPE_INT.equals(typeName) || SchemaConstants.TYPE_BOOLEAN.equals(typeName) || SchemaConstants.TYPE_BYTE.equals(typeName) || SchemaConstants.TYPE_DOUBLE.equals(typeName) || SchemaConstants.TYPE_FLOAT.equals(typeName) || SchemaConstants.TYPE_LONG.equals(typeName) || SchemaConstants.TYPE_SHORT.equals(typeName) || SchemaConstants.TYPE_BASE64_BINARY.equals(typeName) || SchemaConstants.TYPE_HEX_BINARY.equals(typeName) || SchemaConstants.TYPE_STRING.equals(typeName))) {
                if (SchemaConstants.TYPE_QNAME.equals(typeName)) {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.WARNING, "0015");
                } else {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0003", typeName.toString());
                }
            }
        } else if (1 == type.getFlavor()) {
            if (element != null) {
                usedComplexTypes.add(element);
            }
            if (type.getSubconstructs().size() == 0) {
                return;
            }
            for (SchemaConstruct sc : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc.getConstructType())) {
                    Element sce = (Element)sc;
                    if (!usedComplexTypes.contains(sce)) {
                        this.checkType(sce, null, usedComplexTypes);
                        continue;
                    }
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0010");
                    continue;
                }
                if (element != null) {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0005", element.getName().toString());
                    continue;
                }
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0025", type.getName().toString());
            }
        } else if (element != null) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0004", element.getName().toString());
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0026", type.getName().toString());
        }
    }

    private void printMessages() {
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String messageKey) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)messageKey)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String messageKey, String param1) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)messageKey, (Object)param1)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String messageKey, String param1, String param2) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)messageKey, (Object)param1, (Object)param2)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String messageKey, String ... params) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)messageKey, (Object[])params)));
    }
}

