/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.subversion.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class SvnPropertiesAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 24060;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction");
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Properties";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        String ctxDisplayName = this.getContextDisplayName(nodes);
        File[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            return;
        }
        SvnPropertiesAction.openProperties(roots, ctxDisplayName);
    }

    public static void openProperties(File[] roots, String ctxDisplayName) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        PropertiesPanel panel = new PropertiesPanel();
        PropertiesTable propTable = new PropertiesTable(panel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        panel.setPropertiesTable(propTable);
        JComponent component = propTable.getComponent();
        panel.propsPanel.setLayout(new BorderLayout());
        panel.propsPanel.add((Component)component, "Center");
        SvnProperties svnProperties = new SvnProperties(panel, propTable, roots);
        JButton btnClose = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)btnClose, (String)SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        btnClose.getAccessibleContext().setAccessibleDescription(SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        btnClose.getAccessibleContext().setAccessibleName(SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesDialog_Title", (Object)ctxDisplayName));
        dd.setModal(true);
        dd.setOptions(new Object[]{btnClose});
        dd.setHelpCtx(new HelpCtx(SvnPropertiesAction.class));
        panel.putClientProperty("contentTitle", ctxDisplayName);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction"));
        dialog.pack();
        dialog.setVisible(true);
    }

    private static String getString(String msgKey) {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)msgKey);
    }
}

