/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.SwitchTo;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchToAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Switch";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes) && nodes.length == 1;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl rootUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        File[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            rootUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryRoot = new RepositoryFile(rootUrl, rootUrl, SVNRevision.HEAD);
        boolean hasChanges = Subversion.getInstance().getStatusCache().containsFiles(ctx, 22996, true);
        RequestProcessor rp = this.createRequestProcessor(nodes);
        SwitchTo switchTo = new SwitchTo(repositoryRoot, interestingFile, hasChanges);
        this.performSwitch(switchTo, rp, nodes, roots);
    }

    private void performSwitch(final SwitchTo switchTo, final RequestProcessor rp, final Node[] nodes, final File[] roots) {
        if (!switchTo.showDialog()) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (!SwitchToAction.this.validateInput(roots[0], switchTo.getRepositoryFile())) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwitchToAction.this.performSwitch(switchTo, rp, nodes, roots);
                        }
                    });
                } else {
                    ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(SwitchToAction.this, nodes){

                        @Override
                        public void perform() {
                            for (File root : roots) {
                                RepositoryFile toRepositoryFile = switchTo.getRepositoryFile();
                                if (root.isFile() && roots.length > 1) {
                                    toRepositoryFile = toRepositoryFile.replaceLastSegment(root.getName(), 0);
                                }
                                SwitchToAction.performSwitch(toRepositoryFile, root, this);
                            }
                        }
                    };
                    support.start(rp);
                }
            }
        });
    }

    private boolean validateInput(File root, RepositoryFile toRepositoryFile) {
        boolean ret = false;
        try {
            SvnClient client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
            ISVNInfo info = client.getInfo(toRepositoryFile.getFileUrl());
            if (info.getNodeKind() == SVNNodeKind.DIR && root.isFile()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFileToFolderError"));
                ret = false;
            } else if (info.getNodeKind() == SVNNodeKind.FILE && root.isDirectory()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFolderToFileError"));
                ret = false;
            } else {
                ret = true;
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return ret;
        }
        return ret;
    }

    static void performSwitch(RepositoryFile toRepositoryFile, File root, SvnProgressSupport support) {
        File[][] split = Utils.splitFlatOthers((File[])new File[]{root});
        boolean recursive = split[0].length <= 0;
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            client.switchToUrl(root, toRepositoryFile.getFileUrl(), toRepositoryFile.getRevision(), recursive);
            List<File> switchedFiles = SvnUtils.listRecursively(root);
            File[] fileArray = switchedFiles.toArray(new File[switchedFiles.size()]);
            Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(fileArray);
            Subversion.getInstance().refreshAnnotations(fileArray);
            Subversion.getInstance().versionedFilesChanged();
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

