/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.CommandReport;
import org.netbeans.modules.subversion.client.MissingClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.config.CertificateFile;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientExceptionHandler {
    private final ISVNClientAdapter adapter;
    private final SvnClient client;
    private final SvnClientDescriptor desc;
    private final int handledExceptions;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CHARSET_NAME = "ASCII7";
    private final boolean commandLine;
    private CertificateFailure[] failures = new CertificateFailure[]{new CertificateFailure(1, "certificate is not yet valid", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotYetValid")), new CertificateFailure(2, "certificate has expired", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureHasExpired")), new CertificateFailure(4, "certificate issued for a different hostname", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureWrongHostname")), new CertificateFailure(8, "issuer is not trusted", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotTrusted"))};
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_AUTHENTICATION = 4;
    public static final int EX_NO_CERTIFICATE = 8;
    public static final int EX_WRONG_URL = 16;
    public static final int EX_NO_HOST_CONNECTION = 32;
    public static final int EX_UNVERSIONED_RESOURCE = 64;
    public static final int EX_WRONG_URL_IN_REVISION = 128;
    public static final int EX_URL_NON_EXISTENT = 256;
    public static final int EX_HTTP_405 = 512;
    public static final int EX_IS_ALREADY_WC = 1024;
    public static final int EX_CLOSED_CONNECTION = 2048;
    public static final int EX_COMMIT_FAILED = 4096;
    public static final int EX_FILE_ALREADY_EXISTS = 8192;
    public static final int EX_IS_OUT_OF_DATE = 16384;
    public static final int EX_NO_SVN_CLIENT = 32768;
    public static final int EX_HTTP_FORBIDDEN = 65536;
    public static final int EX_SSL_NEGOTIATION_FAILED = 131072;
    public static final int EX_HANDLED_EXCEPTIONS = 131116;
    public static final int EX_DEFAULT_HANDLED_EXCEPTIONS = 131116;
    private final SVNClientException exception;
    private final int exceptionMask;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser");

    public SvnClientExceptionHandler(SVNClientException exception, ISVNClientAdapter adapter, SvnClient client, SvnClientDescriptor desc, int handledExceptions, boolean commandLine) {
        this.exception = exception;
        this.adapter = adapter;
        this.client = client;
        this.desc = desc;
        this.handledExceptions = handledExceptions;
        this.exceptionMask = SvnClientExceptionHandler.getMask(exception.getMessage());
        this.commandLine = commandLine;
    }

    public boolean handleException() throws Exception {
        if (this.exceptionMask != 0) {
            if ((this.handledExceptions & this.exceptionMask & 0x20) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 8) == this.exceptionMask) {
                return this.handleNoCertificateError();
            }
            if ((this.handledExceptions & this.exceptionMask & 4) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 0x20000) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
        }
        throw this.getException();
    }

    public boolean handleKenaiAuthorisation(SvnKenaiAccessor support, String url) {
        PasswordAuthentication pa = support.getPasswordAuthentication(url, true);
        if (pa == null) {
            return false;
        }
        String user = pa.getUserName();
        char[] password = pa.getPassword();
        this.adapter.setUsername(user != null ? user : "");
        if (this.commandLine) {
            this.adapter.setPassword(password != null ? new String(password) : "");
        }
        return true;
    }

    private boolean handleRepositoryConnectError() {
        boolean ret;
        SVNUrl url = this.getRemoteHostUrl();
        SvnKenaiAccessor support = SvnKenaiAccessor.getInstance();
        if (support.isKenai(url.toString())) {
            return support.showLogin() && this.handleKenaiAuthorisation(support, url.toString());
        }
        Repository repository = new Repository(64, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_ConnectionParameters"));
        repository.selectUrl(url, true);
        JButton retryButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Retry"));
        String title = (this.exceptionMask & 0x20) == this.exceptionMask ? NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_CouldNotConnect") : NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_AuthFailed");
        Object option = repository.show(title, new HelpCtx(this.getClass()), new Object[]{retryButton, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel")}, retryButton);
        boolean bl = ret = option == retryButton;
        if (ret) {
            RepositoryConnection rc = repository.getSelectedRC();
            String username = rc.getUsername();
            char[] password = rc.getPassword();
            this.adapter.setUsername(username);
            if (this.commandLine && password != null) {
                this.adapter.setPassword(new String(password));
            }
            SvnModuleConfig.getDefault().insertRecentUrl(rc);
        }
        return ret;
    }

    private boolean handleNoCertificateError() throws Exception {
        SSLSocket socket;
        SVNUrl url = this.getSVNUrl();
        String realmString = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        String hostString = SvnUtils.ripUserFromHost(url.getHost());
        File certFile = CertificateFile.getSystemCertFile(realmString);
        File nbCertFile = CertificateFile.getNBCertFile(realmString);
        if (!nbCertFile.exists() && certFile.exists()) {
            FileUtils.copyFile((File)certFile, (File)CertificateFile.getNBCertFile(realmString));
            return true;
        }
        try {
            socket = this.getSSLSocket(hostString, url.getPort(), null);
        }
        catch (Exception e) {
            Subversion.LOG.log(Level.SEVERE, null, e);
            return false;
        }
        if (socket == null) {
            return false;
        }
        X509Certificate cert = null;
        Certificate[] serverCerts = null;
        try {
            serverCerts = socket.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        for (int i = 0; i < serverCerts.length; ++i) {
            if (!(serverCerts[i] instanceof X509Certificate)) continue;
            cert = (X509Certificate)serverCerts[i];
            try {
                cert.checkValidity();
                break;
            }
            catch (CertificateExpiredException ex) {
                continue;
            }
            catch (CertificateNotYetValidException ex) {
                // empty catch block
            }
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(this.getCertMessage(cert, hostString));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.subversion.serverCertificateVerification"));
        JButton permanentlyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton temporarilyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton rejectButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{permanentlyButton, temporarilyButton, rejectButton});
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() != permanentlyButton && dialogDescriptor.getValue() != temporarilyButton) {
            return false;
        }
        CertificateFile cf = null;
        try {
            boolean temporarily = dialogDescriptor.getValue() == temporarilyButton;
            cf = new CertificateFile(cert, "https://" + hostString + ":" + url.getPort(), this.getFailuresMask(), temporarily);
            cf.store();
        }
        catch (CertificateEncodingException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private SVNUrl getSVNUrl() {
        String realmString = this.getRealmFromException();
        SVNUrl url = null;
        if (realmString != null) {
            try {
                url = new SVNUrl(realmString);
            }
            catch (MalformedURLException e) {
                Subversion.LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
        if (url == null) {
            url = this.client.getSvnUrl();
        }
        return url;
    }

    private String getRealmFromException() {
        String[] errorMessages;
        String exceptionMessage = this.exception.getMessage().toLowerCase();
        for (String errorMessage : errorMessages = new String[]{"host not found (", "could not connect to server (", "could not resolve hostname (", "issuer is not trusted (", "authorization failed ("}) {
            int idxR;
            int idxL = exceptionMessage.indexOf(errorMessage);
            if (idxL < 0 || (idxR = exceptionMessage.indexOf(")", idxL + errorMessage.length())) < 0) continue;
            return exceptionMessage.substring(idxL + errorMessage.length(), idxR);
        }
        return null;
    }

    private SSLSocket getSSLSocket(String host, int port, String[] protocols) throws Exception {
        TrustManager[] trust = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        ProxySettings proxySettings = new ProxySettings();
        String proxyHost = proxySettings.getHttpsHost();
        int proxyPort = proxySettings.getHttpsPort();
        if (proxyHost.equals("")) {
            proxyHost = proxySettings.getHttpHost();
            proxyPort = proxySettings.getHttpPort();
        }
        Socket proxySocket = new Socket(Proxy.NO_PROXY);
        if (proxySettings.isDirect()) {
            proxySocket.connect(new InetSocketAddress(host, port));
        } else {
            boolean directWorks = false;
            try {
                proxySocket.connect(new InetSocketAddress(host, port));
                directWorks = true;
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.FINE, null, e);
            }
            if (!directWorks) {
                proxySocket = new Socket(Proxy.NO_PROXY);
                proxySocket.connect(new InetSocketAddress(proxyHost, proxyPort));
                this.connectProxy(proxySocket, host, port, proxyHost, proxyPort, proxySettings.getUsername(), proxySettings.getPassword());
            }
        }
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(this.getKeyManagers(), trust, null);
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(proxySocket, host, port, true);
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
        try {
            socket.startHandshake();
        }
        catch (SSLException ex) {
            if (protocols == null && this.isBadRecordMac(ex.getMessage())) {
                return this.getSSLSocket(host, port, new String[]{"SSLv3", "SSLv2Hello"});
            }
            throw ex;
        }
        return socket;
    }

    private KeyManager[] getKeyManagers() {
        try {
            SVNUrl url = this.getRemoteHostUrl();
            RepositoryConnection rc = SvnModuleConfig.getDefault().getRepositoryConnection(url.toString());
            if (rc == null) {
                return null;
            }
            String certFile = rc.getCertFile();
            if (certFile == null || certFile.trim().equals("")) {
                return null;
            }
            char[] certPasswordChars = rc.getCertPassword();
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(new FileInputStream(certFile), certPasswordChars);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, certPasswordChars);
            return kmf.getKeyManagers();
        }
        catch (Exception ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private SVNUrl getRemoteHostUrl() {
        SVNUrl url;
        SVNUrl sVNUrl = url = this.desc != null ? this.desc.getSvnUrl() : null;
        if (url == null) {
            url = this.getSVNUrl();
        }
        return url;
    }

    private void connectProxy(Socket proxy, String host, int port, String proxyHost, int proxyPort, String userName, String password) throws IOException {
        byte[] connectBytes;
        StringBuilder sb = new StringBuilder("CONNECT ").append(host).append(":").append(port).append(" HTTP/1.0\r\n").append("Connection: Keep-Alive\r\n");
        if (userName != null && password != null && userName.length() > 0) {
            Subversion.LOG.info("connectProxy: adding proxy authorization field");
            sb.append("Proxy-Authorization: Basic ").append(Base64Encoder.encode((byte[])(userName + ":" + password).getBytes())).append("\r\n");
        }
        String connectString = sb.append("\r\n").toString();
        try {
            connectBytes = connectString.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException ignored) {
            connectBytes = connectString.getBytes();
        }
        OutputStream out = proxy.getOutputStream();
        out.write(connectBytes);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = proxy.getInputStream();
        while (newlinesSeen < 2) {
            byte b = (byte)in.read();
            if (b < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (b == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (b == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = b;
        }
        String ret = "";
        try {
            ret = new String(reply, 0, replyLen, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException ignored) {
            ret = new String(reply, 0, replyLen);
        }
        if (!this.isOKresponse(ret.toLowerCase())) {
            throw new IOException("Unable to connect through proxy " + proxyHost + ":" + proxyPort + ".  Proxy returns \"" + ret + "\"");
        }
    }

    private boolean isOKresponse(String ret) {
        return ret.startsWith("http/1.1 200") || ret.startsWith("http/1.0 200");
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private String getCertMessage(X509Certificate cert, String host) {
        CertificateFailure[] certFailures = this.getCertFailures();
        Object[] param = new Object[]{host, cert.getSubjectDN().getName(), cert.getNotBefore(), cert.getNotAfter(), cert.getIssuerDN().getName(), this.getFingerprint(cert, "SHA1"), this.getFingerprint(cert, "MD5")};
        String message = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_BadCertificate", (Object[])param);
        for (int i = 0; i < certFailures.length; ++i) {
            message = certFailures[i].message + message;
        }
        return message;
    }

    private CertificateFailure[] getCertFailures() {
        ArrayList<CertificateFailure> ret = new ArrayList<CertificateFailure>();
        String exceptionMessage = this.getException().getMessage();
        for (int i = 0; i < this.failures.length; ++i) {
            if (exceptionMessage.indexOf(this.failures[i].error) <= -1) continue;
            ret.add(this.failures[i]);
        }
        return ret.toArray(new CertificateFailure[ret.size()]);
    }

    private int getFailuresMask() {
        CertificateFailure[] certFailures = this.getCertFailures();
        if (certFailures.length == 0) {
            return 15;
        }
        int mask = 0;
        for (int i = 0; i < certFailures.length; ++i) {
            mask |= certFailures[i].mask;
        }
        return mask;
    }

    private String getFingerprint(X509Certificate cert, String alg) {
        try {
            byte[] encoded = cert.getEncoded();
            return Utils.getHash((String)alg, (byte[])encoded);
        }
        catch (CertificateEncodingException ex) {
            Subversion.LOG.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Subversion.LOG.log(Level.INFO, ex.getMessage(), ex);
        }
        return "";
    }

    private SVNClientException getException() {
        return this.exception;
    }

    private static int getMask(String msg) {
        if (msg == null || msg.trim().equals("")) {
            return 0;
        }
        if (SvnClientExceptionHandler.isAuthentication(msg = msg.toLowerCase())) {
            return 4;
        }
        if (SvnClientExceptionHandler.isCancelledAction(msg)) {
            return 2;
        }
        if (SvnClientExceptionHandler.isNoCertificate(msg)) {
            return 8;
        }
        if (SvnClientExceptionHandler.isWrongUrl(msg)) {
            return 16;
        }
        if (SvnClientExceptionHandler.isNoHostConnection(msg)) {
            return 32;
        }
        if (SvnClientExceptionHandler.isUnversionedResource(msg)) {
            return 64;
        }
        if (SvnClientExceptionHandler.isWrongURLInRevision(msg)) {
            return 128;
        }
        if (SvnClientExceptionHandler.isHTTP405(msg)) {
            return 512;
        }
        if (SvnClientExceptionHandler.isAlreadyAWorkingCopy(msg)) {
            return 1024;
        }
        if (SvnClientExceptionHandler.isClosedConnection(msg)) {
            return 2048;
        }
        if (SvnClientExceptionHandler.isCommitFailed(msg)) {
            return 4096;
        }
        if (SvnClientExceptionHandler.isNoCliSvnClient(msg)) {
            return 32768;
        }
        if (SvnClientExceptionHandler.isHTTP403(msg)) {
            return 65536;
        }
        if (SvnClientExceptionHandler.isSSLNegotiation(msg)) {
            return 131072;
        }
        return 0;
    }

    public static boolean isCancelledAction(String msg) {
        return msg.equals(ACTION_CANCELED_BY_USER);
    }

    static boolean isOperationCancelled(String message) {
        return (message = message.toLowerCase()).indexOf("operation canceled") > -1;
    }

    public static boolean isAuthentication(String msg) {
        return (msg = msg.toLowerCase()).indexOf("authentication error from server: username not found") > -1 || msg.indexOf("authorization failed") > -1 || msg.indexOf("authentication failed") > -1 || msg.indexOf("authentication error from server: password incorrect") > -1 || msg.indexOf("can't get password") > -1 || msg.indexOf("can't get username or password") > -1;
    }

    public static boolean isNoCertificate(String msg) {
        return (msg = msg.toLowerCase()).indexOf("server certificate verification failed") > -1;
    }

    public static boolean isWrongUrl(String msg) {
        return (msg = msg.toLowerCase()).indexOf("(not a valid url)") > -1 || msg.indexOf("bad url passed to ra layer") > -1;
    }

    private static boolean isNoHostConnection(String msg) {
        return (msg = msg.toLowerCase()).indexOf("host not found") > -1 || msg.indexOf("could not connect to server") > -1 || msg.indexOf("could not resolve hostname") > -1;
    }

    public static boolean isUnversionedResource(String msg) {
        return (msg = msg.toLowerCase()).indexOf("(not a versioned resource)") > -1 || msg.indexOf("is not a working copy") > -1;
    }

    public static boolean isTooOldClientForWC(String msg) {
        return (msg = msg.toLowerCase()).indexOf("this client is too old") > -1;
    }

    public static boolean isWrongURLInRevision(String msg) {
        if ((msg = msg.toLowerCase()).indexOf("no such revision") > -1) {
            return true;
        }
        int idx = msg.indexOf("unable to find repository location for");
        if (idx > -1 && msg.indexOf("in revision", idx + 23) > -1) {
            return true;
        }
        idx = msg.indexOf("url");
        return idx > -1 && msg.indexOf("non-existent in that revision", idx + 3) > -1;
    }

    private static boolean isHTTP405(String msg) {
        return msg.indexOf("405") > -1;
    }

    public static boolean isHTTP403(String msg) {
        return msg.indexOf("403") > -1;
    }

    public static boolean isSSLNegotiation(String msg) {
        return (msg = msg.toLowerCase()).indexOf("ssl negotiation failed: ssl error: sslv3 alert handshake failure") > -1;
    }

    public static boolean isReportOf200(String msg) {
        int idx = (msg = msg.toLowerCase()).indexOf("svn: report of");
        if (idx < 0) {
            return false;
        }
        return msg.indexOf("200", idx + 13) > -1;
    }

    public static boolean isSecureConnTruncated(String msg) {
        return (msg = msg.toLowerCase()).indexOf("could not read chunk size: secure connection truncated") > -1;
    }

    public static boolean isFileNotFoundInRevision(String msg) {
        return (msg = msg.toLowerCase()).indexOf("file not found: revision") > -1 || msg.indexOf("unable to find repository location for") > -1 && msg.indexOf("in revision") > -1;
    }

    public static boolean isPathNotFound(String msg) {
        return (msg = msg.toLowerCase()).indexOf("path not found") > -1;
    }

    private static boolean isAlreadyAWorkingCopy(String msg) {
        return (msg = msg.toLowerCase()).indexOf("is already a working copy for a different url") > -1;
    }

    private static boolean isClosedConnection(String msg) {
        return (msg = msg.toLowerCase()).indexOf("could not read status line: an existing connection was forcibly closed by the remote host.") > -1;
    }

    private static boolean isCommitFailed(String msg) {
        return (msg = msg.toLowerCase()).indexOf("commit failed (details follow)") > -1;
    }

    public static boolean isFileAlreadyExists(String msg) {
        return (msg = msg.toLowerCase()).indexOf("file already exists") > -1 || msg.indexOf("mkcol") > -1 && SvnClientExceptionHandler.isHTTP405(msg);
    }

    private static boolean isOutOfDate(String msg) {
        return (msg = msg.toLowerCase()).indexOf("out of date") > -1 || msg.indexOf("out-of-date") > -1;
    }

    public static boolean isNoCliSvnClient(String msg) {
        return (msg = msg.toLowerCase()).indexOf("command line client adapter is not available") > -1 || msg.indexOf(CommandlineClient.ERR_CLI_NOT_AVALABLE) > -1;
    }

    public static boolean isUnsupportedJavaHl(String msg) {
        return (msg = msg.toLowerCase()).indexOf(CommandlineClient.ERR_JAVAHL_NOT_SUPPORTED) > -1;
    }

    public static boolean isMissingOrLocked(String msg) {
        int idx = (msg = msg.toLowerCase()).indexOf("svn: working copy");
        if (idx > -1) {
            return msg.indexOf("is missing or not locked", idx + 17) > -1;
        }
        idx = msg.indexOf("svn: directory");
        if (idx > -1) {
            return msg.indexOf("is missing", idx + 13) > -1;
        }
        return false;
    }

    public static boolean isTargetDirectory(String msg) {
        return (msg = msg.toLowerCase()).indexOf("refers to a directory") > -1;
    }

    public static boolean isWrongUUID(String msg) {
        return (msg = msg.toLowerCase()).contains("has uuid") && msg.contains("but the wc has");
    }

    public static boolean isNotUnderVersionControl(String message) {
        message = message.toLowerCase();
        return message.contains("is not under version control");
    }

    public static void notifyException(Exception ex, boolean annotate, boolean isUI) {
        if (SvnClientExceptionHandler.isNoCliSvnClient(ex.getMessage())) {
            if (isUI) {
                SvnClientExceptionHandler.notifyNoClient();
            }
            return;
        }
        if (SvnClientExceptionHandler.isCancelledAction(ex.getMessage())) {
            SvnClientExceptionHandler.cancelledAction();
            return;
        }
        Subversion.LOG.log(Level.INFO, ex.getMessage(), ex);
        if (annotate) {
            String msg = SvnClientExceptionHandler.getCustomizedMessage(ex);
            if (msg == null) {
                msg = ex instanceof SVNClientException ? SvnClientExceptionHandler.parseExceptionMessage((SVNClientException)((Object)ex)) : ex.getMessage();
            }
            SvnClientExceptionHandler.annotate(msg);
        }
    }

    public static boolean handleLogException(SVNUrl url, SVNRevision revision, SVNClientException e) {
        String protocol = url.getProtocol();
        if (protocol.startsWith("https") && SvnClientExceptionHandler.isSecureConnTruncated(e.getMessage()) || protocol.startsWith("http") && SvnClientExceptionHandler.isReportOf200(e.getMessage()) || (protocol.startsWith("file") || protocol.startsWith("svn+")) && SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage())) {
            Subversion.LOG.log(Level.INFO, e.getMessage(), e);
            SvnClientExceptionHandler.annotate(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ErrorFileNotFoundInRevision", (Object[])new String[]{revision.toString()}));
            return true;
        }
        return false;
    }

    private static void notifyNoClient() {
        MissingClient msc = new MissingClient();
        msc.show();
    }

    private static String getCustomizedMessage(Exception exception) {
        String msg = null;
        if (SvnClientExceptionHandler.isHTTP405(exception.getMessage())) {
            msg = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error405");
        } else if (SvnClientExceptionHandler.isOutOfDate(exception.getMessage()) || SvnClientExceptionHandler.isMissingOrLocked(exception.getMessage())) {
            msg = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OutOfDate") + "\n";
        } else if (SvnClientExceptionHandler.isWrongUUID(exception.getMessage())) {
            msg = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_RelocateWrongUUID") + "\n";
        }
        return msg;
    }

    public static String parseExceptionMessage(SVNClientException ex) {
        String msg = ex.getMessage();
        msg = msg.replace("svn: warning: ", "");
        if (SvnClientExceptionHandler.isTooOldClientForWC(msg = msg.replace("svn: ", ""))) {
            msg = msg + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OldClient");
        }
        return msg;
    }

    public static void annotate(String msg) {
        CommandReport report = new CommandReport(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_SubversionCommandError"), msg);
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_CommandReport_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)report, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), -1, 0, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    private static void cancelledAction() {
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    static void handleInvalidKeyException(InvalidKeyException ike) {
        Subversion.LOG.log(Level.INFO, ike.getMessage(), ike);
        String msg = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_InvalidKeyException");
        SvnClientExceptionHandler.annotate(msg);
    }

    private boolean isBadRecordMac(String message) {
        return (message = message.toLowerCase()).contains("received fatal alert") && message.contains("bad_record_mac");
    }

    private class CertificateFailure {
        int mask;
        String error;
        String message;

        CertificateFailure(int mask, String error, String message) {
            this.mask = mask;
            this.error = error;
            this.message = message;
        }
    }
}

