/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.netbeans.modules.html.palette.items.TABLECustomizer;
import org.openide.text.ActiveEditorDrop;

public class TABLE
implements ActiveEditorDrop {
    private static final int ROWS_DEFAULT = 2;
    private static final int COLS_DEFAULT = 2;
    private static final int BORDER_DEFAULT = 1;
    private static final int WIDTH_DEFAULT = 0;
    private static final int CSPAC_DEFAULT = 0;
    private static final int CPADD_DEFAULT = 0;
    private int rows = 2;
    private int cols = 2;
    private int border = 1;
    private int width = 0;
    private int cspac = 0;
    private int cpadd = 0;

    public boolean handleTransfer(JTextComponent targetComponent) {
        TABLECustomizer c = new TABLECustomizer(this);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HtmlPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String tHead = this.generateTHead();
        String tBody = this.generateTBody();
        String strBorder = " border=\"" + this.border + "\"";
        String strWidth = "";
        if (this.width != 0) {
            strWidth = " width=\"" + this.width + "\"";
        }
        String strCspac = "";
        if (this.cspac != 0) {
            strCspac = " cellspacing=\"" + this.cspac + "\"";
        }
        String strCpadd = "";
        if (this.cpadd != 0) {
            strCpadd = " cellpadding=\"" + this.cpadd + "\"";
        }
        String body = "<table" + strBorder + strWidth + strCspac + strCpadd + ">\n" + "<thead>\n" + tHead + "</thead>\n" + "<tbody>\n" + tBody + "</tbody>\n" + "</table>\n";
        return body;
    }

    private String generateTHead() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cols; ++i) {
            sb.append("<th></th>\n");
        }
        String thead = "<tr>\n" + sb.toString() + "</tr>\n";
        return thead;
    }

    private String generateTBody() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.rows; ++i) {
            sb.append("<tr>\n");
            for (int j = 0; j < this.cols; ++j) {
                sb.append("<td></td>\n");
            }
            sb.append("</tr>\n");
        }
        String tBody = sb.toString();
        return tBody;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setCspac(int cspac) {
        this.cspac = cspac;
    }

    public void setCpadd(int cpadd) {
        this.cpadd = cpadd;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getBorder() {
        return this.border;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCspac() {
        return this.cspac;
    }

    public int getCpadd() {
        return this.cpadd;
    }
}

