/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.nbdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.dialog.FullImageGridPreview;
import org.netbeans.modules.vmd.game.dialog.PartialImageGridPreview;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TiledLayerDialog
extends JPanel
implements ActionListener {
    private GlobalRepository gameDesign;
    private static final Icon ICON_ERROR = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/error.gif", (boolean)false);
    private static final int DEFAULT_COLS = 20;
    private static final int DEFAULT_ROWS = 20;
    private static final int DEFAULT_TILE_WIDTH = 18;
    private static final int DEFAULT_TILE_HEIGHT = 18;
    private ButtonGroup buttonGroupLayers;
    private JButton buttonImportImages;
    private JCheckBox checkBoxZoom;
    private JTextField fieldLayerName;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelError;
    private JLabel labelImageFile;
    private JLabel labelImagePreview;
    private JLabel labelTileHeight;
    private JLabel labelTileWidth;
    private JList listImageFileName;
    private JPanel panelCustomizer;
    private JPanel panelError;
    private JPanel panelImage;
    private JPanel panelLayerInfo;
    private JPanel panelPreview;
    private JSlider sliderHeight;
    private JSlider sliderWidth;
    private DialogDescriptor dd;
    public static final boolean DEBUG = false;
    private SliderListener sliderListener = new SliderListener();
    private AbstractImagePreviewComponent imagePreview;
    private PartialImageGridPreview partialImagePreview = new PartialImageGridPreview();
    private FullImageGridPreview fullImagePreview = new FullImageGridPreview();
    private Scene scene;
    private List<Integer> tileWidths;
    private List<Integer> tileHeigths;

    public TiledLayerDialog(GlobalRepository globalRepository) {
        this.gameDesign = globalRepository;
        this.initComponents();
        this.manualInit();
    }

    public TiledLayerDialog(Scene scene) {
        this(scene.getGameDesign());
        this.scene = scene;
    }

    private void initComponents() {
        this.buttonGroupLayers = new ButtonGroup();
        this.panelCustomizer = new JPanel();
        this.labelImageFile = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listImageFileName = new JList();
        this.buttonImportImages = new JButton();
        this.panelPreview = new JPanel();
        this.labelImagePreview = new JLabel();
        this.panelImage = new JPanel();
        this.sliderWidth = new JSlider();
        this.sliderHeight = new JSlider();
        this.labelTileWidth = new JLabel();
        this.labelTileHeight = new JLabel();
        this.checkBoxZoom = new JCheckBox();
        this.panelError = new JPanel();
        this.labelError = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.panelLayerInfo = new JPanel();
        this.fieldLayerName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.labelImageFile.setLabelFor(this.listImageFileName);
        Mnemonics.setLocalizedText((JLabel)this.labelImageFile, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.txt"));
        this.listImageFileName.setModel(this.getImageListModel());
        this.listImageFileName.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.listImageFileName);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonImportImages, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.txt"));
        this.buttonImportImages.setActionCommand(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.txt"));
        GroupLayout groupLayout = new GroupLayout((Container)this.panelCustomizer);
        this.panelCustomizer.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.labelImageFile).add((Component)this.buttonImportImages).add((Component)this.jScrollPane1, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.labelImageFile).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 261, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.buttonImportImages)));
        this.labelImageFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.accessible.name"));
        this.labelImageFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImage.accessible.description"));
        this.buttonImportImages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.accessible.name"));
        this.buttonImportImages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.buttonImportImages.accessible.description"));
        this.labelImagePreview.setLabelFor(this.panelImage);
        this.labelImagePreview.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.txt"));
        this.panelImage.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panelImage.setLayout(new BorderLayout());
        this.sliderHeight.setOrientation(1);
        this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object[])new Object[]{0}));
        this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object[])new Object[]{0}));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxZoom, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.txt"));
        this.checkBoxZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkBoxZoom.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.panelPreview);
        this.panelPreview.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.labelTileWidth).add(51, 51, 51).add((Component)this.labelTileHeight).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.sliderWidth, -1, 389, Short.MAX_VALUE).add(22, 22, 22)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.labelImagePreview).addPreferredGap(0, 224, Short.MAX_VALUE).add((Component)this.checkBoxZoom)).add((Component)this.panelImage, -1, 381, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.sliderHeight, -2, -1, -2)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.labelImagePreview).add((Component)this.checkBoxZoom)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.sliderHeight, -1, 249, Short.MAX_VALUE).add(1, (Component)this.panelImage, -1, 249, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.sliderWidth, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.labelTileWidth, -2, 16, -2).add((Component)this.labelTileHeight))));
        this.labelImagePreview.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.accessible.name"));
        this.labelImagePreview.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelAdjustTileSize.accessible.description"));
        this.sliderWidth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderWidth.accessible.name"));
        this.sliderWidth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderWidth.accessible.description"));
        this.sliderHeight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderHeight.accessible.name"));
        this.sliderHeight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.sliderHeight.accessible.description"));
        this.checkBoxZoom.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.accessible.name"));
        this.checkBoxZoom.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelZoom.accessible.description"));
        this.labelError.setForeground(new Color(255, 0, 0));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.panelError);
        this.panelError.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.labelError, -1, 686, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).add((Component)this.labelError, -2, 27, -2)));
        this.jLabel3.setLabelFor(this.fieldLayerName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.txt"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.panelLayerInfo);
        this.panelLayerInfo.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1).add((Component)this.fieldLayerName, -1, 591, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.fieldLayerName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.accessible.name"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelTiledLayerName.accessible.description"));
        this.jSeparator2.setOrientation(1);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.panelLayerInfo, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addPreferredGap(0).add((Component)this.panelCustomizer, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator2, -2, 8, -2).addPreferredGap(1).add((Component)this.panelPreview, -1, -1, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 686, Short.MAX_VALUE).add(2, (Component)this.panelError, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.panelLayerInfo, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 13, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.panelCustomizer, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 322, Short.MAX_VALUE).add((Component)this.panelPreview, -2, -1, -2)).addPreferredGap(0).add((Component)this.panelError, -2, -1, -2).addContainerGap()));
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
    }

    private void manualInit() {
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.accessible.description"));
        this.labelError.setIcon(ICON_ERROR);
        this.labelError.setText(null);
        this.fieldLayerName.getDocument().addDocumentListener(new LayerFieldListener());
        this.fieldLayerName.addFocusListener(new LayerFieldListener());
        this.listImageFileName.addListSelectionListener(new ImageListListener());
        this.listImageFileName.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Map.Entry entry = (Map.Entry)object;
                return super.getListCellRendererComponent((JList<?>)jList, entry.getValue(), n, bl, bl2);
            }
        });
        this.sliderWidth.setModel(new DefaultBoundedRangeModel());
        this.sliderHeight.setModel(new DefaultBoundedRangeModel());
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
        this.sliderWidth.setValue(0);
        this.sliderHeight.setValue(0);
        this.sliderWidth.setPaintLabels(true);
        this.sliderHeight.setPaintLabels(true);
        this.sliderWidth.setSnapToTicks(true);
        this.sliderHeight.setSnapToTicks(true);
        this.sliderWidth.setEnabled(false);
        this.sliderHeight.setEnabled(false);
        this.checkBoxZoom.setEnabled(false);
        this.buttonImportImages.addActionListener(this);
        this.setPreviewFull();
        this.checkBoxZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TiledLayerDialog.this.checkBoxZoom.isSelected()) {
                    TiledLayerDialog.this.setPreviewPartial();
                } else {
                    TiledLayerDialog.this.setPreviewFull();
                }
            }
        });
    }

    private void setPreviewPartial() {
        if (this.imagePreview != null) {
            try {
                this.partialImagePreview.setImageURL(this.imagePreview.getImageURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt"));
                malformedURLException.printStackTrace();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt"));
                return;
            }
            this.partialImagePreview.setTileWidth(this.imagePreview.getTileWidth());
            this.partialImagePreview.setTileHeight(this.imagePreview.getTileHeight());
        }
        this.panelImage.removeAll();
        this.panelImage.add((Component)this.partialImagePreview, "Center");
        this.imagePreview = this.partialImagePreview;
        this.repaint();
        this.validate();
    }

    private void setPreviewFull() {
        if (this.imagePreview != null) {
            try {
                this.fullImagePreview.setImageURL(this.imagePreview.getImageURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt"));
                malformedURLException.printStackTrace();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.labelError.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt"));
                illegalArgumentException.printStackTrace();
                return;
            }
            this.fullImagePreview.setTileWidth(this.imagePreview.getTileWidth());
            this.fullImagePreview.setTileHeight(this.imagePreview.getTileHeight());
        }
        this.panelImage.removeAll();
        JScrollPane jScrollPane = new JScrollPane(this.fullImagePreview);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.panelImage.add((Component)jScrollPane, "Center");
        this.imagePreview = this.fullImagePreview;
        this.repaint();
        this.validate();
    }

    private List<Map.Entry<FileObject, String>> getImageList() {
        Map map = MidpProjectSupport.getImagesForProject((DesignDocument)this.gameDesign.getDesignDocument(), (boolean)true);
        ArrayList<Map.Entry<FileObject, String>> arrayList = new ArrayList<Map.Entry<FileObject, String>>();
        arrayList.addAll(map.entrySet());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((String)entry.getValue()).compareTo((String)entry2.getValue());
            }
        });
        return arrayList;
    }

    private DefaultListModel getImageListModel() {
        DefaultListModel<Map.Entry<FileObject, String>> defaultListModel = new DefaultListModel<Map.Entry<FileObject, String>>();
        List<Map.Entry<FileObject, String>> list = this.getImageList();
        for (Map.Entry<FileObject, String> entry : list) {
            defaultListModel.addElement(entry);
        }
        return defaultListModel;
    }

    private String getFieldLayerNameError() {
        String string = NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelInvalidName.txt");
        String string2 = null;
        String string3 = this.fieldLayerName.getText();
        if (string3.equals("")) {
            string2 = NbBundle.getMessage(TiledLayerDialog.class, (String)"TiledLayerDialog.labelEnterName.txt");
        } else if (!this.gameDesign.isComponentNameAvailable(string3)) {
            string2 = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelNameExists.txt");
        } else if (!TiledLayerDialog.isValidJavaIdentifier(string3)) {
            string2 = string;
        }
        return string2;
    }

    private static boolean isValidJavaIdentifier(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setOKButtonEnabled(boolean bl) {
        if (!bl) {
            this.labelError.setIcon(ICON_ERROR);
        } else {
            this.labelError.setIcon(null);
        }
        this.dd.setValid(bl);
    }

    private String getFieldImageFileNameError() {
        String string = null;
        if (this.listImageFileName.getModel().getSize() == 0) {
            string = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelNoImages.txt");
        } else if (this.listImageFileName.getSelectedValue() == null) {
            string = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelSelectImgFile.txt");
        } else {
            Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
            URL uRL = null;
            try {
                uRL = ((FileObject)entry.getKey()).getURL();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string2 = (String)entry.getValue();
            assert (uRL != null);
            assert (string2 != null);
            String string3 = CodeUtils.getIdealImageName(string2);
            List<String> list = GlobalRepository.deriveUsedNames(string3);
            for (String string4 : list) {
                if (!string4.equals(this.fieldLayerName.getText())) continue;
                string = NbBundle.getMessage(SpriteDialog.class, (String)"SpriteDialog.imgFileSameAsLayerName.txt");
            }
        }
        return string;
    }

    private void handleImageStateChange() {
        String string = null;
        boolean bl = !this.listImageFileName.isSelectionEmpty();
        this.sliderWidth.setEnabled(bl);
        this.sliderHeight.setEnabled(bl);
        this.checkBoxZoom.setEnabled(bl);
        string = this.getFieldLayerNameError();
        if (!bl) {
            this.clearImagePreview();
        } else {
            try {
                this.loadImagePreview();
            }
            catch (MalformedURLException malformedURLException) {
                string = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgLoc.txt");
                malformedURLException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelInvalidImgFomat.txt");
                illegalArgumentException.printStackTrace();
            }
        }
        if (string == null) {
            string = this.getFieldImageFileNameError();
        }
        if (string != null) {
            this.labelError.setText(string);
            this.setOKButtonEnabled(false);
        } else {
            this.labelError.setText("");
            this.setOKButtonEnabled(true);
        }
    }

    private void clearImagePreview() {
        this.sliderWidth.removeChangeListener(this.sliderListener);
        this.sliderHeight.removeChangeListener(this.sliderListener);
        this.sliderWidth.setModel(new DefaultBoundedRangeModel());
        this.sliderHeight.setModel(new DefaultBoundedRangeModel());
        this.sliderWidth.setValue(0);
        this.sliderHeight.setValue(0);
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
    }

    private void loadImagePreview() throws MalformedURLException, IllegalArgumentException {
        Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
        URL uRL = null;
        try {
            if (entry == null || entry.getKey() == null || ((FileObject)entry.getKey()).getURL() == null) {
                Debug.warning((Object[])new Object[]{"imageURL is null"});
            } else {
                uRL = ((FileObject)entry.getKey()).getURL();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (uRL == null) {
            return;
        }
        this.sliderWidth.removeChangeListener(this.sliderListener);
        this.sliderHeight.removeChangeListener(this.sliderListener);
        this.imagePreview.setImageURL(uRL);
        this.tileWidths = this.imagePreview.getValidTileWidths();
        this.tileHeigths = this.imagePreview.getValidTileHeights();
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(this.tileWidths.size() - 1, 0, 0, this.tileWidths.size() - 1);
        DefaultBoundedRangeModel defaultBoundedRangeModel2 = new DefaultBoundedRangeModel(this.tileHeigths.size() - 1, 0, 0, this.tileHeigths.size() - 1);
        this.sliderWidth.setModel(defaultBoundedRangeModel);
        this.sliderHeight.setModel(defaultBoundedRangeModel2);
        this.sliderWidth.setValue(this.tileWidths.indexOf(TiledLayerDialog.getNearestValue(18, this.tileWidths)));
        this.sliderHeight.setValue(this.tileHeigths.indexOf(TiledLayerDialog.getNearestValue(18, this.tileHeigths)));
        int n = this.tileWidths.get(this.sliderWidth.getValue());
        int n2 = this.tileHeigths.get(this.sliderHeight.getValue());
        this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object)n2));
        this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object)n));
        this.imagePreview.setTileWidth(n);
        this.imagePreview.setTileHeight(n2);
        this.repaint();
        this.sliderWidth.addChangeListener(this.sliderListener);
        this.sliderHeight.addChangeListener(this.sliderListener);
    }

    private static int getNearestValue(int n, List<Integer> list) {
        int n2 = Integer.MAX_VALUE;
        for (Integer n3 : list) {
            int n4 = Math.abs(n - n2);
            int n5 = Math.abs(n - n3);
            if (n5 >= n4 && (n5 != n4 || n3 <= n2)) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
            this.handleOKButton();
        }
        if (actionEvent.getSource() == this.buttonImportImages) {
            try {
                this.handleImportImagesButton();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImportImagesButton() throws IOException {
        InputStream inputStream = TiledLayerDialog.class.getResourceAsStream("res/platform_tiles.png");
        assert (inputStream != null);
        InputStream inputStream2 = TiledLayerDialog.class.getResourceAsStream("res/topview_tiles.png");
        assert (inputStream2 != null);
        Project project = MidpProjectSupport.getProjectForDocument((DesignDocument)this.gameDesign.getDesignDocument());
        SourceGroup sourceGroup = MidpProjectSupport.getSourceGroup((Project)project);
        FileObject fileObject = sourceGroup.getRootFolder();
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        try {
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"platform_tiles.png");
            FileObject fileObject3 = FileUtil.createData((FileObject)fileObject, (String)"topview_tiles.png");
            outputStream2 = fileObject2.getOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream2);
            outputStream = fileObject3.getOutputStream();
            FileUtil.copy((InputStream)inputStream2, (OutputStream)outputStream);
        }
        finally {
            try {
                if (outputStream2 != null) {
                    outputStream2.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        this.listImageFileName.setModel(this.getImageListModel());
        this.handleImageStateChange();
    }

    private void handleOKButton() {
        String string = this.fieldLayerName.getText();
        int n = this.tileWidths.get(this.sliderWidth.getValue());
        int n2 = this.tileHeigths.get(this.sliderHeight.getValue());
        Map.Entry entry = (Map.Entry)this.listImageFileName.getSelectedValue();
        URL uRL = null;
        String string2 = null;
        try {
            if (entry == null || entry.getKey() == null || ((FileObject)entry.getKey()).getURL() == null) {
                Debug.warning((Object[])new Object[]{"imageURL is null"});
            } else {
                uRL = ((FileObject)entry.getKey()).getURL();
                string2 = (String)entry.getValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (uRL == null || string2 == null) {
            return;
        }
        ImageResource imageResource = this.gameDesign.getImageResource(uRL, string2);
        if (this.scene != null) {
            this.scene.createTiledLayer(string, imageResource, 20, 20, n, n2);
        } else {
            this.gameDesign.createTiledLayer(string, imageResource, 20, 20, n, n2);
        }
    }

    private class ImageListListener
    implements ListSelectionListener {
        private ImageListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TiledLayerDialog.this.handleImageStateChange();
        }
    }

    private class LayerFieldListener
    implements DocumentListener,
    FocusListener {
        private LayerFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleContentChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleContentChange();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleContentChange();
        }

        private void handleContentChange() {
            String string = TiledLayerDialog.this.getFieldLayerNameError();
            if (string == null) {
                string = TiledLayerDialog.this.getFieldImageFileNameError();
            }
            TiledLayerDialog.this.labelError.setText(string);
            if (string == null) {
                TiledLayerDialog.this.setOKButtonEnabled(true);
            } else {
                TiledLayerDialog.this.setOKButtonEnabled(false);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.handleContentChange();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = (Integer)TiledLayerDialog.this.tileWidths.get(TiledLayerDialog.this.sliderWidth.getValue());
            int n2 = (Integer)TiledLayerDialog.this.tileHeigths.get(TiledLayerDialog.this.sliderHeight.getValue());
            if (changeEvent.getSource() == TiledLayerDialog.this.sliderHeight) {
                TiledLayerDialog.this.imagePreview.setTileHeight(n2);
                TiledLayerDialog.this.labelTileHeight.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTileheight.txt", (Object)n2));
            } else if (changeEvent.getSource() == TiledLayerDialog.this.sliderWidth) {
                TiledLayerDialog.this.imagePreview.setTileWidth(n);
                TiledLayerDialog.this.labelTileWidth.setText(NbBundle.getMessage(TiledLayerDialog.class, (String)"SpriteDialog.labelTilewidth.txt", (Object)n));
            }
        }
    }
}

