/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;

public class TiledLayerPreviewPanel
extends JComponent
implements TiledLayerListener {
    private TiledLayer tiledLayer;
    private boolean autoUpdate;

    public TiledLayerPreviewPanel(TiledLayer tiledLayer, boolean bl) {
        this.tiledLayer = tiledLayer;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TiledLayerPreviewPanel.this.repaint();
            }
        });
        this.setAutoUpdate(bl);
    }

    public void setAutoUpdate(boolean bl) {
        if (bl == this.autoUpdate) {
            return;
        }
        if (bl) {
            this.tiledLayer.addTiledLayerListener(this);
        } else {
            this.tiledLayer.removeTiledLayerListener(this);
        }
        this.autoUpdate = bl;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void refresh() {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        double d = (double)this.getWidth() / (double)this.tiledLayer.getWidth();
        double d2 = (double)this.getHeight() / (double)this.tiledLayer.getHeight();
        double d3 = Math.min(d, d2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 == d) {
            double d6 = (double)this.tiledLayer.getHeight() * d3;
            d5 = ((double)this.getHeight() - d6) / 2.0;
        } else {
            double d7 = (double)this.tiledLayer.getWidth() * d3;
            d4 = ((double)this.getWidth() - d7) / 2.0;
        }
        graphics2D.translate(d4, d5);
        graphics2D.scale(d3, d3);
        this.paintCellContents(graphics2D);
    }

    private void paintCellContents(Graphics2D graphics2D) {
        for (int i = 0; i < this.tiledLayer.getRowCount(); ++i) {
            for (int j = 0; j < this.tiledLayer.getColumnCount(); ++j) {
                Tile tile = this.tiledLayer.getTileAt(i, j);
                if (tile == null) continue;
                tile.paint(graphics2D, j * tile.getWidth(), i * tile.getHeight());
            }
        }
    }

    @Override
    public void tileChanged(TiledLayer tiledLayer, int n, int n2) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void tilesChanged(TiledLayer tiledLayer, Set set) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void columnsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void columnsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void rowsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void rowsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.tiledLayerChangedVisualy();
    }

    @Override
    public void tilesStructureChanged(TiledLayer tiledLayer) {
        this.tiledLayerChangedVisualy();
    }

    private void tiledLayerChangedVisualy() {
        this.refresh();
    }
}

