/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.vmd.game.editor.common.NonEmptyStringTableCellEditor;
import org.netbeans.modules.vmd.game.editor.scene.BooleanTableCellRenderer;
import org.netbeans.modules.vmd.game.editor.scene.LayerTableCellRenderer;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.LayerDataFlavor;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneSelectionListener;
import org.netbeans.modules.vmd.game.model.adapter.SceneLayerTableAdapter;

public class SceneLayerNavigator
extends JTable {
    public static final boolean DEBUG = false;
    public static final int PAD_X = 4;
    public static final int PAD_Y = 4;
    private static final int IMG_PREVIEW_WIDTH = 40;
    private static final int IMG_PREVIEW_HEIGHT = 30;
    private static final Logger LOG = Logger.getLogger(SceneLayerNavigator.class.getName());
    private Scene scene;

    public SceneLayerNavigator(Scene scene) {
        this.scene = scene;
        this.setModel(new SceneLayerTableAdapter(scene));
        this.getColumnModel().setColumnMargin(0);
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, new DGL());
        DropTarget dropTarget = new DropTarget(this, new TableDropTarget());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        this.getSelectionModel().addListSelectionListener(new SceneTableSelectionListener());
        this.scene.addSceneListener(new ExternalSceneSelectionListener());
        this.setRowHeight(30);
        int n = 40 + this.getColumnModel().getColumnMargin();
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn.setMinWidth(n);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(n);
        tableColumn2.setMaxWidth(n);
        tableColumn2.setMinWidth(n);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(n);
        tableColumn3.setMaxWidth(n);
        tableColumn3.setMinWidth(n);
        TableColumn tableColumn4 = this.getColumnModel().getColumn(3);
        tableColumn4.setPreferredWidth(n);
        tableColumn4.setMaxWidth(n);
        tableColumn4.setMinWidth(n);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellRenderer(4, 4));
        this.setDefaultRenderer(Boolean.class, new BooleanTableCellRenderer(4, 4));
        this.setDefaultRenderer(Layer.class, new LayerTableCellRenderer());
        this.setDefaultEditor(String.class, new NonEmptyStringTableCellEditor());
        this.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        TableColumn tableColumn5 = this.getColumnModel().getColumn(5);
        tableColumn5.setPreferredWidth(n + 10);
        tableColumn5.setMaxWidth(n + 10);
        tableColumn5.setMinWidth(n + 10);
        TableColumn tableColumn6 = this.getColumnModel().getColumn(6);
        tableColumn6.setPreferredWidth(n + 10);
        tableColumn6.setMaxWidth(n + 10);
        tableColumn6.setMinWidth(n + 10);
        this.setShowVerticalLines(false);
        this.setSelectionMode(2);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    private class TableDropTarget
    extends DropTargetAdapter {
        private TableDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            int n = SceneLayerNavigator.this.rowAtPoint(point);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                LayerDataFlavor layerDataFlavor = new LayerDataFlavor();
                if (transferable.isDataFlavorSupported(layerDataFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    Layer layer = (Layer)transferable.getTransferData(layerDataFlavor);
                    SceneLayerNavigator.this.scene.insert(layer, n);
                    dropTargetDropEvent.dropComplete(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = SceneLayerNavigator.this.rowAtPoint(point);
            Layer layer = SceneLayerNavigator.this.scene.getLayerAt(n);
            SceneLayerNavigator.this.setRowSelectionInterval(n, n);
            dragGestureEvent.startDrag(null, layer, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            super.dragDropEnd(dragSourceDropEvent);
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }
    }

    private class ExternalSceneSelectionListener
    implements SceneSelectionListener {
        private ExternalSceneSelectionListener() {
        }

        @Override
        public void layerSelectionChanged(Scene scene, Layer layer, boolean bl) {
            int n = SceneLayerNavigator.this.scene.indexOf(layer);
            if (bl) {
                SceneLayerNavigator.this.getSelectionModel().addSelectionInterval(n, n);
            } else {
                SceneLayerNavigator.this.getSelectionModel().removeSelectionInterval(n, n);
            }
        }
    }

    private class SceneTableSelectionListener
    implements ListSelectionListener {
        private SceneTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            int n3 = Math.min(n2, SceneLayerNavigator.this.scene.getLayerCount() - 1);
            for (int i = n; i <= n3; ++i) {
                Layer layer = SceneLayerNavigator.this.scene.getLayerAt(i);
                SceneLayerNavigator.this.scene.setLayerSelected(layer, SceneLayerNavigator.this.getSelectionModel().isSelectedIndex(i));
            }
        }
    }
}

