/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class NbToolTip
extends FileChangeAdapter {
    private static final Logger LOG = Logger.getLogger(NbToolTip.class.getName());
    private static final HashMap<String, WeakReference<NbToolTip>> mime2tip = new HashMap();
    private static final AtomicInteger lastRequestId = new AtomicInteger(0);
    private final String mimeType;
    private Annotation[] tipAnnotations;
    private static final RequestProcessor toolTipRP = new RequestProcessor("ToolTip-Evaluator", 1);
    private static volatile Reference<RequestProcessor.Task> lastToolTipTask = new WeakReference<Object>(null);

    static synchronized void buildToolTip(JTextComponent target) {
        String mimeType = NbEditorUtilities.getMimeType(target.getDocument());
        NbToolTip tip = NbToolTip.getTip(mimeType);
        tip.buildTip(target);
    }

    private static int newRequestId() {
        return lastRequestId.incrementAndGet();
    }

    private static int getLastRequestId() {
        return lastRequestId.get();
    }

    private NbToolTip(String mimeType) {
        this.mimeType = mimeType;
    }

    private static NbToolTip getTip(String mimeType) {
        NbToolTip tip;
        WeakReference<NbToolTip> nttWr = mime2tip.get(mimeType);
        NbToolTip nbToolTip = tip = nttWr == null ? null : (NbToolTip)((Object)nttWr.get());
        if (tip == null) {
            tip = new NbToolTip(mimeType);
            mime2tip.put(mimeType, new WeakReference<NbToolTip>(tip));
        }
        return tip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Annotation[] getTipAnnotations() {
        Class<NbToolTip> clazz = NbToolTip.class;
        synchronized (NbToolTip.class) {
            Annotation[] annos = this.tipAnnotations;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (annos != null) return annos;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Searching for tooltip annotations for mimeType = '" + this.mimeType + "'");
            }
            FileObject annoFolder = FileUtil.getConfigFile((String)("Editors/" + this.mimeType + "/ToolTips"));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("tooltip annotation folder = '" + annoFolder + "'");
            }
            if (annoFolder != null) {
                ArrayList<Annotation> al = new ArrayList<Annotation>();
                Enumeration en = annoFolder.getChildren(false);
                while (en.hasMoreElements()) {
                    FileObject fo = (FileObject)en.nextElement();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("tooltip annotation fileobject=" + fo);
                    }
                    try {
                        DataObject dob = DataObject.find((FileObject)fo);
                        InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("tooltip annotation instanceCookie=" + ic);
                        }
                        if (ic == null) continue;
                        Object a = ic.instanceCreate();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("tooltip annotation instance=" + a);
                        }
                        if (!(a instanceof Annotation)) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found tooltip annotation = " + a + ", class = " + a.getClass() + " for mimeType = '" + this.mimeType + "'");
                        }
                        al.add((Annotation)a);
                    }
                    catch (DataObjectNotFoundException donfe) {
                        LOG.log(Level.FINE, null, donfe);
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.FINE, null, ioe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOG.log(Level.FINE, null, cnfe);
                    }
                }
                annos = al.toArray(new Annotation[al.size()]);
                Class<NbToolTip> clazz2 = NbToolTip.class;
                synchronized (NbToolTip.class) {
                    this.tipAnnotations = annos;
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    annoFolder.addFileChangeListener((FileChangeListener)this);
                    return annos;
                }
            }
            Class<NbToolTip> clazz3 = NbToolTip.class;
            synchronized (NbToolTip.class) {
                this.tipAnnotations = new Annotation[0];
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return annos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTip(JTextComponent target) {
        EditorCookie ec;
        DataObject dob;
        ToolTipSupport tts;
        EditorUI eui = Utilities.getEditorUI((JTextComponent)target);
        ToolTipSupport toolTipSupport = tts = eui == null ? null : eui.getToolTipSupport();
        if (tts == null) {
            return;
        }
        String toolTipText = target.getUI().getToolTipText(target, tts.getLastMouseEvent().getPoint());
        if (toolTipText != null) {
            return;
        }
        Annotation[] annos = this.getTipAnnotations();
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        if (doc != null && (dob = NbEditorUtilities.getDataObject((Document)doc)) != null && dob.isValid() && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
            StyledDocument openedDoc = ec.getDocument();
            if (openedDoc != doc) {
                return;
            }
            doc.readLock();
            try {
                BaseKit kit;
                Point p = tts.getLastMouseEvent().getPoint();
                int offset = NbToolTip.getOffsetForPoint(p, target, doc);
                if (offset >= 0 && (kit = Utilities.getKit((JTextComponent)target)) instanceof NbEditorKit) {
                    HighlightsSequence seq;
                    Object tooltipAttributeValue = null;
                    Line.Part lp = null;
                    Annotation[] tooltipAnnotations = null;
                    AnnotationDesc annoDesc = null;
                    HighlightsContainer highlights = (HighlightsContainer)target.getClientProperty("TooltipHighlightsContainer");
                    if (highlights == null) {
                        highlights = HighlightingManager.getInstance().getHighlights(target, null);
                        target.putClientProperty("TooltipHighlightsContainer", highlights);
                    }
                    if ((seq = highlights.getHighlights(offset, offset + 1)).moveNext()) {
                        tooltipAttributeValue = seq.getAttributes().getAttribute(EditorStyleConstants.Tooltip);
                    }
                    if (annos != null) {
                        Line l;
                        int line = Utilities.getLineOffset((BaseDocument)doc, (int)offset);
                        int col = offset - Utilities.getRowStart((JTextComponent)target, (int)offset);
                        Line.Set ls = ec.getLineSet();
                        if (ls != null && (l = ls.getCurrent(line)) != null && (lp = l.createPart(col, 0)) != null) {
                            annoDesc = doc.getAnnotations().getActiveAnnotation(line);
                            if (annoDesc != null && (offset < annoDesc.getOffset() || offset >= annoDesc.getOffset() + annoDesc.getLength())) {
                                annoDesc = null;
                            }
                            tooltipAnnotations = annos;
                        }
                    }
                    if (lp != null && tooltipAnnotations != null || tooltipAttributeValue != null) {
                        int requestId = NbToolTip.newRequestId();
                        RequestProcessor.Task lttt = lastToolTipTask.get();
                        if (lttt != null) {
                            lttt.cancel();
                        }
                        lastToolTipTask = new WeakReference<RequestProcessor.Task>(toolTipRP.post((Runnable)new Request(annoDesc, tooltipAnnotations, lp, offset, tooltipAttributeValue, tts, target, (AbstractDocument)doc, (NbEditorKit)kit, requestId)));
                    }
                }
            }
            catch (BadLocationException ble) {
                LOG.log(Level.FINE, null, ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private static int getOffsetForPoint(Point p, JTextComponent c, BaseDocument doc) throws BadLocationException {
        if (p.x >= 0 && p.y >= 0) {
            int offset = c.viewToModel(p);
            Rectangle r = c.modelToView(offset);
            EditorUI eui = Utilities.getEditorUI((JTextComponent)c);
            if (eui != null && r.y == p.y / eui.getLineHeight() * eui.getLineHeight() && offset < Utilities.getRowEnd((BaseDocument)doc, (int)offset)) {
                return offset;
            }
        }
        return -1;
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener,
    DocumentListener {
        private ToolTipSupport tts;
        private final Annotation[] annos;
        private final AnnotationDesc annoDesc;
        private final Line.Part linePart;
        private final JTextComponent component;
        private final AbstractDocument doc;
        private final NbEditorKit kit;
        private final int offset;
        private final Object tooltipAttributeValue;
        private final int requestId;
        private boolean documentModified;

        Request(AnnotationDesc annoDesc, Annotation[] annos, Line.Part lp, int offset, Object tooltipAttributeValue, ToolTipSupport tts, JTextComponent component, AbstractDocument doc, NbEditorKit kit, int requestId) {
            this.annoDesc = annoDesc;
            this.annos = annos;
            this.linePart = lp;
            this.tts = tts;
            this.component = component;
            this.doc = doc;
            this.kit = kit;
            this.offset = offset;
            this.tooltipAttributeValue = tooltipAttributeValue;
            this.requestId = requestId;
        }

        @Override
        public void run() {
            String tooltipText;
            if (this.tts == null) {
                return;
            }
            if (this.tts == null || this.tts.getStatus() == 0) {
                return;
            }
            if (!this.isRequestValid()) {
                return;
            }
            if (this.tts != null) {
                this.tts.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if ((tooltipText = this.resolveTooltipText()) != null && tooltipText.length() > 0 && this.isRequestValid()) {
                Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToolTipSupport ftts = Request.this.tts;
                        if (ftts != null) {
                            ftts.setToolTipText(tooltipText);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveTooltipText() {
            block22: {
                this.kit.toolTipAnnotationsLock(this.doc);
                try {
                    this.doc.readLock();
                    if (!this.isRequestValid()) {
                        String string = null;
                        return string;
                    }
                    String tooltipFromAnnotations = null;
                    if (this.annos != null) {
                        int i;
                        for (i = 0; i < this.annos.length; ++i) {
                            this.annos[i].attach((Annotatable)this.linePart);
                        }
                        if (this.annoDesc != null) {
                            tooltipFromAnnotations = this.annoDesc.getShortDescription();
                            this.annoDesc.addPropertyChangeListener((PropertyChangeListener)this);
                        } else {
                            for (i = 0; i < this.annos.length; ++i) {
                                String desc = this.annos[i].getShortDescription();
                                if (desc != null) {
                                    tooltipFromAnnotations = desc;
                                }
                                this.annos[i].addPropertyChangeListener((PropertyChangeListener)this);
                            }
                        }
                    }
                    if (tooltipFromAnnotations == null) break block22;
                    String i = tooltipFromAnnotations;
                    return i;
                    finally {
                        this.doc.readUnlock();
                    }
                }
                finally {
                    this.kit.toolTipAnnotationsUnlock(this.doc);
                }
            }
            if (!this.isRequestValid()) {
                return null;
            }
            String tooltipFromHighlightingLayers = null;
            if (this.tooltipAttributeValue != null) {
                if (this.tooltipAttributeValue instanceof String) {
                    tooltipFromHighlightingLayers = (String)this.tooltipAttributeValue;
                } else if (this.tooltipAttributeValue instanceof HighlightAttributeValue) {
                    String value;
                    tooltipFromHighlightingLayers = value = (String)((HighlightAttributeValue)this.tooltipAttributeValue).getValue(this.component, (Document)this.doc, EditorStyleConstants.Tooltip, this.offset, this.offset + 1);
                } else {
                    LOG.fine("Invalid '" + EditorStyleConstants.Tooltip + "' attribute value " + this.tooltipAttributeValue);
                }
            }
            return tooltipFromHighlightingLayers;
        }

        private boolean isRequestValid() {
            return NbToolTip.getLastRequestId() == this.requestId && !this.documentModified && this.isDocumentValid();
        }

        private boolean isDocumentValid() {
            EditorCookie ec;
            DataObject dob = NbEditorUtilities.getDataObject(this.doc);
            if (dob != null && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
                StyledDocument openedDoc;
                try {
                    openedDoc = ec.openDocument();
                }
                catch (IOException e) {
                    openedDoc = null;
                }
                return openedDoc == this.doc;
            }
            return false;
        }

        private void dismiss() {
            if (this.tts != null) {
                this.tts.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.tts = null;
            if (this.annoDesc != null) {
                this.annoDesc.removePropertyChangeListener((PropertyChangeListener)this);
            } else if (this.annos != null) {
                for (int i = 0; i < this.annos.length; ++i) {
                    this.annos[i].removePropertyChangeListener((PropertyChangeListener)this);
                    this.annos[i].detach();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("shortDescription".equals(propName) || "shortDescription".equals(propName)) {
                if (evt.getNewValue() != null) {
                    final String tipText = (String)evt.getNewValue();
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToolTipSupport ftts = Request.this.tts;
                            if (ftts != null) {
                                ftts.setToolTipText(tipText);
                            }
                        }
                    });
                }
            } else if ("status".equals(propName) && (Integer)evt.getNewValue() == 0) {
                this.dismiss();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.documentModified = true;
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.documentModified = true;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }
}

