/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.output;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public final class OutputDocument
implements Document {
    public static final AttributeSet attrs = new TrivialAttributeSet();
    final RootElement rootElement;
    private DocElement[] docElements = new DocElement[100];
    private int docElementsCount;
    private final DocElement lastDocElement = new DocElement(0, "", false);
    private int length = 0;
    private final Position startPosition = new SimplePosition(0);
    private final Position endPosition = new EndPosition();
    private final Element[] rootElements;
    private Map<Object, Object> properties;
    private DocumentListener[] docListeners;
    int cachedOffsetStart = -1;
    int cachedOffsetEnd = -1;
    int cachedIndex = -1;

    OutputDocument() {
        this.rootElement = new RootElement();
        this.rootElements = new Element[]{this.rootElement};
        this.docElements[0] = this.lastDocElement;
        this.docElementsCount = 1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        if (listener == null) {
            return;
        }
        if (this.docListeners == null) {
            this.docListeners = new DocumentListener[1];
            this.docListeners[0] = listener;
        } else {
            DocumentListener[] oldArr = this.docListeners;
            this.docListeners = new DocumentListener[oldArr.length + 1];
            System.arraycopy(oldArr, 0, this.docListeners, 0, oldArr.length);
            this.docListeners[oldArr.length] = listener;
        }
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        if (listener == null) {
            return;
        }
        if (this.docListeners == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.docListeners.length; ++i) {
            if (this.docListeners[i] != listener) continue;
            index = i;
            break;
        }
        if (index != -1) {
            if (this.docListeners.length == 1) {
                this.docListeners = null;
            } else {
                DocumentListener[] oldArr = this.docListeners;
                this.docListeners = new DocumentListener[oldArr.length - 1];
                if (index != 0) {
                    System.arraycopy(oldArr, 0, this.docListeners, 0, index);
                }
                if (index != oldArr.length - 1) {
                    System.arraycopy(oldArr, index + 1, this.docListeners, index, oldArr.length - (index + 1));
                }
            }
        }
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    @Override
    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>(7);
        }
        this.properties.put(key, value);
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.checkLocation(offset);
        assert (false) : "modification is not supported";
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.checkLocation(offset);
        if (offset != this.getLength()) {
            assert (false) : "modification is not supported";
            return;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return;
        }
        if (this.docElementsCount == this.docElements.length) {
            DocElement[] oldElems = this.docElements;
            int oldCapacity = oldElems.length;
            int newCapacity = oldCapacity < 100000 ? oldCapacity * 2 : oldCapacity * 14 / 10;
            this.docElements = new DocElement[newCapacity];
            System.arraycopy(oldElems, 0, this.docElements, 0, this.docElementsCount - 1);
        }
        DocElement newElem = new DocElement(offset, str, a != null);
        int index = this.docElementsCount - 1;
        this.docElements[index] = newElem;
        this.docElements[this.docElementsCount++] = this.lastDocElement;
        this.lastDocElement.offset = offset + strLen;
        this.length += strLen;
        this.fireTextAppended(newElem, index);
    }

    int getElementIndex(int offset) {
        int endIndex;
        int startIndex;
        if (this.cachedIndex != -1) {
            if (offset == this.cachedOffsetStart || offset > this.cachedOffsetStart && offset < this.cachedOffsetEnd) {
                return this.cachedIndex;
            }
            if (offset == this.cachedOffsetEnd) {
                DocElement docElement = this.docElements[this.cachedIndex + 1];
                assert (docElement.offset == offset);
                ++this.cachedIndex;
                this.cachedOffsetStart = this.cachedOffsetEnd;
                this.cachedOffsetEnd = this.cachedOffsetStart + docElement.length;
                return this.cachedIndex;
            }
        }
        if (offset == 0) {
            return 0;
        }
        if (offset >= this.length) {
            return this.docElementsCount - 1;
        }
        if (this.cachedIndex == -1) {
            startIndex = 0;
            endIndex = this.docElementsCount - 1;
        } else if (offset > this.cachedOffsetEnd) {
            startIndex = this.cachedIndex + 1;
            endIndex = this.docElementsCount - 1;
        } else {
            startIndex = 0;
            endIndex = this.cachedIndex;
        }
        int cycles = 0;
        while (endIndex - startIndex > 3) {
            ++cycles;
            int middle = (startIndex + endIndex + 1) / 2;
            if (this.docElements[middle].offset >= offset) {
                endIndex = middle;
                continue;
            }
            startIndex = middle;
        }
        int index = startIndex;
        while (this.docElements[index].offset < offset) {
            ++cycles;
            ++index;
        }
        if (this.docElements[index].offset != offset) {
            --index;
        }
        DocElement docElem = this.docElements[index];
        if (this.cachedIndex == -1 || index >= this.cachedIndex) {
            this.cachedIndex = index;
            this.cachedOffsetStart = docElem.offset;
            this.cachedOffsetEnd = docElem.offset + docElem.length;
        }
        return index;
    }

    private void fireTextAppended(DocElement newElem, int index) {
        if (this.docListeners != null) {
            DocInsertEvent e = new DocInsertEvent(newElem, index);
            for (int i = 0; i < this.docListeners.length; ++i) {
                this.docListeners[i].insertUpdate(e);
            }
        }
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        this.checkLocation(offset);
        if (length < 0) {
            throw new BadLocationException("negative length", offset);
        }
        if (offset + length > this.getLength()) {
            throw new BadLocationException("(offset[" + offset + "] + length[" + length + "]) go beyond total length[" + this.getLength() + ']', this.getLength());
        }
        if (length == 0) {
            return "";
        }
        int elemIndex = this.getElementIndex(offset);
        DocElement docElem = this.docElements[elemIndex];
        if (offset == docElem.offset && length == docElem.length) {
            return docElem.getString();
        }
        if (offset + length <= docElem.offset + docElem.length) {
            return docElem.getString().substring(offset - docElem.offset, offset - docElem.offset + length);
        }
        int finalOffset = offset + length;
        StringBuilder buf = new StringBuilder(length);
        if (docElem.offset == offset) {
            docElem.appendToBuf(buf);
        } else {
            docElem.appendToBuf(buf, offset);
        }
        while (true) {
            docElem = this.docElements[++elemIndex];
            if (docElem.offset >= finalOffset) break;
            docElem.appendToBuf(buf);
        }
        if (finalOffset > docElem.offset) {
            docElem.appendToBuf(buf, docElem.offset, finalOffset);
        }
        return buf.toString();
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.checkLocation(offset);
        if (length < 0) {
            throw new BadLocationException("negative length", offset);
        }
        if (length == 0) {
            txt.array = new char[0];
            txt.offset = 0;
            txt.count = 0;
            return;
        }
        if (offset + length > this.getLength()) {
            throw new BadLocationException("too long text requested", this.getLength());
        }
        int elemIndex = this.getElementIndex(offset);
        DocElement docElem = this.docElements[elemIndex];
        if (offset == docElem.offset && length == docElem.length) {
            txt.array = docElem.getChars();
            txt.offset = 0;
            txt.count = length;
        } else if (offset + length <= docElem.offset + docElem.length) {
            txt.array = docElem.getChars();
            txt.offset = offset - docElem.offset;
            txt.count = length;
        } else if (txt.isPartialReturn()) {
            txt.array = docElem.getChars();
            txt.offset = offset - docElem.offset;
            txt.count = docElem.offset + docElem.length - offset;
        } else {
            int finalOffset = offset + length;
            char[] result = new char[length];
            int charsStoredCount = docElem.offset + docElem.length - offset;
            System.arraycopy(docElem.getChars(), offset - docElem.offset, result, 0, charsStoredCount);
            while (true) {
                docElem = this.docElements[++elemIndex];
                if (docElem.offset >= finalOffset) break;
                System.arraycopy(docElem.getChars(), 0, result, charsStoredCount, docElem.length);
                charsStoredCount += docElem.length;
            }
            if (docElem.offset < finalOffset) {
                System.arraycopy(docElem.getChars(), 0, result, charsStoredCount, finalOffset - docElem.offset);
            }
            txt.array = result;
            txt.offset = 0;
            txt.count = length;
        }
    }

    @Override
    public Position getStartPosition() {
        return this.startPosition;
    }

    @Override
    public Position getEndPosition() {
        return this.endPosition;
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        this.checkLocation(offset);
        return offset != this.length ? new SimplePosition(offset) : new EndPosition();
    }

    private void checkLocation(int offset) throws BadLocationException {
        if (offset < 0) {
            throw new BadLocationException("negative offset", offset);
        }
        if (offset > this.length) {
            throw new BadLocationException("offset > length (" + this.length + ')', offset);
        }
    }

    @Override
    public Element[] getRootElements() {
        return this.rootElements;
    }

    @Override
    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    @Override
    public void render(Runnable r) {
        assert (EventQueue.isDispatchThread());
        r.run();
    }

    private static final class TrivialAttributeSet
    implements AttributeSet {
        private static final String NAME = "Trivial Attribute Set";

        private TrivialAttributeSet() {
        }

        @Override
        public int getAttributeCount() {
            return 1;
        }

        @Override
        public boolean isDefined(Object attrName) {
            return attrName.equals(NameAttribute);
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            return attr.getAttributeCount() == 1 && NAME.equals(attr.getAttribute(NameAttribute));
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object key) {
            return NameAttribute.equals(key) ? NAME : null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return Collections.enumeration(Collections.singleton(NameAttribute));
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            return NameAttribute.equals(name) && NAME.equals(value);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributes) {
            int attrCount = attributes.getAttributeCount();
            return attrCount == 0 || attrCount == 1 && NAME.equals(attributes.getAttribute(NameAttribute));
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }
    }

    final class RootElement
    implements Element {
        private static final String ROOT_NAME = "root element";

        RootElement() {
        }

        @Override
        public Document getDocument() {
            return OutputDocument.this;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public String getName() {
            return ROOT_NAME;
        }

        @Override
        public AttributeSet getAttributes() {
            return attrs;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return OutputDocument.this.getLength();
        }

        @Override
        public int getElementIndex(int offset) {
            return OutputDocument.this.getElementIndex(offset);
        }

        @Override
        public int getElementCount() {
            return OutputDocument.this.docElementsCount;
        }

        @Override
        public Element getElement(int index) {
            return OutputDocument.this.docElements[index];
        }

        DocElement getDocElement(int index) {
            return OutputDocument.this.docElements[index];
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private final class DocInsertEvent
    implements DocumentEvent,
    DocumentEvent.ElementChange {
        private final int index;
        private final DocElement docElem;
        private Element[] childrenAdded;

        private DocInsertEvent(DocElement docElem, int index) {
            this.docElem = docElem;
            this.index = index;
        }

        @Override
        public int getOffset() {
            return this.docElem.offset;
        }

        @Override
        public int getLength() {
            return this.docElem.length;
        }

        @Override
        public Document getDocument() {
            return OutputDocument.this;
        }

        @Override
        public DocumentEvent.EventType getType() {
            return DocumentEvent.EventType.INSERT;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element elem) {
            return elem == OutputDocument.this.rootElement ? this : null;
        }

        @Override
        public Element getElement() {
            return OutputDocument.this.rootElement;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Element[] getChildrenRemoved() {
            return null;
        }

        @Override
        public Element[] getChildrenAdded() {
            if (this.childrenAdded == null) {
                this.childrenAdded = new Element[]{this.docElem};
            }
            return this.childrenAdded;
        }
    }

    private final class EndPosition
    implements Position {
        private EndPosition() {
        }

        @Override
        public int getOffset() {
            assert (EventQueue.isDispatchThread());
            return OutputDocument.this.getLength();
        }
    }

    private static final class SimplePosition
    implements Position {
        private final int offset;

        SimplePosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            assert (EventQueue.isDispatchThread());
            return this.offset;
        }
    }

    final class DocElement
    implements Element {
        int offset;
        final int length;
        String text;
        char[] chars;
        final boolean isError;

        DocElement(int offset, String text, boolean isError) {
            this.offset = offset;
            this.text = text;
            this.chars = null;
            this.length = text.length();
            this.isError = isError;
        }

        char[] getChars() {
            if (this.chars == null) {
                this.chars = this.text.toCharArray();
                this.text = null;
            }
            return this.chars;
        }

        String getString() {
            if (this.text == null) {
                this.text = new String(this.chars);
                this.chars = null;
            }
            return this.text;
        }

        void appendToBuf(StringBuilder buf) {
            if (this.text != null) {
                buf.append(this.text);
            } else {
                assert (this.chars != null);
                buf.append(this.chars);
            }
        }

        void appendToBuf(StringBuilder buf, int offset) {
            int innerOffset = offset - this.offset;
            if (this.text != null) {
                buf.append(this.text, innerOffset, this.length);
            } else {
                assert (this.chars != null);
                buf.append(this.chars, innerOffset, this.length - innerOffset);
            }
        }

        void appendToBuf(StringBuilder buf, int startOffset, int endOffset) {
            if (this.text != null) {
                buf.append(this.text, startOffset - this.offset, endOffset - this.offset);
            } else {
                assert (this.chars != null);
                buf.append(this.chars, startOffset - this.offset, endOffset - startOffset);
            }
        }

        @Override
        public Document getDocument() {
            return OutputDocument.this;
        }

        @Override
        public Element getParentElement() {
            return OutputDocument.this.rootElement;
        }

        @Override
        public String getName() {
            return "DocElement";
        }

        @Override
        public AttributeSet getAttributes() {
            return attrs;
        }

        @Override
        public int getStartOffset() {
            return this.offset;
        }

        @Override
        public int getEndOffset() {
            return this.offset + this.length;
        }

        @Override
        public int getElementIndex(int offset) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }
}

