/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RootNodeChildren;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class RootNode
extends AbstractNode {
    static final int ALL_PASSED_ABSENT = 0;
    static final int SOME_PASSED_ABSENT = 1;
    static final int ALL_PASSED_DISPLAYED = 2;
    private final RootNodeChildren children;
    private volatile boolean filtered;
    private volatile String message;
    private volatile int totalTests = 0;
    private volatile int failures = 0;
    private volatile int errors = 0;
    private volatile int pending = 0;
    private volatile long elapsedTimeMillis = 0L;
    private volatile int detectedPassedTests = 0;
    private boolean sessionFinished;
    private final TestSession session;
    private static final Logger LOGGER = Logger.getLogger(RootNode.class.getName());

    public RootNode(TestSession session, boolean filtered) {
        super((Children)new RootNodeChildren(session, filtered));
        this.session = session;
        this.filtered = filtered;
        this.children = (RootNodeChildren)this.getChildren();
        this.setName(NbBundle.getMessage(RootNode.class, (String)"MSG_RunningTests"));
        this.setIconBaseWithExtension("org/netbeans/modules/gsf/testrunner/resources/empty.gif");
    }

    void displayMessage(String msg) {
        assert (EventQueue.isDispatchThread());
        this.message = msg;
        this.updateDisplayName();
    }

    void displayMessageSessionFinished(String msg) {
        this.sessionFinished = true;
        this.displayMessage(msg);
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(suiteName);
    }

    void displaySuiteRunning(TestSuite suite) {
        assert (EventQueue.isDispatchThread());
        this.children.displaySuiteRunning(suite);
    }

    public TestsuiteNode displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode suiteNode = this.children.displayReport(report);
        this.updateStatistics();
        this.updateDisplayName();
        return suiteNode;
    }

    void displayReports(Collection<Report> reports) {
        assert (EventQueue.isDispatchThread());
        this.children.displayReports(reports);
        this.updateStatistics();
        this.updateDisplayName();
    }

    private synchronized void updateStatistics() {
        this.totalTests = 0;
        this.failures = 0;
        this.errors = 0;
        this.pending = 0;
        this.detectedPassedTests = 0;
        this.elapsedTimeMillis = 0L;
        for (Report rep : this.children.getReports()) {
            this.totalTests += rep.getTotalTests();
            this.failures += rep.getFailures();
            this.errors += rep.getErrors();
            this.pending += rep.getPending();
            this.detectedPassedTests += rep.getDetectedPassedTests();
            this.elapsedTimeMillis += rep.getElapsedTimeMillis();
        }
    }

    float getPassedPercentage() {
        return (float)this.detectedPassedTests / (float)this.totalTests * 100.0f;
    }

    void setFiltered(boolean filtered) {
        assert (EventQueue.isDispatchThread());
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((RootNodeChildren)children).setFiltered(filtered);
        }
    }

    private void updateDisplayName() {
        String msg;
        assert (EventQueue.isDispatchThread());
        Class<?> bundleRefClass = ((Object)((Object)this)).getClass();
        if (this.totalTests == 0) {
            msg = this.sessionFinished ? NbBundle.getMessage(bundleRefClass, (String)"MSG_TestsInfoNoTests") : null;
        } else if (this.failures == 0 && this.errors == 0 && this.pending == 0) {
            msg = NbBundle.getMessage(bundleRefClass, (String)"MSG_TestsInfoAllOK", (Object)new Integer(this.totalTests));
        } else {
            String passedTestsInfo = NbBundle.getMessage(bundleRefClass, (String)"MSG_PassedTestsInfo", (Object)new Integer(this.totalTests - this.failures - this.errors - this.pending));
            String pendingTestsInfo = this.pending == 0 ? null : NbBundle.getMessage(bundleRefClass, (String)"MSG_PendingTestsInfo", (Object)new Integer(this.errors));
            String failedTestsInfo = this.failures == 0 ? null : NbBundle.getMessage(bundleRefClass, (String)"MSG_FailedTestsInfo", (Object)new Integer(this.failures));
            String errorTestsInfo = this.errors == 0 ? null : NbBundle.getMessage(bundleRefClass, (String)"MSG_ErrorTestsInfo", (Object)new Integer(this.errors));
            msg = this.constructMessage(passedTestsInfo, pendingTestsInfo, failedTestsInfo, errorTestsInfo);
        }
        if (this.totalTests != 0) {
            assert (msg != null);
            int successDisplayedLevel = this.getSuccessDisplayedLevel();
            switch (successDisplayedLevel) {
                case 1: {
                    msg = msg + ' ';
                    msg = msg + NbBundle.getMessage(bundleRefClass, (String)"MSG_SomePassedNotDisplayed");
                    break;
                }
                case 0: {
                    msg = msg + ' ';
                    msg = msg + NbBundle.getMessage(bundleRefClass, (String)"MSG_PassedNotDisplayed");
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (msg != null) {
            msg = msg + NbBundle.getMessage(bundleRefClass, (String)"MSG_TestSuiteElapsedTime", (Object)new Double((double)this.elapsedTimeMillis / 1000.0));
        }
        if (this.message != null) {
            msg = msg == null ? this.message : msg + ' ' + this.message;
        }
        LOGGER.fine("Setting display name to: '" + msg + "'. Total tests run: " + this.totalTests + ". Session finished: " + this.sessionFinished);
        this.setDisplayName(msg);
    }

    String constructMessage(String ... subMessages) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (String msg : subMessages) {
            if (msg == null) continue;
            messageList.add(msg);
        }
        int size = messageList.size();
        String key = "MSG_TestResultSummary" + (size - 1);
        return NbBundle.getMessage(RootNode.class, (String)key, (Object[])messageList.toArray(new String[size]));
    }

    int getSuccessDisplayedLevel() {
        int reportedPassedTestsCount = this.totalTests - this.failures - this.errors;
        if (this.detectedPassedTests >= reportedPassedTestsCount) {
            return 2;
        }
        if (this.detectedPassedTests == 0) {
            return 0;
        }
        return 1;
    }

    public SystemAction[] getActions(boolean context) {
        return new SystemAction[0];
    }
}

