/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.text.api.XMLFormatUtil;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DocumentModel;
import org.netbeans.modules.xml.wizard.XMLContentPanel;
import org.netbeans.modules.xml.wizard.XMLGeneratorVisitor;
import org.netbeans.modules.xml.wizard.impl.DTDPanel;
import org.netbeans.modules.xml.wizard.impl.DocumentPanel;
import org.netbeans.modules.xml.wizard.impl.SchemaObject;
import org.netbeans.modules.xml.wizard.impl.SchemaPanel;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class XMLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 5070430920636117204L;
    private static final String XML_EXT = "xml";
    private transient TemplateWizard templateWizard;
    private transient DocumentModel model;
    private transient int current;
    private static final int TARGET_PANEL = 0;
    private transient WizardDescriptor.Panel targetPanel;
    private static final int DOCUMENT_PANEL = 1;
    private transient DocumentPanel documentPanel;
    private static final int CONSTRAINT_PANEL = 2;
    private transient SchemaPanel schemaPanel;
    private transient DTDPanel dtdPanel;
    private static final int CONTENT_PANEL = 3;
    private transient XMLContentPanel xmlPanel;
    private static Reference<XMLWizardIterator> instance;
    private transient Map listenersMap = new HashMap(2);
    private transient String[] beforeSteps;
    private transient Object targetSteps;

    public static synchronized XMLWizardIterator singleton() {
        XMLWizardIterator it;
        XMLWizardIterator xMLWizardIterator = it = instance == null ? null : instance.get();
        if (it == null) {
            it = new XMLWizardIterator();
            instance = new WeakReference<XMLWizardIterator>(it);
        }
        return it;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.templateWizard = templateWizard;
        this.current = 0;
        URL targetFolderURL = null;
        try {
            DataFolder folder = templateWizard.getTargetFolder();
            targetFolderURL = folder.getPrimaryFile().getURL();
            if (!targetFolderURL.toExternalForm().endsWith("/")) {
                targetFolderURL = new URL(targetFolderURL.toExternalForm() + "/");
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.model = new DocumentModel(targetFolderURL);
        Object prop = templateWizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            this.beforeSteps = (String[])prop;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.targetPanel != null) {
            ((JComponent)this.targetPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.targetSteps);
            this.targetPanel = null;
        }
        this.current = -1;
        this.model = null;
        templateWizard = null;
        this.schemaPanel = null;
        this.dtdPanel = null;
        this.documentPanel = null;
        this.xmlPanel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataFolder folder = templateWizard.getTargetFolder();
        File pobj = FileUtil.toFile((FileObject)folder.getPrimaryFile());
        String extension = XML_EXT;
        String targetName = templateWizard.getTargetName();
        if (targetName == null || "null".equals(targetName)) {
            targetName = "XMLDocument";
        }
        final FileObject targetFolder = folder.getPrimaryFile();
        String uniqueTargetName = targetName;
        int i = 2;
        while (targetFolder.getFileObject(uniqueTargetName, XML_EXT) != null) {
            uniqueTargetName = targetName + i;
            ++i;
        }
        final String name = uniqueTargetName;
        String encoding = EncodingUtil.getProjectEncoding((FileObject)folder.getPrimaryFile());
        if (!EncodingUtil.isValidEncoding((String)encoding)) {
            encoding = "UTF-8";
        }
        String nameExt = name + "." + XML_EXT;
        FileSystem filesystem = targetFolder.getFileSystem();
        final FileObject[] fileObject = new FileObject[1];
        FileSystem.AtomicAction fsAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fo;
                fileObject[0] = fo = targetFolder.createData(name, XMLWizardIterator.XML_EXT);
            }
        };
        filesystem.runAtomicAction(fsAction);
        StringBuffer sb = new StringBuffer();
        this.writeXMLComment(sb, nameExt, encoding);
        this.writeXMLFile(sb);
        FileLock lock = null;
        try {
            lock = fileObject[0].lock();
            OutputStream out = fileObject[0].getOutputStream(lock);
            out = new BufferedOutputStream(out, 999);
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            lock.releaseLock();
            lock = null;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        DataObject createdObject = DataObject.find((FileObject)fileObject[0]);
        GuiUtil.performDefaultAction(createdObject);
        set.add(createdObject);
        this.formatXML(fileObject[0]);
        return set;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.currentComponent();
        if (panel.getComponent() instanceof JComponent) {
            ((JComponent)panel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.current));
        }
        return panel;
    }

    private WizardDescriptor.Panel currentComponent() {
        switch (this.current) {
            case 0: {
                return this.getTargetPanel();
            }
            case 1: {
                return this.getDocumentPanel();
            }
            case 2: {
                switch (this.model.getType()) {
                    case 1: {
                        return this.getDTDPanel();
                    }
                    case 2: {
                        return this.getSchemaPanel();
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.getXMLContentPanel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        boolean none = this.model.getType() == 0;
        int length = 0;
        if (this.model.getType() == 2) {
            length = 3;
        }
        if (this.model.getType() == 0) {
            length = 1;
        } else if (this.model.getType() == 1) {
            length = 2;
        }
        return this.current < length;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public String name() {
        return NbBundle.getMessage(XMLWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.current + 1), (Object)this.current);
    }

    public void nextPanel() {
        ++this.current;
    }

    public void previousPanel() {
        --this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            Object bridge = this.listenersMap.remove(changeListener);
            if (bridge == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.removePropertyChangeListener((PropertyChangeListener)bridge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(final ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            PropertyChangeListener listenerBridge = new PropertyChangeListener(){
                final ChangeEvent EVENT;
                {
                    this.EVENT = new ChangeEvent(XMLWizardIterator.this);
                }

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    changeListener.stateChanged(this.EVENT);
                }
            };
            if (this.listenersMap.put(changeListener, listenerBridge) == null) {
                this.model.addPropertyChangeListener(listenerBridge);
            }
        }
    }

    private WizardDescriptor.Panel getDocumentPanel() {
        if (this.documentPanel == null) {
            this.documentPanel = new DocumentPanel();
            this.documentPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString(XMLWizardIterator.class, "MSG_unknown")};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.documentPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.documentPanel);
    }

    private WizardDescriptor.Panel getDTDPanel() {
        if (this.dtdPanel == null) {
            this.dtdPanel = new DTDPanel();
            this.dtdPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getDTDPanelName()};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.dtdPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.dtdPanel);
    }

    private WizardDescriptor.Panel getSchemaPanel() {
        if (this.schemaPanel == null) {
            this.schemaPanel = new SchemaPanel(this.templateWizard);
            this.schemaPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.schemaPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.schemaPanel);
    }

    private WizardDescriptor.Panel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = this.templateWizard.targetChooser();
            if (this.targetPanel.getComponent() instanceof JComponent) {
                JComponent panel = (JComponent)this.targetPanel.getComponent();
                this.targetSteps = panel.getClientProperty("WizardPanel_contentData");
                String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString(XMLWizardIterator.class, "MSG_unknown")};
                String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
                panel.putClientProperty("WizardPanel_contentData", newSteps);
            }
        }
        return this.targetPanel;
    }

    private String getTargetPanelName() {
        Component panel = this.getTargetPanel().getComponent();
        if (panel instanceof JComponent) {
            return ((JComponent)panel).getName();
        }
        return "";
    }

    private String getDocumentPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_doc_panel_name");
    }

    private String getDTDPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_dtd_panel_name");
    }

    private String getSchemaPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_schema_panel_name");
    }

    private static String[] createSteps(String[] before, String[] panelNames) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panelNames.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panelNames[i - before.length + diff];
        }
        return res;
    }

    private WizardDescriptor.Panel getXMLContentPanel() {
        if (this.xmlPanel == null) {
            this.xmlPanel = new XMLContentPanel();
            this.xmlPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.xmlPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.xmlPanel);
    }

    private String getXMLContentPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_xml_content_panel_name");
    }

    private void generateXMLBody(DocumentModel model, String root, StringBuffer writer) {
        String schemaFileName = model.getPrimarySchema();
        if (model.getPrimarySchema().startsWith("http")) {
            schemaFileName = this.retrieveURLSchema(model.getPrimarySchema());
        }
        XMLGeneratorVisitor visitor = new XMLGeneratorVisitor(schemaFileName, model.getXMLContentAttributes(), writer);
        visitor.generateXML(root);
    }

    private String retrieveURLSchema(String sourceURL) {
        try {
            Project prj = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject prjrtfo = prj.getProjectDirectory();
            File prjrt = FileUtil.toFile((FileObject)prjrtfo);
            Object privateCatalogURI = null;
            URI privateCacheURI = null;
            CacheDirectoryProvider cdp = (CacheDirectoryProvider)prj.getLookup().lookup(CacheDirectoryProvider.class);
            String cachestr = "private/cache/retriever";
            try {
                if (cdp != null && cdp.getCacheDirectory() != null) {
                    URI prjrturi = prjrt.toURI();
                    URI cpduri = FileUtil.toFile((FileObject)cdp.getCacheDirectory()).toURI();
                    String cachedirstr = Utilities.relativize((URI)prjrturi, (URI)cpduri);
                    cachestr = cachedirstr + "/" + "retriever";
                }
                privateCacheURI = new URI(cachestr);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (privateCacheURI == null) {
                return null;
            }
            URI cacheURI = prjrt.toURI().resolve(privateCacheURI);
            File saveFile = new File(cacheURI);
            if (!saveFile.isDirectory()) {
                saveFile.mkdirs();
            }
            RetrieverEngine instance = RetrieverEngine.getRetrieverEngine((File)saveFile, (boolean)false);
            RetrieveEntry rent = new RetrieveEntry(null, sourceURL, null, null, Utilities.DocumentTypesEnum.schema, true);
            instance.addResourceToRetrieve(rent);
            instance.setFileOverwrite(true);
            instance.start();
            String returnstr = saveFile.getPath() + sourceURL.substring(6, sourceURL.length());
            return returnstr;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void modifyRootElementAttrs(StringBuffer xmlBuffer) {
        Map<String, String> nsAttrs = this.model.getXMLContentAttributes().getNamespaceToPrefixMap();
        if (nsAttrs == null || nsAttrs.size() == 0) {
            return;
        }
        int firstOccur = xmlBuffer.indexOf("xmlns");
        int insertLoc = xmlBuffer.indexOf("xmlns", firstOccur + 1);
        StringBuffer sb = new StringBuffer();
        for (String ns : nsAttrs.keySet()) {
            String xmlnsString;
            String nsPrefix = nsAttrs.get(ns);
            if (nsPrefix == null || nsPrefix.trim().length() <= 0 || xmlBuffer.indexOf(xmlnsString = "xmlns:" + nsPrefix + "='" + ns + "'") != -1) continue;
            xmlBuffer.insert(insertLoc, xmlnsString + "\n   ");
        }
        xmlBuffer.insert(insertLoc, sb.toString());
    }

    private void writeXMLFile(StringBuffer writer) throws IOException {
        DataFolder folder = this.templateWizard.getTargetFolder();
        File pobj = FileUtil.toFile((FileObject)folder.getPrimaryFile());
        String root = this.model.getRoot();
        if (root == null) {
            root = "root";
        }
        String prefix = this.model.getPrefix();
        if (this.model.getType() == 1) {
            if (this.model.getPublicID() == null) {
                writer.append("<!DOCTYPE " + root + " SYSTEM '" + this.model.getSystemID() + "'>\n");
            } else {
                writer.append("<!DOCTYPE " + root + " PUBLIC '" + this.model.getPublicID() + "' '" + this.model.getSystemID() + "'>\n");
            }
            writer.append("<" + root + ">\n");
        } else if (this.model.getType() == 2) {
            String namespace = this.model.getNamespace();
            List nodes = this.model.getSchemaNodes();
            if (prefix == null || "".equals(prefix)) {
                writer.append("<" + root + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
            } else {
                writer.append("<" + prefix + ":" + root + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
            }
            HashMap<String, String> nsToPre = new HashMap<String, String>();
            if (nodes != null) {
                SchemaObject erdn;
                int i;
                for (i = 0; i < nodes.size(); ++i) {
                    erdn = (SchemaObject)nodes.get(i);
                    nsToPre.put(erdn.getNamespace(), erdn.getPrefix());
                    if (erdn.getPrefix() == null || "".equals(erdn.getPrefix())) {
                        writer.append("   xmlns='" + erdn.getNamespace() + "'\n");
                        continue;
                    }
                    writer.append("   xmlns:" + erdn.getPrefix() + "='" + erdn.getNamespace() + "'\n");
                }
                for (i = 0; i < nodes.size(); ++i) {
                    erdn = (SchemaObject)nodes.get(i);
                    String relativePath = null;
                    relativePath = erdn.toString().startsWith("http") ? erdn.toString() : Util.getRelativePath(new File(erdn.getSchemaFileName()), pobj);
                    if (i == 0) {
                        if (nodes.size() == 1) {
                            writer.append("   xsi:schemaLocation='" + erdn.getNamespace() + " " + relativePath + "'>\n");
                            continue;
                        }
                        writer.append("   xsi:schemaLocation='" + erdn.getNamespace() + " " + relativePath + "\n");
                        continue;
                    }
                    if (i == nodes.size() - 1) {
                        writer.append("   " + erdn.getNamespace() + " " + relativePath + "'>\n");
                        continue;
                    }
                    writer.append("   " + erdn.getNamespace() + " " + relativePath + "\n");
                }
            }
            this.model.getXMLContentAttributes().setNamespaceToPrefixMap(nsToPre);
            this.generateXMLBody(this.model, root, writer);
            this.modifyRootElementAttrs(writer);
        } else {
            writer.append("<" + root + ">\n");
        }
        if (prefix == null || "".equals(prefix)) {
            writer.append("\n");
            writer.append("</" + root + ">\n");
        } else {
            writer.append("\n");
            writer.append("</" + prefix + ":" + root + ">\n");
        }
    }

    private void writeXMLComment(StringBuffer writer, String filename, String encoding) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
        writer.append("\n");
        Date now = new Date();
        String currentDate = DateFormat.getDateInstance(1).format(now);
        String currentTime = DateFormat.getTimeInstance(3).format(now);
        String userName = System.getProperty("user.name");
        writer.append("<!--\n");
        writer.append("    Document   : " + filename + "\n");
        writer.append("    Created on : " + currentDate + ", " + currentTime + "\n");
        writer.append("    Author     : " + userName + "\n");
        writer.append("    Description:\n");
        writer.append("        Purpose of the document follows.\n");
        writer.append("-->\n");
        writer.append("\n");
    }

    private void formatXML(FileObject fobj) {
        try {
            DataObject dobj = DataObject.find((FileObject)fobj);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec == null) {
                return;
            }
            BaseDocument doc = (BaseDocument)ec.getDocument();
            XMLFormatUtil.reformat((BaseDocument)doc, (int)0, (int)doc.getLength());
            EditCookie cookie = (EditCookie)dobj.getCookie(EditCookie.class);
            if (cookie instanceof TextEditorSupport && cookie != null) {
                ((TextEditorSupport)cookie).saveDocument();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

