/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.openide.util.Exceptions;

public class WrappedTextView
extends View {
    private JTextComponent comp;
    private int charsPerLine = 80;
    private int fontDescent = 4;
    private static final Segment SEGMENT = new Segment();
    private int width = 0;
    private boolean changed = true;
    private int charWidth = 12;
    private int charHeight = 7;
    static final int[] ln = new int[3];
    private boolean aa = false;
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final Color arrowColor = new Color(80, 162, 80);
    private static Map hintsMap = null;
    float viewWidth = -1.0f;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    public WrappedTextView(Element elem, JTextComponent comp) {
        super(elem);
        this.comp = comp;
    }

    @Override
    public float getPreferredSpan(int axis) {
        OutputDocument doc = this.odoc();
        float result = 0.0f;
        if (doc != null) {
            this.updateWidth();
            switch (axis) {
                case 0: {
                    result = this.charsPerLine;
                    break;
                }
                case 1: {
                    result = doc.getLines().getLogicalLineCountIfWrappedAt(this.charsPerLine) * this.charHeight + this.fontDescent;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(axis));
                }
            }
        }
        return result;
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (this.viewWidth != width) {
            this.viewWidth = width;
            this.updateMetrics();
        }
    }

    void updateMetrics() {
        Font font = this.comp.getFont();
        FontMetrics fm = this.comp.getFontMetrics(font);
        this.charWidth = fm.charWidth('m');
        this.charHeight = fm.getHeight();
        this.fontDescent = fm.getMaxDescent();
        Graphics2D g2d = (Graphics2D)this.comp.getGraphics();
        if (g2d != null) {
            this.aa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        this.updateWidth();
    }

    private OutputDocument odoc() {
        Document doc = this.comp.getDocument();
        if (doc instanceof OutputDocument) {
            return (OutputDocument)doc;
        }
        return null;
    }

    private void updateWidth() {
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.comp.getParent();
            this.width = jv.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        if (this.width < 0) {
            this.width = 0;
        }
        this.charsPerLine = this.width / this.charWidth;
    }

    private static int margin() {
        return 9;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        ((Graphics2D)g).addRenderingHints(WrappedTextView.getHints());
        this.comp.getHighlighter().paint(g);
        OutputDocument doc = this.odoc();
        if (doc != null) {
            Rectangle clip = g.getClipBounds();
            clip.y = Math.max(0, clip.y - this.charHeight);
            clip.height += this.charHeight * 2;
            int lineCount = doc.getElementCount();
            if (lineCount == 0) {
                return;
            }
            WrappedTextView.ln[0] = clip.y / this.charHeight;
            Lines lines = doc.getLines();
            lines.toPhysicalLineIndex(ln, this.charsPerLine);
            int firstline = ln[0];
            g.setColor(this.comp.getForeground());
            Segment seg = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int selStart = this.comp.getSelectionStart();
            int selEnd = this.comp.getSelectionEnd();
            int y = clip.y - clip.y % this.charHeight + this.charHeight;
            int maxVisibleChars = (clip.height + this.charHeight - 1) / this.charHeight * this.charsPerLine;
            try {
                for (int i = firstline; i < lineCount; ++i) {
                    if (y > clip.y + clip.height) {
                        return;
                    }
                    int lineStart = doc.getLineStart(i);
                    int lineEnd = doc.getLineEnd(i);
                    int length = lineEnd - lineStart;
                    if (length == 0) {
                        y += this.charHeight;
                        continue;
                    }
                    LineInfo info = lines.getLineInfo(i);
                    int logicalLines = length <= this.charsPerLine ? 1 : (this.charsPerLine == 0 ? length : (length + this.charsPerLine - 1) / this.charsPerLine);
                    int currLogicalLine = i == firstline && logicalLines > 0 && ln[1] > 0 ? ln[1] : 0;
                    int logLineOffset = currLogicalLine * this.charsPerLine;
                    length = Math.min(maxVisibleChars, lineEnd - (lineStart += logLineOffset));
                    doc.getText(lineStart, length, seg);
                    int charpos = 0;
                    int arrowDrawn = currLogicalLine - 1;
                    int x = 0;
                    int remainCharsOnLogicalLine = this.charsPerLine;
                    for (LineInfo.Segment ls : info.getLineSegments()) {
                        if (ls.getEnd() < logLineOffset) continue;
                        g.setColor(ls.getColor());
                        while (charpos < ls.getEnd() - logLineOffset && currLogicalLine < logicalLines) {
                            int lenToDraw = Math.min(remainCharsOnLogicalLine, ls.getEnd() - logLineOffset - charpos);
                            if (lenToDraw > 0) {
                                if (currLogicalLine != logicalLines - 1 && arrowDrawn != currLogicalLine) {
                                    arrowDrawn = currLogicalLine;
                                    this.drawArrow(g, y, currLogicalLine == logicalLines - 2);
                                }
                                this.drawText(seg, g, x, y, lineStart, charpos, selStart, lenToDraw, selEnd);
                                if (ls.getListener() != null) {
                                    this.underline(g, seg, charpos, lenToDraw, x, y);
                                }
                            }
                            charpos += lenToDraw;
                            x += lenToDraw * this.charWidth;
                            if ((remainCharsOnLogicalLine -= lenToDraw) != 0) continue;
                            remainCharsOnLogicalLine = this.charsPerLine;
                            ++currLogicalLine;
                            x = 0;
                            if ((y += this.charHeight) <= clip.y + clip.height) continue;
                            return;
                        }
                    }
                    if (charpos % this.charsPerLine == 0) continue;
                    y += this.charHeight;
                }
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void drawText(Segment seg, Graphics g, int x, int y, int lineStart, int charpos, int selStart, int lenToDraw, int selEnd) {
        int b;
        int realPos;
        int a;
        if (selStart != selEnd && (a = Math.max(selStart, realPos = lineStart + charpos)) < (b = Math.min(selEnd, realPos + lenToDraw))) {
            int start = x + WrappedTextView.margin() + (a - realPos) * this.charWidth;
            int len = (b - a) * this.charWidth;
            Color c = g.getColor();
            g.setColor(this.comp.getSelectionColor());
            g.fillRect(start, y + this.fontDescent - this.charHeight, len, this.charHeight);
            g.setColor(c);
        }
        g.drawChars(seg.array, charpos, lenToDraw, WrappedTextView.margin() + x, y);
    }

    private void underline(Graphics g, Segment seg, int charpos, int lenToDraw, int x, int y) {
        int underlineStart = WrappedTextView.margin() + x;
        FontMetrics fm = g.getFontMetrics();
        int underlineEnd = underlineStart + fm.charsWidth(seg.array, charpos, lenToDraw);
        int underlineShift = fm.getDescent() - 1;
        g.drawLine(underlineStart, y + underlineShift, underlineEnd, y + underlineShift);
    }

    private void drawArrow(Graphics g, int y, boolean drawHead) {
        int rpos;
        Color c = g.getColor();
        g.setColor(WrappedTextView.arrowColor());
        int w = this.width + 15;
        y += 2;
        int n = rpos = this.aa ? 8 : 4;
        if (this.aa) {
            g.drawArc(w - rpos, y - this.charHeight / 2, rpos + 1, this.charHeight, 265, 185);
            ++w;
        } else {
            g.drawLine(w - rpos, y - this.charHeight / 2, w, y - this.charHeight / 2);
            g.drawLine(w, y - this.charHeight / 2 + 1, w, y + this.charHeight / 2 - 1);
            g.drawLine(w - rpos, y + this.charHeight / 2, w, y + this.charHeight / 2);
        }
        if (drawHead) {
            rpos = this.aa ? 7 : 8;
            int[] xpoints = new int[]{w - rpos, w - rpos + 5, w - rpos + 5};
            int[] ypoints = new int[]{y + this.charHeight / 2, y + this.charHeight / 2 - 5, y + this.charHeight / 2 + 5};
            g.fillPolygon(xpoints, ypoints, 3);
        }
        g.setColor(WrappedTextView.arrowColor());
        g.drawLine(1, y - this.charHeight / 2, 5, y - this.charHeight / 2);
        g.drawLine(1, y - this.charHeight / 2, 1, y + this.charHeight / 2);
        g.drawLine(1, y + this.charHeight / 2, 5, y + this.charHeight / 2);
        g.setColor(c);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle result = new Rectangle();
        result.setBounds(0, 0, this.charWidth, this.charHeight);
        OutputDocument od = this.odoc();
        if (od != null) {
            int line = Math.max(0, od.getElementIndex(pos));
            int start = od.getLineStart(line);
            int column = pos - start;
            int row = od.getLines().getLogicalLineCountAbove(line, this.charsPerLine);
            if (column > this.charsPerLine && this.charsPerLine != 0) {
                row += column / this.charsPerLine;
                column %= this.charsPerLine;
            }
            result.y = row * this.charHeight + this.fontDescent;
            result.x = WrappedTextView.margin() + column * this.charWidth;
        }
        return result;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        OutputDocument od = this.odoc();
        if (od != null) {
            int ix = Math.max((int)x - WrappedTextView.margin(), 0);
            int iy = (int)y - this.fontDescent;
            WrappedTextView.ln[0] = iy / this.charHeight;
            od.getLines().toPhysicalLineIndex(ln, this.charsPerLine);
            int logicalLine = ln[0];
            int wraps = ln[2] - 1;
            int totalLines = od.getElementCount();
            if (totalLines == 0) {
                return 0;
            }
            if (logicalLine >= totalLines) {
                return od.getLength();
            }
            int lineStart = od.getLineStart(logicalLine);
            int column = ix / this.charWidth;
            int lineEnd = od.getLineEnd(logicalLine);
            if (column > lineEnd) {
                column = lineEnd;
            }
            int result = wraps > 0 ? Math.min(lineEnd, lineStart + ln[1] * this.charsPerLine + column) : Math.min(lineStart + column, lineEnd);
            result = Math.min(od.getLength(), result);
            return result;
        }
        return 0;
    }
}

