/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.netbeans.modules.reglib.StatusDocument;

public class StatusData {
    public static final String STATUS_UNKNOWN = "unknown";
    public static final String STATUS_REGISTERED = "registered";
    public static final String STATUS_LATER = "later";
    public static final String STATUS_NEVER = "never";
    public static final int DEFAULT_DELAY = 7;
    private String status;
    private Date timestamp;
    private int delay;

    public StatusData(String status, int delay) {
        this.status = status;
        this.timestamp = new Date();
        this.delay = delay;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public static StatusData loadFromXML(InputStream in) throws IOException {
        return StatusDocument.load(in);
    }

    public void storeToXML(OutputStream os) throws IOException {
        StatusDocument.store(os, this);
    }

    public byte[] toXML() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            return "Error creating the return string.";
        }
    }
}

