/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import org.h2.message.Message;

public class ObjectUtils {
    private static final int MAX_JAVA_LOOP_COPY = 100;

    private ObjectUtils() {
    }

    public static Integer getInteger(int n) {
        return n;
    }

    public static Character getCharacter(char c) {
        return Character.valueOf(c);
    }

    public static Long getLong(long l) {
        return l;
    }

    public static Short getShort(short s) {
        return s;
    }

    public static Byte getByte(byte by) {
        return by;
    }

    public static Float getFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double getDouble(double d) {
        return d;
    }

    public static byte[] serialize(Object object) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90026, new String[]{throwable.toString()}, throwable);
        }
    }

    public static Object deserialize(byte[] byArray) throws SQLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90027, new String[]{throwable.toString()}, throwable);
        }
    }

    public static void arrayCopy(Object[] objectArray, Object[] objectArray2, int n) {
        if (n > 100) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = objectArray[i];
            }
        }
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

