/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.FunctionImpl;

public class CallImpl
implements Call {
    private final Function owner;
    private final CsmReference reference;
    private final Function function;
    private final boolean nameOrder;

    public CallImpl(CsmFunction owner, CsmReference reference, CsmFunction function, boolean nameOrder) {
        this.owner = new FunctionImpl(owner);
        this.reference = reference;
        this.function = new FunctionImpl(function);
        this.nameOrder = nameOrder;
    }

    public Object getReferencedCall() {
        return this.reference;
    }

    public void open() {
        CsmUtilities.openSource((CsmObject)this.reference);
    }

    public Function getCallee() {
        return this.function;
    }

    public Function getCaller() {
        return this.owner;
    }

    public int compareTo(Call o) {
        if (this.nameOrder) {
            return this.getCaller().getName().compareTo(o.getCaller().getName());
        }
        int diff = this.reference.getStartOffset() - ((CallImpl)o).reference.getStartOffset();
        if (diff == 0) {
            return this.getCallee().getName().compareTo(o.getCallee().getName());
        }
        return diff;
    }

    public String toString() {
        if (this.nameOrder) {
            return this.getCallee().getName() + "<-" + this.getCaller().getName();
        }
        return this.getCaller().getName() + "->" + this.getCallee().getName();
    }

    public String getHtmlDisplayName() {
        return ((Object)CsmReferenceSupport.getContextLineHtml((CsmReference)this.reference, (boolean)true)).toString();
    }

    public String getDescription() {
        CharSequence ret = CsmReferenceSupport.getContextLine((CsmReference)this.reference);
        if (ret != null) {
            return ((Object)ret).toString();
        }
        return null;
    }
}

