/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CodeFoldingSideBar
extends JComponent
implements Accessible {
    private static final Logger LOG = Logger.getLogger(CodeFoldingSideBar.class.getName());
    protected Color backColor;
    protected Color foreColor;
    protected Font font;
    protected JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            CodeFoldingSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeFoldingSideBar.this.updatePreferredSize();
                    CodeFoldingSideBar.this.repaint();
                }
            });
        }
    };
    private final Listener listener = new Listener();
    private boolean enabled = false;
    protected List<Mark> visibleMarks = new ArrayList<Mark>();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key;
            String string = key = evt == null ? null : evt.getKey();
            if (key == null || "code-folding-enable".equals(key)) {
                CodeFoldingSideBar.this.updateColors();
                boolean newEnabled = CodeFoldingSideBar.this.prefs.getBoolean("code-folding-enable", false);
                if (CodeFoldingSideBar.this.enabled != newEnabled) {
                    CodeFoldingSideBar.this.enabled = newEnabled;
                    CodeFoldingSideBar.this.updatePreferredSize();
                }
            }
            SettingsConversions.callSettingsChange(CodeFoldingSideBar.this);
        }
    };

    public CodeFoldingSideBar() {
        this.component = null;
        this.prefs = null;
        throw new IllegalStateException("Do not use this constructor!");
    }

    public CodeFoldingSideBar(JTextComponent component) {
        this.component = component;
        this.addMouseListener(this.listener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)component);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this.listener, (Object)foldHierarchy));
        Document doc = this.getDocument();
        doc.addDocumentListener(WeakListeners.document((DocumentListener)this.listener, (Object)doc));
        this.setOpaque(true);
        this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)component)).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        this.prefsListener.preferenceChange(null);
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoring().getFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void updateColors() {
        Coloring c = this.getColoring();
        this.backColor = c.getBackColor();
        this.foreColor = c.getForeColor();
        this.font = c.getFont();
    }

    protected Color getBackColor() {
        if (this.backColor == null) {
            this.updateColors();
        }
        return this.backColor;
    }

    protected Color getForeColor() {
        if (this.foreColor == null) {
            this.updateColors();
        }
        return this.foreColor;
    }

    protected Font getColoringFont() {
        if (this.font == null) {
            this.updateColors();
        }
        return this.font;
    }

    @Override
    public void update(Graphics g) {
    }

    protected void collectPaintInfos(View rootView, Fold fold, Map<Integer, PaintInfo> map, int level, int startIndex, int endIndex) throws BadLocationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends PaintInfo> getPaintInfo(Rectangle clip) throws BadLocationException {
        TextUI textUI = this.component.getUI();
        if (!(textUI instanceof BaseTextUI)) {
            return Collections.emptyList();
        }
        BaseTextUI baseTextUI = (BaseTextUI)textUI;
        BaseDocument bdoc = Utilities.getDocument(this.component);
        if (bdoc == null) {
            return Collections.emptyList();
        }
        bdoc.readLock();
        try {
            FoldHierarchy hierarchy;
            block15: {
                TreeMap<Integer, PaintInfo> map;
                block16: {
                    List<PaintInfo> list;
                    int startPos = baseTextUI.getPosFromY(clip.y);
                    int endPos = baseTextUI.viewToModel(this.component, 16383, clip.y + clip.height);
                    startPos = Utilities.getRowStart(bdoc, startPos);
                    endPos = Utilities.getRowEnd(bdoc, endPos);
                    hierarchy = FoldHierarchy.get((JTextComponent)this.component);
                    hierarchy.lock();
                    try {
                        Fold fold;
                        int i;
                        View rootView = Utilities.getDocumentView(this.component);
                        if (rootView == null) break block15;
                        Object[] arr = CodeFoldingSideBar.getFoldList(hierarchy.getRootFold(), startPos, endPos);
                        List foldList = (List)arr[0];
                        int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
                        map = new TreeMap<Integer, PaintInfo>();
                        for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0 && this.traverseBackwards(fold = (Fold)foldList.get(i), bdoc, baseTextUI, startPos, endPos, 0, map); --i) {
                        }
                        for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size() && this.traverseForward(fold = (Fold)foldList.get(i), bdoc, baseTextUI, startPos, endPos, 0, map); ++i) {
                        }
                        if (map.size() != 0 || foldList.size() <= 0) break block16;
                        assert (foldList.size() == 1);
                        list = Collections.singletonList(new PaintInfo(2, 0, clip.y, clip.height));
                    }
                    catch (Throwable throwable) {
                        hierarchy.unlock();
                        throw throwable;
                    }
                    hierarchy.unlock();
                    return list;
                }
                ArrayList arrayList = new ArrayList(map.values());
                hierarchy.unlock();
                return arrayList;
            }
            List list = Collections.emptyList();
            hierarchy.unlock();
            return list;
        }
        finally {
            bdoc.readUnlock();
        }
    }

    private boolean traverseForward(Fold f, BaseDocument doc, BaseTextUI btui, int lowerBoundary, int upperBoundary, int level, Map<Integer, PaintInfo> infos) throws BadLocationException {
        if (f.getStartOffset() > upperBoundary) {
            return false;
        }
        int lineStartOffset1 = Utilities.getRowStart(doc, f.getStartOffset());
        int lineStartOffset2 = Utilities.getRowStart(doc, f.getEndOffset());
        int y1 = btui.getYFromPos(lineStartOffset1);
        int h = btui.getEditorUI().getLineHeight();
        if (lineStartOffset1 == lineStartOffset2) {
            infos.put(lineStartOffset1, new PaintInfo(4, level, y1, h, f.isCollapsed()));
        } else {
            infos.put(lineStartOffset1, new PaintInfo(1, level, y1, h, f.isCollapsed()));
            if (!f.isCollapsed() && f.getEndOffset() <= upperBoundary) {
                int y2 = btui.getYFromPos(lineStartOffset2);
                infos.put(lineStartOffset2, new PaintInfo(3, level, y2, h));
            }
        }
        if (!f.isCollapsed()) {
            Fold fold;
            int i;
            Object[] arr = CodeFoldingSideBar.getFoldList(f, lowerBoundary, upperBoundary);
            List foldList = (List)arr[0];
            int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
            for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0 && this.traverseBackwards(fold = (Fold)foldList.get(i), doc, btui, lowerBoundary, upperBoundary, level + 1, infos); --i) {
            }
            for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size(); ++i) {
                fold = (Fold)foldList.get(i);
                if (this.traverseForward(fold, doc, btui, lowerBoundary, upperBoundary, level + 1, infos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean traverseBackwards(Fold f, BaseDocument doc, BaseTextUI btui, int lowerBoundary, int upperBoundary, int level, Map<Integer, PaintInfo> infos) throws BadLocationException {
        int y1;
        if (f.getEndOffset() < lowerBoundary) {
            return false;
        }
        int lineStartOffset1 = Utilities.getRowStart(doc, f.getStartOffset());
        int lineStartOffset2 = Utilities.getRowStart(doc, f.getEndOffset());
        int h = btui.getEditorUI().getLineHeight();
        if (lineStartOffset1 == lineStartOffset2) {
            y1 = btui.getYFromPos(lineStartOffset1);
            infos.put(lineStartOffset1, new PaintInfo(4, level, y1, h, f.isCollapsed()));
        } else {
            if (f.getStartOffset() >= upperBoundary) {
                y1 = btui.getYFromPos(lineStartOffset1);
                infos.put(lineStartOffset1, new PaintInfo(1, level, y1, h, f.isCollapsed()));
            }
            if (!f.isCollapsed() && f.getEndOffset() <= upperBoundary) {
                int y2 = btui.getYFromPos(lineStartOffset2);
                infos.put(lineStartOffset2, new PaintInfo(3, level, y2, h));
            }
        }
        if (!f.isCollapsed()) {
            Fold fold;
            int i;
            Object[] arr = CodeFoldingSideBar.getFoldList(f, lowerBoundary, upperBoundary);
            List foldList = (List)arr[0];
            int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
            for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0; --i) {
                fold = (Fold)foldList.get(i);
                if (this.traverseBackwards(fold, doc, btui, lowerBoundary, upperBoundary, level + 1, infos)) continue;
                return false;
            }
            for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size() && this.traverseForward(fold = (Fold)foldList.get(i), doc, btui, lowerBoundary, upperBoundary, level + 1, infos); ++i) {
            }
        }
        return true;
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy hierarchy, int rowStart, int rowEnd) {
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)rowStart);
        while (fold != null && fold.getStartOffset() < rowEnd) {
            Fold nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (nextFold == fold) {
                return fold;
            }
            if (nextFold != null && nextFold.getStartOffset() < rowEnd) {
                fold = nextFold;
                continue;
            }
            return fold;
        }
        return fold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Mark mark) {
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        Element rootElem = textUI.getRootView(this.component).getElement();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        try {
            int startViewIndex = rootView.getViewIndex(textUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view = rootView.getView(startViewIndex);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument adoc = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            adoc.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int viewStartOffset = view.getStartOffset();
                    int rowStart = javax.swing.text.Utilities.getRowStart(this.component, viewStartOffset);
                    int rowEnd = javax.swing.text.Utilities.getRowEnd(this.component, viewStartOffset);
                    Fold clickedFold = this.getLastLineFold(foldHierarchy, rowStart, rowEnd);
                    if (clickedFold != null && clickedFold.getStartOffset() < view.getEndOffset()) {
                        foldHierarchy.toggle(clickedFold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                adoc.readUnlock();
            }
        }
        catch (BadLocationException ble) {
            LOG.log(Level.WARNING, null, ble);
        }
    }

    protected int getMarkSize(Graphics g) {
        FontMetrics fm;
        if (g != null && (fm = g.getFontMetrics(this.getColoring().getFont())) != null) {
            int ret = fm.getAscent() - fm.getDescent();
            return ret - ret % 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (!this.enabled) {
            return;
        }
        Rectangle clip = this.getVisibleRect();
        this.visibleMarks.clear();
        Coloring coloring = this.getColoring();
        g.setColor(coloring.getBackColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(coloring.getForeColor());
        AbstractDocument adoc = (AbstractDocument)this.component.getDocument();
        adoc.readLock();
        try {
            List<? extends PaintInfo> ps = this.getPaintInfo(clip);
            Font defFont = coloring.getFont();
            int markSize = this.getMarkSize(g);
            int halfMarkSize = markSize / 2;
            int markX = (defFont.getSize() - markSize) / 2;
            int plusGap = (int)Math.round((double)markSize / 3.8);
            int lineX = markX + halfMarkSize;
            PaintInfo previousInfo = null;
            for (PaintInfo paintInfo : ps) {
                boolean isFolded = paintInfo.isCollapsed();
                int y = paintInfo.getPaintY();
                int height = paintInfo.getPaintHeight();
                int markY = y + g.getFontMetrics(defFont).getDescent();
                int paintOperation = paintInfo.getPaintOperation();
                if (previousInfo == null) {
                    if (paintInfo.getInnerLevel() > 0 || paintOperation == 3) {
                        g.drawLine(lineX, clip.y, lineX, y);
                    }
                } else if (previousInfo.getInnerLevel() > 0 || previousInfo.getPaintOperation() == 1 && !previousInfo.isCollapsed()) {
                    g.drawLine(lineX, previousInfo.getPaintY() + previousInfo.getPaintHeight(), lineX, y);
                }
                if (paintOperation == 1 || paintOperation == 4) {
                    g.drawRect(markX, markY, markSize, markSize);
                    g.drawLine(plusGap + markX, markY + halfMarkSize, markSize + markX - plusGap, markY + halfMarkSize);
                    if (isFolded) {
                        g.drawLine(lineX, markY + plusGap, lineX, markY + markSize - plusGap);
                    } else if (paintOperation != 4) {
                        g.drawLine(lineX, markY + markSize, lineX, y + height);
                    }
                    if (paintInfo.getInnerLevel() > 0) {
                        g.drawLine(lineX, y, lineX, markY);
                        if (paintOperation != 4) {
                            g.drawLine(lineX, markY + markSize, lineX, y + height);
                        }
                    }
                    this.visibleMarks.add(new Mark(markX, markY, markSize, isFolded));
                } else if (paintOperation == 2) {
                    g.drawLine(lineX, y, lineX, y + height);
                } else if (paintOperation == 3) {
                    g.drawLine(lineX, y, lineX, y + height / 2);
                    g.drawLine(lineX, y + height / 2, lineX + halfMarkSize, y + height / 2);
                    if (paintInfo.getInnerLevel() > 0) {
                        g.drawLine(lineX, y + height / 2, lineX, y + height);
                    }
                }
                previousInfo = paintInfo;
            }
            if (previousInfo != null && (previousInfo.getInnerLevel() > 0 || previousInfo.getPaintOperation() == 1 && !previousInfo.isCollapsed())) {
                g.drawLine(lineX, previousInfo.getPaintY() + previousInfo.getPaintHeight(), lineX, clip.y + clip.height);
            }
        }
        catch (BadLocationException ble) {
            LOG.log(Level.WARNING, null, ble);
        }
        finally {
            adoc.readUnlock();
        }
    }

    private static Object[] getFoldList(Fold parentFold, int start, int end) {
        Fold f;
        ArrayList<Fold> ret = new ArrayList<Fold>();
        int foldCount = parentFold.getFoldCount();
        int idxOfFirstFoldStartingInside = -1;
        for (int index = FoldUtilities.findFoldEndIndex((Fold)parentFold, (int)start); index < foldCount && (f = parentFold.getFold(index)).getStartOffset() <= end; ++index) {
            ret.add(f);
            if (idxOfFirstFoldStartingInside != -1 || f.getStartOffset() < start) continue;
            idxOfFirstFoldStartingInside = ret.size() - 1;
        }
        return new Object[]{ret, idxOfFirstFoldStartingInside != -1 ? idxOfFirstFoldStartingInside : ret.size()};
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            FontColorSettings fcs;
            AttributeSet attr;
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            attr = (attr = (fcs = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next()).getFontColors("code-folding-bar")) == null ? fcs.getFontColors("default") : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attr, fcs.getFontColors("default")});
            this.attribs = attr;
        }
        return Coloring.fromAttributeSet(this.attribs);
    }

    private final class Listener
    extends MouseAdapter
    implements FoldHierarchyListener,
    DocumentListener {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            this.refresh();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (!(evt instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if (bevt.getLFCount() > 0) {
                this.refresh();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (!(evt instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if (bevt.getLFCount() > 0) {
                this.refresh();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark != null) {
                e.consume();
                CodeFoldingSideBar.this.performAction(mark);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.consume();
        }

        private Mark getClickedMark(MouseEvent e) {
            if (e == null || !SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            int x = e.getX();
            int y = e.getY();
            for (Mark mark : CodeFoldingSideBar.this.visibleMarks) {
                if (x < mark.x || x > mark.x + mark.size || y < mark.y || y > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        private void refresh() {
            CodeFoldingSideBar.this.repaint();
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int x, int y, int size, boolean isFolded) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.isFolded = isFolded;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight, boolean isCollapsed) {
            this.paintOperation = paintOperation;
            this.innerLevel = innerLevel;
            this.paintY = paintY;
            this.paintHeight = paintHeight;
            this.isCollapsed = isCollapsed;
        }

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight) {
            this(paintOperation, innerLevel, paintY, paintHeight, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int paintOperation) {
            this.paintOperation = paintOperation;
        }

        public void setInnerLevel(int innerLevel) {
            this.innerLevel = innerLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.paintOperation == 0) {
                sb.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                sb.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                sb.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                sb.append("PAINT_END_MARK\n");
            }
            sb.append("level:" + this.innerLevel);
            sb.append("\ncollapsedFold:" + this.isCollapsed);
            return sb.toString();
        }
    }
}

