/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class UndoAction
extends CallableSystemAction
implements PropertyChangeListener {
    private UndoManager undoManager;

    public UndoAction() {
        this.putValue("Name", UndoAction.getString("LBL_Undo"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.undoManager = UndoManager.getDefault();
        this.undoManager.addPropertyChangeListener(this);
        this.updateState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.updateState();
    }

    private void updateState() {
        String desc = this.undoManager.getUndoDescription();
        String name = UndoAction.getString("LBL_Undo");
        if (desc != null) {
            name = name + " [" + desc + "]";
        }
        final String n = name;
        final boolean b = this.undoManager.isUndoAvailable();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UndoAction.this.setEnabled(b);
                UndoAction.this.putValue("Name", n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(UndoAction.class, (String)key);
    }

    public void performAction() {
        this.undoManager.undo();
        this.undoManager.saveAll();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    protected boolean asynchronous() {
        return true;
    }
}

