/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.api.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.spi.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class SourceForBinaryQuery {
    private static final Logger LOG = Logger.getLogger(SourceForBinaryQuery.class.getName());
    private static final Lookup.Result<? extends SourceForBinaryQueryImplementation> implementations = Lookup.getDefault().lookupResult(SourceForBinaryQueryImplementation.class);
    private static final Result EMPTY_RESULT = new EmptyResult();

    private SourceForBinaryQuery() {
    }

    public static Result findSourceRoots(URL binaryRoot) {
        if (FileUtil.isArchiveFile((URL)binaryRoot)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + binaryRoot);
        }
        if (!binaryRoot.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("Folder URL must end with '/'. Was: " + binaryRoot);
        }
        for (SourceForBinaryQueryImplementation impl : implementations.allInstances()) {
            Result result = impl.findSourceRoots(binaryRoot);
            if (result == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findSourceRoots({0}) -> {1} from {2}", new Object[]{binaryRoot, Arrays.asList(result.getRoots()), impl});
            }
            return result;
        }
        LOG.log(Level.FINE, "findSourceRoots({0}) -> nil", binaryRoot);
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final FileObject[] NO_ROOTS = new FileObject[0];

        EmptyResult() {
        }

        @Override
        public FileObject[] getRoots() {
            return NO_ROOTS;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }

    public static interface Result {
        public FileObject[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

