/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.feedreader;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.feedreader.FeedReaderWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FeedReaderWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public static FeedReaderWizardIterator createIterator() {
        return new FeedReaderWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new FeedReaderWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)FeedReaderWizardPanel.class, (String)"LBL_Step1")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        InputStream is = template.getInputStream();
        try {
            FileUtil.extractJar((FileObject)dir, (InputStream)is);
        }
        finally {
            is.close();
        }
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

