/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.navigation.JavaMembers;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class InspectMembersAtCaretAction
extends BaseAction {
    private static final RequestProcessor RP = new RequestProcessor(InspectMembersAtCaretAction.class.getName(), 1);
    private static final String INSPECT_MEMBERS_AT_CARET = "inspect-members-at-caret";
    private static final String INSPECT_MEMBERS_AT_CARET_POPUP = "inspect-members-at-caret-popup";

    public InspectMembersAtCaretAction() {
        super(NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_MEMBERS_AT_CARET), 0);
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("trimmed-text", this.getValue("Name"));
        this.putValue("PopupMenuText", NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_MEMBERS_AT_CARET_POPUP));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public boolean isEnabled() {
        if (EditorRegistry.lastFocusedComponent() == null || !EditorRegistry.lastFocusedComponent().isShowing()) {
            return false;
        }
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final Component component = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        final Cursor cursor = component.getCursor();
        Cursor cursor2 = Utilities.createProgressCursor((Component)component);
        if (cursor2 != null) {
            component.setCursor(cursor2);
        }
        component.setVisible(true);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws IOException {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Document document = compilationController.getDocument();
                            if (document != null) {
                                int n = jTextComponent.getCaret().getDot();
                                TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                                Element element = compilationController.getTrees().getElement(treePath);
                                FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                                if (fileObject != null) {
                                    if (element instanceof TypeElement) {
                                        InspectMembersAtCaretAction.this.show(fileObject, new Element[]{element});
                                    } else if (element instanceof VariableElement) {
                                        TypeMirror typeMirror = ((VariableElement)element).asType();
                                        if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                            InspectMembersAtCaretAction.this.show(fileObject, new Element[]{element});
                                        }
                                    } else if (element instanceof ExecutableElement) {
                                        if (element.getKind() == ElementKind.METHOD) {
                                            TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                                            if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                                InspectMembersAtCaretAction.this.show(fileObject, new Element[]{element});
                                            }
                                        } else if (element.getKind() == ElementKind.CONSTRUCTOR && (element = element.getEnclosingElement()) != null) {
                                            InspectMembersAtCaretAction.this.show(fileObject, new Element[]{element});
                                        }
                                    }
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    try {
                        Logger.getLogger(InspectMembersAtCaretAction.class.getName()).log(Level.WARNING, iOException.getMessage(), iOException);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                component.setVisible(false);
                                component.setCursor(cursor);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void show(final FileObject fileObject, Element[] elementArray) {
        final ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>(elementArray.length);
        for (Element element : elementArray) {
            arrayList.add(ElementHandle.create((Element)element));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaMembers.show(fileObject, arrayList.toArray(new ElementHandle[arrayList.size()]));
            }
        });
    }
}

