/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;

public class StackTraceSnapshotBuilder {
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private static final boolean COLLECT_TWO_TIMESTAMPS = true;
    private static final List<MethodInfo> knownBLockingMethods = Arrays.asList(new MethodInfo("java.net.PlainSocketImpl", "socketAccept[native]"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop[native]"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit[native]"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents[native]"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop[native]"), new MethodInfo("java.lang.Object", "wait[native]"), new MethodInfo("java.lang.Thread", "sleep[native]"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0[native]"));
    private InstrumentationFilter filter;
    final List<Long> threadIds = new ArrayList<Long>();
    final List<String> threadNames = new ArrayList<String>();
    final List<byte[]> threadCompactData = new ArrayList<byte[]>();
    final List<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
    final MethodInfoMapper mapper = new MethodInfoMapper(){

        @Override
        public String getInstrMethodClass(int methodId) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)methodId).className;
        }

        @Override
        public String getInstrMethodName(int methodId) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)methodId).methodName;
        }

        @Override
        public String getInstrMethodSignature(int methodId) {
            return "";
        }

        @Override
        public int getMaxMethodId() {
            return StackTraceSnapshotBuilder.this.methodInfos.size();
        }

        @Override
        public int getMinMethodId() {
            return 0;
        }
    };
    final CPUCallGraphBuilder ccgb;
    final Object lock = new Object();
    final Object stampLock = new Object();
    long currentDumpTimeStamp = -1L;
    final AtomicReference<Map<Long, SampledThreadInfo>> lastStackTrace = new AtomicReference<Map>(Collections.EMPTY_MAP);
    int stackTraceCount = 0;
    final Set<String> ignoredThreadNames = new HashSet<String>();
    final Map<Long, Long> threadtimes = new HashMap<Long, Long>();

    public StackTraceSnapshotBuilder() {
        this(1, null);
    }

    public StackTraceSnapshotBuilder(int batchSize, InstrumentationFilter f) {
        this.filter = f;
        this.setDefaultTiming();
        this.ccgb = new StackTraceCallGraphBuilder(this.mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIgnoredThreads(Set<String> ignoredThreadNames) {
        Object object = this.lock;
        synchronized (object) {
            this.ignoredThreadNames.clear();
            this.ignoredThreadNames.addAll(ignoredThreadNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStacktrace(ThreadInfo[] threads, long dumpTimeStamp) throws IllegalStateException {
        long timediff;
        Object object = this.stampLock;
        synchronized (object) {
            if (dumpTimeStamp <= this.currentDumpTimeStamp) {
                return;
            }
            timediff = dumpTimeStamp - this.currentDumpTimeStamp;
            this.currentDumpTimeStamp = dumpTimeStamp;
        }
        object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> tinfoMap = new HashMap<Long, SampledThreadInfo>();
            for (ThreadInfo tinfo : threads) {
                if (tinfo == null) continue;
                tinfoMap.put(tinfo.getThreadId(), new SampledThreadInfo(tinfo, this.filter));
            }
            for (SampledThreadInfo tinfo : tinfoMap.values()) {
                String tname = tinfo.getThreadName();
                if (this.ignoredThreadNames.contains(tname)) continue;
                long threadId = tinfo.getThreadId();
                if (!this.threadIds.contains(threadId)) {
                    this.threadIds.add(threadId);
                    this.threadNames.add(tname);
                    this.ccgb.newThread((int)threadId, tname, "<none>");
                    this.threadtimes.put(threadId, dumpTimeStamp);
                }
                StackTraceElement[] newElements = tinfo.getStackTrace();
                Thread.State newState = tinfo.getThreadState();
                SampledThreadInfo oldTinfo = this.lastStackTrace.get().get(threadId);
                StackTraceElement[] oldElements = NO_STACK_TRACE;
                Thread.State oldState = Thread.State.NEW;
                if (oldTinfo != null) {
                    oldElements = oldTinfo.getStackTrace();
                    oldState = oldTinfo.getThreadState();
                }
                this.processDiffs((int)threadId, oldElements, newElements, dumpTimeStamp, timediff, oldState, newState);
            }
            for (SampledThreadInfo oldTinfo : this.lastStackTrace.get().values()) {
                if (this.ignoredThreadNames.contains(oldTinfo.getThreadName()) || tinfoMap.containsKey(oldTinfo.getThreadId())) continue;
                Thread.State oldState = oldTinfo.getThreadState();
                Thread.State newState = Thread.State.TERMINATED;
                this.processDiffs((int)oldTinfo.getThreadId(), oldTinfo.getStackTrace(), NO_STACK_TRACE, dumpTimeStamp, timediff, oldState, newState);
            }
            this.lastStackTrace.set(tinfoMap);
            ++this.stackTraceCount;
        }
    }

    private void processDiffs(int threadId, StackTraceElement[] oldElements, StackTraceElement[] newElements, long timestamp, long timediff, Thread.State oldState, Thread.State newState) throws IllegalStateException {
        if (newState == Thread.State.NEW) {
            throw new IllegalStateException("Invalid thread state " + Thread.State.NEW.name() + " for taking a stack trace");
        }
        if (oldState == Thread.State.TERMINATED && newState != Thread.State.TERMINATED) {
            throw new IllegalStateException("Thread has already been set to " + Thread.State.TERMINATED.name() + " - stack trace can not be taken");
        }
        long threadtime = this.threadtimes.get(threadId);
        if (oldState == Thread.State.RUNNABLE) {
            this.threadtimes.put(Long.valueOf(threadId), threadtime += timediff);
        }
        this.processDiffs(threadId, oldElements, newElements, timestamp, threadtime);
    }

    private void processDiffs(int threadId, StackTraceElement[] oldElements, StackTraceElement[] newElements, long timestamp, long threadtimestamp) throws IllegalStateException {
        if (oldElements.length == 0 && newElements.length == 0) {
            return;
        }
        int newMax = newElements.length - 1;
        int oldMax = oldElements.length - 1;
        int globalMax = Math.max(oldMax, newMax);
        List<StackTraceElement> newElementsList = Collections.EMPTY_LIST;
        List<StackTraceElement> oldElementsList = Collections.EMPTY_LIST;
        for (int iteratorIndex = 0; iteratorIndex <= globalMax; ++iteratorIndex) {
            StackTraceElement newElement;
            StackTraceElement oldElement = oldMax >= iteratorIndex ? oldElements[oldMax - iteratorIndex] : null;
            StackTraceElement stackTraceElement = newElement = newMax >= iteratorIndex ? newElements[newMax - iteratorIndex] : null;
            if (oldElement != null && newElement != null) {
                if (oldElement.equals(newElement)) continue;
                if (this.hasSameMethodInfo(oldElement, newElement)) {
                    ++iteratorIndex;
                }
                newElementsList = Arrays.asList(newElements).subList(0, newMax - iteratorIndex + 1);
                oldElementsList = Arrays.asList(oldElements).subList(0, oldMax - iteratorIndex + 1);
                break;
            }
            if (oldElement == null && newElement != null) {
                newElementsList = Arrays.asList(newElements).subList(0, newMax - iteratorIndex + 1);
                break;
            }
            if (oldElement == null || newElement != null) continue;
            oldElementsList = Arrays.asList(oldElements).subList(0, oldMax - iteratorIndex + 1);
            break;
        }
        this.addMethodExits(threadId, oldElementsList, timestamp, threadtimestamp, newElements.length == 0);
        this.addMethodEntries(threadId, newElementsList, timestamp, threadtimestamp, oldElements.length == 0);
    }

    private void addMethodEntries(int threadId, List<StackTraceElement> elements, long timestamp, long threadtimestamp, boolean asRoot) throws IllegalStateException {
        boolean inRoot = false;
        ListIterator<StackTraceElement> reverseIt = elements.listIterator(elements.size());
        while (reverseIt.hasPrevious()) {
            int index;
            StackTraceElement element = reverseIt.previous();
            MethodInfo mi = new MethodInfo(element);
            if (!this.methodInfos.contains(mi)) {
                this.methodInfos.add(mi);
            }
            if ((index = this.methodInfos.indexOf(mi)) == -1) {
                System.err.println("*** Not found: " + mi);
                throw new IllegalStateException();
            }
            if (asRoot && !inRoot) {
                inRoot = true;
                this.ccgb.methodEntry(index, threadId, 2, timestamp, threadtimestamp);
                continue;
            }
            this.ccgb.methodEntry(index, threadId, 1, timestamp, threadtimestamp);
        }
    }

    private void addMethodExits(int threadId, List<StackTraceElement> elements, long timestamp, long threadtimestamp, boolean asRoot) throws IllegalStateException {
        int rootIndex = elements.size();
        for (StackTraceElement element : elements) {
            MethodInfo mi = new MethodInfo(element);
            int index = this.methodInfos.indexOf(mi);
            if (index == -1) {
                System.err.println("*** Not found: " + mi);
                throw new IllegalStateException();
            }
            if (asRoot && --rootIndex == 0) {
                this.ccgb.methodExit(index, threadId, 2, timestamp, threadtimestamp);
                continue;
            }
            this.ccgb.methodExit(index, threadId, 1, timestamp, threadtimestamp);
        }
    }

    private boolean hasSameMethodInfo(StackTraceElement oldElement, StackTraceElement newElement) {
        MethodInfo oldMethodInfo = new MethodInfo(oldElement);
        MethodInfo newMethodInfo = new MethodInfo(newElement);
        return oldMethodInfo.equals(newMethodInfo);
    }

    private void setDefaultTiming() {
        ProfilingSessionStatus pss = new ProfilingSessionStatus();
        pss.timerCountsInSecond[0] = InstrTimingData.DEFAULT.timerCountsInSecond0;
        pss.timerCountsInSecond[1] = InstrTimingData.DEFAULT.timerCountsInSecond1;
        pss.currentInstrType = 2;
        pss.absoluteTimerOn = true;
        pss.threadCPUTimerOn = true;
        TimingAdjusterOld.getInstance(pss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CPUResultsSnapshot createSnapshot(long since) throws CPUResultsSnapshot.NoDataAvailableException {
        if (this.stackTraceCount < 1) {
            throw new CPUResultsSnapshot.NoDataAvailableException();
        }
        Object object = this.lock;
        synchronized (object) {
            int miCount = this.methodInfos.size();
            String[] instrMethodClasses = new String[this.methodInfos.size()];
            String[] instrMethodNames = new String[this.methodInfos.size()];
            String[] instrMethodSigs = new String[this.methodInfos.size()];
            int counter = 0;
            for (MethodInfo mi : this.methodInfos) {
                instrMethodClasses[counter] = mi.className;
                instrMethodNames[counter] = mi.methodName;
                instrMethodSigs[counter] = "";
                ++counter;
            }
            this.addStacktrace(new ThreadInfo[0], this.currentDumpTimeStamp + 1L);
            return new CPUResultsSnapshot(since, System.currentTimeMillis(), this.ccgb, this.ccgb.isCollectingTwoTimeStamps(), instrMethodClasses, instrMethodNames, instrMethodSigs, miCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.ccgb.reset();
            this.methodInfos.clear();
            this.threadIds.clear();
            this.threadNames.clear();
            this.stackTraceCount = 0;
            this.lastStackTrace.set(Collections.EMPTY_MAP);
            Object object2 = this.stampLock;
            synchronized (object2) {
                this.currentDumpTimeStamp = -1L;
            }
        }
    }

    public MethodInfoMapper getMapper() {
        return this.mapper;
    }

    public RuntimeCCTNode getAppRootNode() {
        return this.ccgb.getAppRootNode();
    }

    public boolean collectionTwoTimeStamps() {
        return true;
    }

    public InstrumentationFilter getFilter() {
        return this.filter;
    }

    private class StackTraceCallGraphBuilder
    extends CPUCallGraphBuilder {
        StackTraceCallGraphBuilder(MethodInfoMapper mapper) {
            this.setFactory(new CPUCCTNodeFactory(true));
            this.setFilter(InstrumentationFilter.getDefault());
            this.setMethodInfoMapper(mapper);
        }

        @Override
        protected boolean isCollectingTwoTimeStamps() {
            return true;
        }

        @Override
        protected boolean isReady() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long getDumpAbsTimeStamp() {
            Object object = StackTraceSnapshotBuilder.this.stampLock;
            synchronized (object) {
                return StackTraceSnapshotBuilder.this.currentDumpTimeStamp;
            }
        }
    }

    static class SampledThreadInfo {
        private StackTraceElement[] stackTrace;
        private Thread.State state;
        private ThreadInfo threadInfo;

        SampledThreadInfo(ThreadInfo info, InstrumentationFilter filter) {
            Thread.State newState = info.getThreadState();
            StackTraceElement[] st = info.getStackTrace();
            this.threadInfo = info;
            if (newState == Thread.State.RUNNABLE && SampledThreadInfo.containsKnownBlockingMethod(st)) {
                this.state = Thread.State.WAITING;
            }
            if (filter != null) {
                int i;
                for (i = 0; i < st.length; ++i) {
                    StackTraceElement frame = st[i];
                    if (!filter.passesFilter(frame.getClassName().replace('.', '/'))) continue;
                    if (i <= 1) break;
                    this.stackTrace = new StackTraceElement[st.length - i + 1];
                    System.arraycopy(st, i - 1, this.stackTrace, 0, this.stackTrace.length);
                    break;
                }
                if (i == st.length) {
                    this.stackTrace = NO_STACK_TRACE;
                }
            }
        }

        private static boolean containsKnownBlockingMethod(StackTraceElement[] stackTrace) {
            if (stackTrace.length > 0) {
                MethodInfo firstFrame = new MethodInfo(stackTrace[0]);
                return knownBLockingMethods.contains(firstFrame);
            }
            return false;
        }

        private StackTraceElement[] getStackTrace() {
            if (this.stackTrace != null) {
                return this.stackTrace;
            }
            return this.threadInfo.getStackTrace();
        }

        Thread.State getThreadState() {
            if (this.state != null) {
                return this.state;
            }
            return this.threadInfo.getThreadState();
        }

        private String getThreadName() {
            return this.threadInfo.getThreadName();
        }

        private long getThreadId() {
            return this.threadInfo.getThreadId();
        }
    }

    static class MethodInfo {
        final String className;
        final String methodName;

        MethodInfo(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        MethodInfo(StackTraceElement element) {
            this.className = element.getClassName();
            this.methodName = element.getMethodName() + (element.isNativeMethod() ? "[native]" : "");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodInfo other = (MethodInfo)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.className != null ? this.className.hashCode() : 0);
            hash = 29 * hash + (this.methodName != null ? this.methodName.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.className + "." + this.methodName + "()";
        }
    }
}

