/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;

public class EventBufferProcessor
implements CommonConstants {
    protected static ProfilingSessionStatus status;
    protected static ProfilerClient profilerClient;
    protected static byte[] buf;
    protected static MappedByteBuffer mapByteBuf;
    protected static File bufFile;
    protected static RandomAccessFile raFile;
    protected static FileChannel bufFileChannel;
    protected static boolean bufFileExists;
    protected static long startDataProcessingTime;
    protected static long dataProcessingTime;

    public static long getDataProcessingTime() {
        return dataProcessingTime;
    }

    public static boolean setEventBufferFile(String fileName) {
        if (status != null && EventBufferProcessor.status.remoteProfiling) {
            return true;
        }
        if (bufFile != null) {
            EventBufferProcessor.removeEventBufferFile();
        }
        try {
            bufFile = new File(fileName);
            raFile = new RandomAccessFile(bufFile, "rw");
            bufFileChannel = raFile.getChannel();
            mapByteBuf = bufFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 1200000L);
            mapByteBuf.rewind();
            mapByteBuf.mark();
            bufFileExists = true;
        }
        catch (FileNotFoundException ex1) {
            return false;
        }
        catch (IOException ex2) {
            ProfilerLogger.severe("internal error when opening memory-mapped temporary file");
            ProfilerLogger.log(ex2);
            ProfilerLogger.severe("*** Please report this problem to feedback@profiler.netbeans.org");
            return false;
        }
        return true;
    }

    public static boolean bufFileExists() {
        return bufFileExists;
    }

    public static void initialize(ProfilerClient inProfilerClient) {
        profilerClient = inProfilerClient;
        status = profilerClient.getStatus();
    }

    public static synchronized void readDataAndPrepareForProcessing(EventBufferDumpedCommand cmd) {
        if (!EventBufferProcessor.status.remoteProfiling) {
            int bufSizeInBytes = cmd.getBufSize();
            if (buf == null || buf.length < bufSizeInBytes) {
                buf = new byte[bufSizeInBytes];
            }
            mapByteBuf.reset();
            mapByteBuf.get(buf, 0, bufSizeInBytes);
        } else {
            buf = cmd.getBuffer();
            assert (buf != null);
        }
        startDataProcessingTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEventBufferFile() {
        if (status != null && EventBufferProcessor.status.remoteProfiling) {
            return;
        }
        try {
            if (bufFile != null) {
                mapByteBuf = null;
                if (bufFileChannel != null) {
                    bufFileChannel.close();
                }
                if (raFile != null) {
                    raFile.close();
                }
                System.gc();
                for (int i = 0; i < 20; ++i) {
                    if (bufFile.delete()) {
                        bufFile = null;
                        bufFileExists = false;
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException ex) {
            ProfilerLogger.severe("internal error when closing memory-mapped temporary file");
            ProfilerLogger.severe("*** Please report this problem to feedback@profiler.netbeans.org");
        }
        finally {
            bufFileExists = false;
        }
    }

    public static void reset() {
        dataProcessingTime = 0L;
    }

    protected static synchronized void completeDataProcessing() {
        dataProcessingTime += System.currentTimeMillis() - startDataProcessingTime;
    }
}

