/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassRewriter {
    public static byte[] rewriteClassFile(DynamicClassInfo clazz, byte[][] replacementMethodInfos, int nAddedCPEntries, byte[] addedCPContents) {
        byte[] origBytes = null;
        try {
            origBytes = clazz.getClassFileBytes();
        }
        catch (IOException ex) {
            MiscUtils.internalError("ClassRewriter: can't get original class file bytes for class " + clazz.getName() + "\nIOException message = " + ex.getMessage());
        }
        int newLen = origBytes.length;
        newLen += addedCPContents.length;
        int nMethods = clazz.getMethodNames().length;
        for (int i = 0; i < nMethods; ++i) {
            if (replacementMethodInfos[i] == null) continue;
            newLen += replacementMethodInfos[i].length - clazz.getOrigMethodInfoLength(i);
        }
        byte[] res = new byte[newLen];
        int destPos = 0;
        System.arraycopy(origBytes, 0, res, destPos, clazz.getOrigIntermediateDataStartOfs());
        System.arraycopy(addedCPContents, 0, res, destPos += clazz.getOrigIntermediateDataStartOfs(), addedCPContents.length);
        destPos += addedCPContents.length;
        int newCPCount = clazz.getOrigCPoolCount() + nAddedCPEntries;
        int pos = clazz.getOrigCPoolStartOfs();
        res[pos] = (byte)(newCPCount >> 8 & 0xFF);
        res[pos + 1] = (byte)(newCPCount & 0xFF);
        int count = clazz.getOrigMethodsStartOfs() - clazz.getOrigIntermediateDataStartOfs();
        System.arraycopy(origBytes, clazz.getOrigIntermediateDataStartOfs(), res, destPos, count);
        res[destPos += count] = (byte)(nMethods >> 8 & 0xFF);
        res[destPos + 1] = (byte)(nMethods & 0xFF);
        destPos += 2;
        for (int i = 0; i < nMethods; ++i) {
            if (replacementMethodInfos[i] != null) {
                System.arraycopy(replacementMethodInfos[i], 0, res, destPos, replacementMethodInfos[i].length);
                destPos += replacementMethodInfos[i].length;
                continue;
            }
            byte[] origMethodInfo = clazz.getOrigMethodInfo(i);
            System.arraycopy(origMethodInfo, 0, res, destPos, origMethodInfo.length);
            destPos += origMethodInfo.length;
        }
        count = origBytes.length - clazz.getOrigAttrsStartOfs();
        System.arraycopy(origBytes, clazz.getOrigAttrsStartOfs(), res, destPos, count);
        return res;
    }

    public static void saveToDisk(String name, byte[] classBytes) {
        if (Platform.getJDKVersionNumber() == 5) {
            return;
        }
        name = name.replace('/', '_');
        try {
            System.err.print("*** Gonna save bytecode " + name + " to disk... ");
            FileOutputStream out = new FileOutputStream(new File(name + ".class"));
            ((OutputStream)out).write(classBytes);
            ((OutputStream)out).close();
            System.err.println("done");
        }
        catch (Exception ex) {
            System.err.println("*** In RecursiveMethodInstrumentor.saveClassFileToDisk caught ex = " + ex);
        }
    }

    private static void saveClassFileToDisk(DynamicClassInfo clazz, byte[] replacementClassFile) {
        ClassRewriter.saveToDisk(clazz.getName(), replacementClassFile);
    }
}

