/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.hintsimpl;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class LoggerStringConcat {
    private static final Logger LOG = Logger.getLogger(LoggerStringConcat.class.getName());

    public static ErrorDescription hint1(HintContext hintContext) {
        return LoggerStringConcat.compute(hintContext, null);
    }

    public static ErrorDescription hint2(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
        MemberSelectTree memberSelectTree = (MemberSelectTree)methodInvocationTree.getMethodSelect();
        String string = memberSelectTree.getIdentifier().toString();
        if (LoggerStringConcat.findConstant(hintContext.getInfo(), string) != null) {
            return LoggerStringConcat.compute(hintContext, string);
        }
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Please add the following info the bug #180865:\n");
            stringBuilder.append("tree: ").append(hintContext.getPath().getLeaf()).append("\n");
            TreePath treePath2 = hintContext.getVariables().get("$logger");
            if (treePath2 != null) {
                stringBuilder.append("logger type: ").append(hintContext.getInfo().getTrees().getTypeMirror(treePath2)).append("\n");
            } else {
                stringBuilder.append("$logger == null\n");
            }
            stringBuilder.append("source level: ").append((Object)hintContext.getInfo().getSourceVersion()).append("\n");
            stringBuilder.append("End of #180865 debug info");
            LOG.info(stringBuilder.toString());
        }
        return null;
    }

    private static ErrorDescription compute(HintContext hintContext, String string) {
        TreePath treePath = hintContext.getVariables().get("$message");
        List<List<TreePath>> list = Utilities.splitStringConcatenationToElements(hintContext.getInfo(), treePath);
        if (list.size() <= 1) {
            return null;
        }
        for (List<TreePath> list2 : list) {
            for (TreePath treePath2 : list2) {
                if (treePath2.getLeaf().getKind() != Tree.Kind.ERRONEOUS) continue;
                return null;
            }
        }
        FixImpl fixImpl = new FixImpl(NbBundle.getMessage(LoggerStringConcat.class, (String)"MSG_LoggerStringConcat_fix"), string, TreePathHandle.create((TreePath)hintContext.getPath(), (CompilationInfo)hintContext.getInfo()), TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo()));
        return ErrorDescriptionFactory.forTree(hintContext, treePath, NbBundle.getMessage(LoggerStringConcat.class, (String)"MSG_LoggerStringConcat"), fixImpl);
    }

    private static void rewrite(WorkingCopy workingCopy, ExpressionTree expressionTree, MethodInvocationTree methodInvocationTree, TreePath treePath) {
        Object object;
        Object object3;
        List<TreePath> list32;
        List<List<TreePath>> list2 = Utilities.splitStringConcatenationToElements((CompilationInfo)workingCopy, treePath);
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Tree> linkedList = new LinkedList<Tree>();
        LinkedList<ExpressionTree> linkedList2 = new LinkedList<ExpressionTree>();
        int n = 0;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        for (List<TreePath> list32 : list2) {
            if (list32.size() == 1 && list32.get(0).getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
                object3 = (String)((LiteralTree)list32.get(0).getLeaf()).getValue();
                object3 = ((String)object3).replaceAll("'", "''");
                object3 = ((String)object3).replaceAll(Pattern.quote("{"), Matcher.quoteReplacement("'{'"));
                object3 = ((String)object3).replaceAll(Pattern.quote("}"), Matcher.quoteReplacement("'}'"));
                stringBuilder.append((String)object3);
                continue;
            }
            if (list32.size() == 1 && !Utilities.isConstantString((CompilationInfo)workingCopy, list32.get(0))) {
                stringBuilder.append("{");
                stringBuilder.append(Integer.toString(n++));
                stringBuilder.append("}");
                linkedList2.add((ExpressionTree)list32.get(0).getLeaf());
                continue;
            }
            if (stringBuilder.length() > 0) {
                linkedList.add(treeMaker.Literal((Object)stringBuilder.toString()));
                stringBuilder.delete(0, stringBuilder.length());
            }
            for (TreePath object22 : list32) {
                object = (String)((LiteralTree)object22.getLeaf()).getValue();
                if (((String)object).contains("'")) {
                    linkedList.add(treeMaker.Literal((Object)((String)object).replaceAll("'", "''")));
                    continue;
                }
                linkedList.add(object22.getLeaf());
            }
        }
        if (stringBuilder.length() > 0) {
            linkedList.add(treeMaker.Literal((Object)stringBuilder.toString()));
        }
        Object object4 = (ExpressionTree)linkedList.remove(0);
        while (!linkedList.isEmpty()) {
            object4 = treeMaker.Binary(Tree.Kind.PLUS, (ExpressionTree)object4, (ExpressionTree)linkedList.remove(0));
        }
        list32 = new LinkedList<TreePath>();
        list32.add((TreePath)((Object)expressionTree));
        list32.add((TreePath)object4);
        if (linkedList2.size() > 1) {
            list32.add((TreePath)((Object)treeMaker.NewArray((Tree)treeMaker.QualIdent((Element)workingCopy.getElements().getTypeElement("java.lang.Object")), Collections.emptyList(), linkedList2)));
        } else {
            list32.addAll(linkedList2);
        }
        object3 = (MemberSelectTree)methodInvocationTree.getMethodSelect();
        MemberSelectTree memberSelectTree = treeMaker.MemberSelect(object3.getExpression(), (CharSequence)"log");
        object = treeMaker.MethodInvocation(methodInvocationTree.getTypeArguments(), (ExpressionTree)memberSelectTree, list32);
        workingCopy.rewrite((Tree)methodInvocationTree, (Tree)object);
    }

    private static VariableElement findConstant(CompilationInfo compilationInfo, String string) {
        string = string.toUpperCase();
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.util.logging.Level");
        if (typeElement == null) {
            return null;
        }
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getSimpleName().contentEquals(string)) continue;
            return variableElement;
        }
        return null;
    }

    private static final class FixImpl
    implements Fix {
        private final String displayName;
        private final String logMethodName;
        private final TreePathHandle invocation;
        private final TreePathHandle message;

        public FixImpl(String string, String string2, TreePathHandle treePathHandle, TreePathHandle treePathHandle2) {
            this.displayName = string;
            this.logMethodName = string2;
            this.invocation = treePathHandle;
            this.message = treePathHandle2;
        }

        public String getText() {
            return this.displayName;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.invocation.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.invocation.resolve((CompilationInfo)workingCopy);
                    TreePath treePath2 = FixImpl.this.message.resolve((CompilationInfo)workingCopy);
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
                    ExpressionTree expressionTree = null;
                    if (FixImpl.this.logMethodName != null) {
                        String string = FixImpl.this.logMethodName.toUpperCase();
                        VariableElement variableElement = LoggerStringConcat.findConstant((CompilationInfo)workingCopy, string);
                        expressionTree = workingCopy.getTreeMaker().QualIdent((Element)variableElement);
                    } else {
                        expressionTree = methodInvocationTree.getArguments().get(0);
                    }
                    LoggerStringConcat.rewrite(workingCopy, expressionTree, methodInvocationTree, treePath2);
                }
            }).commit();
            return null;
        }
    }
}

