/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class LazyHintComputationFactory
extends EditorAwareJavaSourceTaskFactory {
    private static Map<FileObject, List<Reference<CreatorBasedLazyFixList>>> file2Creators = new WeakHashMap<FileObject, List<Reference<CreatorBasedLazyFixList>>>();

    public LazyHintComputationFactory() {
        super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
    }

    public CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
        return new LazyHintComputation(fileObject);
    }

    private static void rescheduleImpl(FileObject fileObject) {
        LazyHintComputationFactory lazyHintComputationFactory = (LazyHintComputationFactory)((Object)Lookup.getDefault().lookup(LazyHintComputationFactory.class));
        if (lazyHintComputationFactory != null) {
            lazyHintComputationFactory.reschedule(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCompute(FileObject fileObject, CreatorBasedLazyFixList creatorBasedLazyFixList) {
        Class<LazyHintComputationFactory> clazz = LazyHintComputationFactory.class;
        synchronized (LazyHintComputationFactory.class) {
            List<Reference<CreatorBasedLazyFixList>> list = file2Creators.get(fileObject);
            if (list == null) {
                list = new ArrayList<Reference<CreatorBasedLazyFixList>>();
                file2Creators.put(fileObject, list);
            }
            list.add(new WeakReference<CreatorBasedLazyFixList>(creatorBasedLazyFixList));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            LazyHintComputationFactory.rescheduleImpl(fileObject);
            return;
        }
    }

    public static synchronized List<CreatorBasedLazyFixList> getAndClearToCompute(FileObject fileObject) {
        List<Reference<CreatorBasedLazyFixList>> list = file2Creators.get(fileObject);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<CreatorBasedLazyFixList> arrayList = new ArrayList<CreatorBasedLazyFixList>();
        for (Reference<CreatorBasedLazyFixList> reference : list) {
            CreatorBasedLazyFixList creatorBasedLazyFixList = reference.get();
            if (creatorBasedLazyFixList == null) continue;
            arrayList.add(creatorBasedLazyFixList);
        }
        list.clear();
        return arrayList;
    }
}

