/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class UtilityClass
extends AbstractHint
implements ElementVisitor<Boolean, CompilationInfo> {
    private boolean clazz;
    private volatile transient boolean stop;

    private UtilityClass(boolean bl) {
        super(false, true, bl ? AbstractHint.HintSeverity.WARNING : AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
        this.clazz = bl;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(this.clazz ? Tree.Kind.CLASS : Tree.Kind.METHOD);
    }

    public static UtilityClass withoutConstructor() {
        return new UtilityClass(true);
    }

    public static UtilityClass withConstructor() {
        return new UtilityClass(false);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        List<? extends Element> list;
        this.stop = false;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null) {
            return null;
        }
        if (this.clazz) {
            if (element.getKind() == ElementKind.ENUM) {
                return null;
            }
            if (element.getKind() == ElementKind.INTERFACE) {
                return null;
            }
            if (element.getKind() == ElementKind.ANNOTATION_TYPE) {
                return null;
            }
            if (element.getKind() == ElementKind.CLASS) {
                Name object2;
                TypeMirror typeMirror = ((TypeElement)element).getSuperclass();
                if (typeMirror == null) {
                    return null;
                }
                list = compilationInfo.getTypes().asElement(typeMirror);
                if (list instanceof TypeElement && (object2 = compilationInfo.getElements().getBinaryName((TypeElement)((Object)list))) != null && !object2.contentEquals("java.lang.Object")) {
                    return null;
                }
            }
            int n = 0;
            for (Element element2 : element.getEnclosedElements()) {
                if (this.stop) {
                    return null;
                }
                if (element2.accept(this, compilationInfo).booleanValue()) {
                    return null;
                }
                if (element2.getKind() != ElementKind.METHOD && element2.getKind() != ElementKind.FIELD) continue;
                ++n;
            }
            if (n == 0) {
                return null;
            }
        } else {
            if (element.getKind() != ElementKind.CONSTRUCTOR) {
                return null;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            list = executableElement.getEnclosingElement().getEnclosedElements();
            if (list.size() == 1 && ((Object)list.get(0)).equals(executableElement)) {
                return null;
            }
            for (Element element3 : list) {
                if (this.stop) {
                    return null;
                }
                if (!element3.accept(this, compilationInfo).booleanValue()) continue;
                return null;
            }
            if (!executableElement.getModifiers().contains((Object)Modifier.PROTECTED) && !executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return null;
            }
        }
        List<FixImpl> list2 = Collections.singletonList(new FixImpl(this.clazz, TreePathHandle.create((Element)element, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        list = null;
        switch (treePath.getLeaf().getKind()) {
            case METHOD: {
                list = (List<? extends Element>)compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                break;
            }
            case CLASS: {
                list = (List<? extends Element>)compilationInfo.getTreeUtilities().findNameSpan((ClassTree)treePath.getLeaf());
                break;
            }
            case VARIABLE: {
                list = (List<? extends Element>)compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
            }
        }
        if (list != null) {
            ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_UtilityClass" : "MSG_PublicConstructor")), list2, (FileObject)compilationInfo.getFileObject(), (int)list[0], (int)list[1]);
            return Collections.singletonList(errorDescription);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName() + (this.clazz ? "_1" : "_2");
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_UtilityClass" : "MSG_PublicConstructor"));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "HINT_UtilityClass" : "HINT_PublicConstructor"));
    }

    @Override
    public void cancel() {
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Boolean visit(Element element, CompilationInfo compilationInfo) {
        return false;
    }

    @Override
    public Boolean visit(Element element) {
        return false;
    }

    @Override
    public Boolean visitPackage(PackageElement packageElement, CompilationInfo compilationInfo) {
        return false;
    }

    @Override
    public Boolean visitType(TypeElement typeElement, CompilationInfo compilationInfo) {
        return false;
    }

    @Override
    public Boolean visitVariable(VariableElement variableElement, CompilationInfo compilationInfo) {
        return !variableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        if (this.clazz) {
            return !executableElement.getModifiers().contains((Object)Modifier.STATIC) && !compilationInfo.getElementUtilities().isSynthetic((Element)executableElement);
        }
        boolean bl = !executableElement.getModifiers().contains((Object)Modifier.STATIC) && !executableElement.getSimpleName().contentEquals("<init>");
        boolean bl2 = executableElement.getModifiers().contains((Object)Modifier.STATIC) && executableElement.getSimpleName().contentEquals("main") && executableElement.getReturnType().getKind() == TypeKind.VOID && executableElement.getParameters().size() == 1 && ((Object)executableElement.getParameters().get(0).asType()).toString().equals("java.lang.String[]");
        return bl || bl2;
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterElement typeParameterElement, CompilationInfo compilationInfo) {
        return false;
    }

    @Override
    public Boolean visitUnknown(Element element, CompilationInfo compilationInfo) {
        return false;
    }

    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private boolean clazz;

        public FixImpl(boolean bl, TreePathHandle treePathHandle, FileObject fileObject) {
            this.handle = treePathHandle;
            this.file = fileObject;
            this.clazz = bl;
        }

        public String getText() {
            return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_PrivateConstructor" : "MSG_MakePrivate"));
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            modificationResult.commit();
            return null;
        }

        public String toString() {
            return "FixUtilityClass";
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            Element element = this.handle.resolveElement((CompilationInfo)workingCopy);
            if (element == null) {
                return;
            }
            Tree tree = workingCopy.getTrees().getTree(element);
            if (this.clazz) {
                if (tree == null || tree.getKind() != Tree.Kind.CLASS) {
                    return;
                }
                ClassTree classTree = (ClassTree)tree;
                ModifiersTree modifiersTree = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
                MethodTree methodTree = workingCopy.getTreeMaker().Constructor(modifiersTree, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), workingCopy.getTreeMaker().Block(Collections.emptyList(), false));
                workingCopy.rewrite((Tree)classTree, (Tree)workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree));
            } else {
                if (tree == null || tree.getKind() != Tree.Kind.METHOD) {
                    return;
                }
                MethodTree methodTree = (MethodTree)tree;
                ModifiersTree modifiersTree = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), methodTree.getModifiers().getAnnotations());
                workingCopy.rewrite((Tree)methodTree.getModifiers(), (Tree)modifiersTree);
            }
        }
    }
}

