/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssignResultToVariable
extends AbstractHint {
    private static final Set<JavaTokenId> TO_IGNORE = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    private static final String VAR_TYPE_TAG = "varType";
    private static final Set<TypeKind> NOT_ACCEPTABLE_TYPE_KINDS = EnumSet.of(TypeKind.ERROR, new TypeKind[]{TypeKind.EXECUTABLE, TypeKind.NONE, TypeKind.NULL, TypeKind.OTHER, TypeKind.PACKAGE, TypeKind.WILDCARD, TypeKind.VOID});

    public AssignResultToVariable() {
        super(true, false, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.BLOCK);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        try {
            Tree.Kind kind;
            Tree tree;
            Tree tree2;
            int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
            boolean bl = true;
            if (treePath.getLeaf().getKind() == Tree.Kind.BLOCK) {
                tree2 = this.findStatementForgiving(compilationInfo, (BlockTree)treePath.getLeaf(), n);
                if (tree2 == null || tree2.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                    return null;
                }
                tree = (ExpressionStatementTree)tree2;
                kind = tree.getExpression().getKind();
                if (kind != Tree.Kind.METHOD_INVOCATION && kind != Tree.Kind.NEW_CLASS) {
                    return null;
                }
                treePath = new TreePath(new TreePath(treePath, tree2), tree.getExpression());
                bl = false;
            }
            if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                return null;
            }
            tree2 = treePath.getLeaf();
            tree = null;
            kind = tree2.getKind();
            if (kind == Tree.Kind.METHOD_INVOCATION) {
                tree = ((MethodInvocationTree)tree2).getMethodSelect();
            } else if (kind == Tree.Kind.NEW_CLASS) {
                tree = tree2;
            }
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree);
            if (bl && (l == -1L || l2 == -1L || (long)n < l || (long)n > l2)) {
                return null;
            }
            Element element = compilationInfo.getTrees().getElement(treePath);
            if (element == null || element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) {
                return null;
            }
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
            if (typeMirror == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)typeMirror.getKind())) {
                return null;
            }
            List<FixImpl> list = Collections.singletonList(new FixImpl(compilationInfo.getFileObject(), compilationInfo.getDocument(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo)));
            String string = NbBundle.getMessage(AssignResultToVariable.class, (String)"HINT_AssignResultToVariable");
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string, list, (FileObject)compilationInfo.getFileObject(), (int)((int)l), (int)((int)l2)));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private int findFirstNonWhitespace(CompilationInfo compilationInfo, int n, boolean bl) {
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return -1;
        }
        if (!TO_IGNORE.contains(tokenSequence.token().id())) {
            return n;
        }
        do {
            JavaTokenId javaTokenId;
            if (!TO_IGNORE.contains(javaTokenId = (JavaTokenId)tokenSequence.token().id())) {
                n = tokenSequence.offset() + (bl ? tokenSequence.token().length() : 0);
                break;
            }
            CharSequence charSequence = tokenSequence.token().text();
            int n2 = Math.max(0, bl ? 0 : n - tokenSequence.offset());
            int n3 = Math.min(charSequence.length(), bl ? n - tokenSequence.offset() : Integer.MAX_VALUE);
            for (int i = n2; i < n3; ++i) {
                if (charSequence.charAt(i) != '\n') continue;
                return -1;
            }
        } while (!bl ? tokenSequence.moveNext() : tokenSequence.movePrevious());
        return n;
    }

    private StatementTree findExactStatement(CompilationInfo compilationInfo, BlockTree blockTree, int n, boolean bl) {
        if (n == -1) {
            return null;
        }
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        for (StatementTree statementTree : blockTree.getStatements()) {
            long l = bl ? sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), statementTree) : sourcePositions.getEndPosition(compilationUnitTree, statementTree);
            if ((long)n != l) continue;
            return statementTree;
        }
        return null;
    }

    private StatementTree findMatchingMethodInvocation(CompilationInfo compilationInfo, BlockTree blockTree, int n) {
        for (StatementTree statementTree : blockTree.getStatements()) {
            if (statementTree.getKind() != Tree.Kind.EXPRESSION_STATEMENT) continue;
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), statementTree);
            if ((long)n < l) {
                return null;
            }
            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), statementTree);
            long l3 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), expressionStatementTree.getExpression());
            if (l3 > (long)n || (long)n >= l2) continue;
            return statementTree;
        }
        return null;
    }

    private StatementTree findStatementForgiving(CompilationInfo compilationInfo, BlockTree blockTree, int n) {
        StatementTree statementTree = this.findMatchingMethodInvocation(compilationInfo, blockTree, n);
        if (statementTree != null) {
            return statementTree;
        }
        StatementTree statementTree2 = this.findExactStatement(compilationInfo, blockTree, n, false);
        StatementTree statementTree3 = this.findExactStatement(compilationInfo, blockTree, n, true);
        if (statementTree2 != null && statementTree3 != null) {
            return null;
        }
        if (statementTree2 != null) {
            return statementTree2;
        }
        if (statementTree3 != null) {
            return statementTree3;
        }
        int n2 = this.findFirstNonWhitespace(compilationInfo, n, true);
        int n3 = this.findFirstNonWhitespace(compilationInfo, n, false);
        statementTree2 = this.findExactStatement(compilationInfo, blockTree, n2, false);
        statementTree3 = this.findExactStatement(compilationInfo, blockTree, n3, true);
        if (statementTree2 != null && statementTree3 != null) {
            return null;
        }
        return statementTree2 != null ? statementTree2 : statementTree3;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AssignResultToVariable.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DN_AssignResultToVariable");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DESC_AssignResultToVariable");
    }

    static final class FixImpl
    implements Fix {
        private FileObject file;
        private Document doc;
        private TreePathHandle tph;

        public FixImpl(FileObject fileObject, Document document, TreePathHandle treePathHandle) {
            this.file = fileObject;
            this.doc = document;
            this.tph = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(AssignResultToVariable.class, (String)"FIX_AssignResultToVariable");
        }

        public ChangeInfo implement() {
            try {
                final String[] stringArray = new String[1];
                ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws Exception {
                        NewClassTree newClassTree;
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath treePath = FixImpl.this.tph.resolve((CompilationInfo)workingCopy);
                        if (treePath == null) {
                            Logger.getLogger(AssignResultToVariable.class.getName()).info("tp=null");
                            return;
                        }
                        TypeMirror typeMirror = workingCopy.getTrees().getTypeMirror(treePath);
                        Element element = workingCopy.getTrees().getElement(treePath);
                        if (typeMirror == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)typeMirror.getKind())) {
                            return;
                        }
                        Tree tree = treePath.getLeaf();
                        boolean bl = false;
                        ExpressionTree expressionTree = null;
                        if (tree instanceof NewClassTree) {
                            newClassTree = (NewClassTree)tree;
                            bl = newClassTree.getClassBody() != null || element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.ABSTRACT);
                            expressionTree = newClassTree.getIdentifier();
                        }
                        typeMirror = Utilities.resolveCapturedType((CompilationInfo)workingCopy, typeMirror);
                        newClassTree = workingCopy.getTreeMaker();
                        stringArray[0] = Utilities.guessName((CompilationInfo)workingCopy, treePath);
                        ExpressionTree expressionTree2 = bl ? expressionTree : newClassTree.Type(typeMirror);
                        VariableTree variableTree = newClassTree.Variable(newClassTree.Modifiers(EnumSet.noneOf(Modifier.class)), stringArray[0], expressionTree2, (ExpressionTree)treePath.getLeaf());
                        variableTree = Utilities.copyComments(workingCopy, treePath.getLeaf(), variableTree);
                        workingCopy.tag((Tree)expressionTree2, (Object)AssignResultToVariable.VAR_TYPE_TAG);
                        workingCopy.rewrite(treePath.getParentPath().getLeaf(), (Tree)variableTree);
                    }
                });
                modificationResult.commit();
                final int[] nArray = modificationResult.getSpan((Object)AssignResultToVariable.VAR_TYPE_TAG);
                if (nArray == null) {
                    Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "Cannot resolve variable type span.");
                    return null;
                }
                final ChangeInfo[] changeInfoArray = new ChangeInfo[1];
                this.doc.render(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CharSequence charSequence = DocumentUtilities.getText((Document)FixImpl.this.doc, (int)nArray[1], (int)(FixImpl.this.doc.getLength() - nArray[1]));
                            Pattern pattern = Pattern.compile(Pattern.quote(stringArray[0]));
                            Matcher matcher = pattern.matcher(charSequence);
                            if (matcher.find()) {
                                int n = nArray[1] + matcher.start();
                                changeInfoArray[0] = new ChangeInfo(FixImpl.this.doc.createPosition(n), FixImpl.this.doc.createPosition(n + stringArray[0].length()));
                            } else {
                                Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "Cannot find the name in: {0}", ((Object)charSequence).toString());
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
                return changeInfoArray[0];
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }
    }
}

