/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.pojson.Pojson;
import org.codeviation.pojson.StoreInfo;

class FileNameFactory<T>
implements Factory<String, T> {
    private String fileNameFormat;
    private List<Field> idParts;

    public FileNameFactory(Class<T> clazz, Collection<Field> fields) {
        this.idParts = this.getIdParts(fields);
        Pojson.FileNameFormat fnfA = clazz.getAnnotation(Pojson.FileNameFormat.class);
        this.fileNameFormat = fnfA == null ? null : fnfA.value();
    }

    @Override
    public String create(T object) {
        Object[] ids = new Object[this.idParts.size()];
        for (int i = 0; i < this.idParts.size(); ++i) {
            try {
                Field field = this.idParts.get(i);
                field.setAccessible(true);
                ids[i] = field.get(object);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.fileNameFormat == null) {
            for (Object id : ids) {
                sb.append(id == null ? "null" : id.toString());
            }
            sb.append(".json");
        } else {
            Formatter f = new Formatter();
            f.format(this.fileNameFormat, ids);
            sb.append(f.toString());
        }
        return sb.toString();
    }

    public List<Field> getIdParts(Collection<Field> fields) {
        TreeMap<Integer, Field> numberedIds = new TreeMap<Integer, Field>();
        ArrayList<Field> anonIds = new ArrayList<Field>();
        Field first = null;
        for (Field f : fields) {
            Pojson.IdPart idAn;
            if (first == null) {
                first = f;
            }
            if ((idAn = f.getAnnotation(Pojson.IdPart.class)) == null) continue;
            int value = idAn.value();
            if (value == -1) {
                anonIds.add(f);
                continue;
            }
            numberedIds.put(value, f);
        }
        int idsSize = numberedIds.size() + anonIds.size();
        ArrayList<Field> idFields = new ArrayList<Field>(idsSize == 0 ? 1 : idsSize);
        if (idsSize == 0) {
            if (first != null) {
                idFields.add(first);
            }
        } else {
            idFields.addAll(numberedIds.values());
            idFields.addAll(anonIds);
        }
        return idFields;
    }
}

