/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import org.codeviation.commons.patterns.Pair;

public class Pairs {
    public static <F, S> Pair<F, S> pair(F first, S second) {
        return new PairImpl<F, S>(first, second, Equality.BOTH);
    }

    public static <F, S> Pair<F, S> pair(F first, S second, Equality equality) {
        return new PairImpl<F, S>(first, second, equality);
    }

    private static class PairImpl<F, S>
    implements Pair<F, S> {
        private F first;
        private S second;
        private Equality equality;

        public PairImpl(F first, S second, Equality equality) {
            this.first = first;
            this.second = second;
            this.equality = equality;
        }

        @Override
        public F getFirst() {
            return this.first;
        }

        @Override
        public S getSecond() {
            return this.second;
        }

        public boolean equals(Object obj) {
            switch (this.equality) {
                case FIRST: {
                    return this.first.equals(obj);
                }
                case SECOND: {
                    return this.second.equals(obj);
                }
                case BOTH: {
                    return this.first.equals(obj) && this.second.equals(obj);
                }
            }
            throw new IllegalStateException("Unknown equality");
        }

        public int hashCode() {
            switch (this.equality) {
                case FIRST: {
                    return this.first.hashCode();
                }
                case SECOND: {
                    return this.second.hashCode();
                }
                case BOTH: {
                    return this.first.hashCode() + 37 * this.second.hashCode();
                }
            }
            throw new IllegalStateException("Unknown equality");
        }
    }

    public static enum Equality {
        FIRST,
        SECOND,
        BOTH;

    }
}

