/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;

public class Factories {
    public static final Factory<String, Object> TO_STRING = new ToString();
    public static final Factory<String[], Object[]> TO_STRING_ARRAY = Factories.array(TO_STRING, new Class[0]);

    private Factories() {
    }

    public static <T, P extends T> Factory<T, P> defaultValue(T defaultValue) {
        return new Default(defaultValue);
    }

    public static <T, P> Factory<T[], P[]> array(Factory<T, P> elementFactory, Class ... productClass) {
        return new ArrayFactory<T, P>(elementFactory, null, ArrayFactory.getProductClass(productClass));
    }

    public static <T, P> Factory<T[], P[]> array(Factory<T, P> elementFactory, Filter<P> filter, Class ... productClass) {
        return new ArrayFactory<T, P>(elementFactory, filter, ArrayFactory.getProductClass(productClass));
    }

    public static <T, P> Factory<T, P> fromMap(Map<P, T> map) {
        return new MapFactory<T, P>(map);
    }

    public static <OT, IT, IP> Factory<OT, IP> chain(Factory<OT, IT> outer, Factory<IT, IP> inner) {
        return new Chain<OT, IT, IP>(outer, inner);
    }

    public static <T, P> Factory<T, P> layered(Factory<T, P> ... factories) {
        return new LayeredFactory<T, P>(factories);
    }

    public static <T, P> Factory<T, P> layered(Iterable<Factory<T, P>> factories) {
        return new LayeredFactory<T, P>(factories);
    }

    public static <T, P> Factory<T, P> field(Class<P> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return new MemberFactory(field);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException("No such field.", ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static <T, P, I> Factory<T, I> method(P object, Class<T> productType, Class<I> paramType, String methodName) {
        try {
            Method method = object.getClass().getMethod(methodName, paramType);
            return new MemberFactory(object, method);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No such method.", ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static <T, P> Factory<T, P> method(Class<P> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            return new MemberFactory(method);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No such method.", ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static <T, P> Factory<T, P> method(Class<P> parameterClass, Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, parameterClass);
            return new MemberFactory(method);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No such method.", ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static <T> Factory<T, T> noOp() {
        return NoOp.INSTACE;
    }

    private static class Default<T, P extends T>
    implements Factory<T, P> {
        private T dflt;

        public Default(T dflt) {
            this.dflt = dflt;
        }

        @Override
        public T create(P param) {
            return (T)(param == null ? this.dflt : param);
        }
    }

    private static class ToString
    implements Factory<String, Object> {
        private static NoOp INSTACE = new NoOp();

        private ToString() {
        }

        @Override
        public String create(Object param) {
            return param.toString();
        }
    }

    private static class NoOp<T>
    implements Factory<T, T> {
        private static NoOp INSTACE = new NoOp();

        private NoOp() {
        }

        @Override
        public T create(T param) {
            return param;
        }
    }

    private static class LayeredFactory<T, P>
    implements Factory<T, P> {
        List<Factory<T, P>> factories;

        public LayeredFactory(Factory<T, P>[] factories) {
            this.factories = new ArrayList<Factory<T, P>>(Arrays.asList(factories));
        }

        public LayeredFactory(Iterable<Factory<T, P>> factories) {
            this.factories = new ArrayList<Factory<T, P>>();
            for (Factory<T, P> factory : factories) {
                this.factories.add(factory);
            }
        }

        @Override
        public T create(P object) {
            for (Factory<T, P> factory : this.factories) {
                T t = factory.create(object);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }

    private static class MemberFactory<T, P>
    implements Factory<T, P> {
        Object object;
        Member member;
        boolean isStatic;

        public MemberFactory(Field field) {
            this.member = field;
            this.isStatic = (this.member.getModifiers() & 8) > 0;
        }

        public MemberFactory(Method method) {
            this.member = method;
            this.isStatic = (this.member.getModifiers() & 8) > 0;
        }

        public MemberFactory(Object object, Method method) {
            this(method);
            this.object = object;
        }

        @Override
        public T create(P param) {
            try {
                if (this.member instanceof Field) {
                    return (T)((Field)this.member).get(param);
                }
                if (this.isStatic) {
                    ((Method)this.member).setAccessible(true);
                    return (T)((Method)this.member).invoke(null, param);
                }
                if (this.object != null) {
                    ((Method)this.member).setAccessible(true);
                    return (T)((Method)this.member).invoke(this.object, param);
                }
                ((Method)this.member).setAccessible(true);
                return (T)((Method)this.member).invoke(param, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class MapFactory<T, P>
    implements Factory<T, P> {
        private Map<P, T> map;

        public MapFactory(Map<P, T> map) {
            this.map = map;
        }

        @Override
        public T create(P param) {
            return this.map.get(param);
        }
    }

    private static class Chain<OT, IT, IP>
    implements Factory<OT, IP> {
        Factory<OT, IT> outer;
        Factory<IT, IP> inner;

        public Chain(Factory<OT, IT> outer, Factory<IT, IP> inner) {
            this.outer = outer;
            this.inner = inner;
        }

        @Override
        public OT create(IP param) {
            IT t1 = this.inner.create(param);
            return this.outer.create(t1);
        }
    }

    private static class ArrayFactory<T, P>
    implements Factory<T[], P[]> {
        private Factory<T, P> elementFactory;
        private Filter<P> filter;
        private Class productClass;

        public ArrayFactory(Factory<T, P> elementFactory, Filter<P> filter, Class productClass) {
            this.filter = filter;
            this.elementFactory = elementFactory;
            if (productClass == null) {
                Type[] gis;
                Class<?> clazz = elementFactory.getClass();
                for (Type t : gis = clazz.getGenericInterfaces()) {
                    ParameterizedType pt;
                    if (!(t instanceof ParameterizedType) || (pt = (ParameterizedType)t).getRawType() != Factory.class) continue;
                    Type[] tvs = ((ParameterizedType)t).getActualTypeArguments();
                    productClass = tvs[0] instanceof Class ? (Class)tvs[0] : null;
                }
            } else {
                this.productClass = productClass;
            }
        }

        @Override
        public T[] create(P[] param) {
            if (this.filter == null) {
                return this.createNoFilter(param);
            }
            return this.createFilter(param);
        }

        private T[] createNoFilter(P[] param) {
            if (param == null) {
                return null;
            }
            Object[] result = (Object[])Array.newInstance(this.productClass, param.length);
            for (int i = 0; i < param.length; ++i) {
                result[i] = this.elementFactory.create(param[i]);
            }
            return result;
        }

        private T[] createFilter(P[] param) {
            if (param == null) {
                return null;
            }
            ArrayList<T> al = new ArrayList<T>(param.length);
            for (P p : param) {
                if (!this.filter.accept(p)) continue;
                al.add(this.elementFactory.create(p));
            }
            Object[] a = (Object[])Array.newInstance(this.productClass, al.size());
            return al.toArray(a);
        }

        private static Class getProductClass(Class[] classes) {
            if (classes == null || classes.length < 1) {
                return null;
            }
            return classes[0];
        }
    }
}

